/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class EventFilter {
    @JsonProperty(value="entities")
    private List<String> entities = null;
    @JsonProperty(value="eventType")
    private EventTypeEnum eventType = null;

    public EventFilter entities(List<String> entities) {
        this.entities = entities;
        return this;
    }

    public EventFilter addEntitiesItem(String entitiesItem) {
        if (this.entities == null) {
            this.entities = new ArrayList<String>();
        }
        this.entities.add(entitiesItem);
        return this;
    }

    @Schema(description="")
    public List<String> getEntities() {
        return this.entities;
    }

    public void setEntities(List<String> entities) {
        this.entities = entities;
    }

    public EventFilter eventType(EventTypeEnum eventType) {
        this.eventType = eventType;
        return this;
    }

    @Schema(required=true, description="")
    public EventTypeEnum getEventType() {
        return this.eventType;
    }

    public void setEventType(EventTypeEnum eventType) {
        this.eventType = eventType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventFilter eventFilter = (EventFilter)o;
        return Objects.equals(this.entities, eventFilter.entities) && Objects.equals((Object)this.eventType, (Object)eventFilter.eventType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.entities, this.eventType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventFilter {\n");
        sb.append("    entities: ").append(this.toIndentedString(this.entities)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString((Object)this.eventType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EventTypeEnum {
        ENTITYCREATED("entityCreated"),
        ENTITYUPDATED("entityUpdated"),
        ENTITYSOFTDELETED("entitySoftDeleted"),
        ENTITYDELETED("entityDeleted");

        private String value;

        private EventTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EventTypeEnum fromValue(String text) {
            for (EventTypeEnum b : EventTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

