/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ResourceDescriptor {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="operations")
    private List<OperationsEnum> operations = null;

    public ResourceDescriptor name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResourceDescriptor operations(List<OperationsEnum> operations) {
        this.operations = operations;
        return this;
    }

    public ResourceDescriptor addOperationsItem(OperationsEnum operationsItem) {
        if (this.operations == null) {
            this.operations = new ArrayList<OperationsEnum>();
        }
        this.operations.add(operationsItem);
        return this;
    }

    @Schema(description="")
    public List<OperationsEnum> getOperations() {
        return this.operations;
    }

    public void setOperations(List<OperationsEnum> operations) {
        this.operations = operations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceDescriptor resourceDescriptor = (ResourceDescriptor)o;
        return Objects.equals(this.name, resourceDescriptor.name) && Objects.equals(this.operations, resourceDescriptor.operations);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.operations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceDescriptor {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    operations: ").append(this.toIndentedString(this.operations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OperationsEnum {
        ALL("All"),
        CREATE("Create"),
        DELETE("Delete"),
        VIEWALL("ViewAll"),
        VIEWUSAGE("ViewUsage"),
        VIEWTESTS("ViewTests"),
        VIEWQUERIES("ViewQueries"),
        VIEWDATAPROFILE("ViewDataProfile"),
        VIEWSAMPLEDATA("ViewSampleData"),
        EDITALL("EditAll"),
        EDITDESCRIPTION("EditDescription"),
        EDITTAGS("EditTags"),
        EDITOWNER("EditOwner"),
        EDITTIER("EditTier"),
        EDITCUSTOMFIELDS("EditCustomFields"),
        EDITLINEAGE("EditLineage"),
        EDITREVIEWERS("EditReviewers"),
        EDITTESTS("EditTests"),
        EDITQUERIES("EditQueries"),
        EDITDATAPROFILE("EditDataProfile"),
        EDITSAMPLEDATA("EditSampleData"),
        EDITUSERS("EditUsers");

        private String value;

        private OperationsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OperationsEnum fromValue(String text) {
            for (OperationsEnum b : OperationsEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

