/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.gateway;

import com.fasterxml.jackson.annotation.JsonInclude;
import feign.Client;
import feign.Feign;
import feign.RequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormEncoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.okhttp.OkHttpClient;
import feign.slf4j.Slf4jLogger;
import io.swagger.client.ApiClient;
import io.swagger.client.api.CatalogApi;
import org.openmetadata.catalog.api.CatalogVersion;
import org.openmetadata.catalog.services.connections.metadata.OpenMetadataServerConnection;
import org.openmetadata.client.interceptors.CustomRequestInterceptor;
import org.openmetadata.client.security.factory.AuthenticationProviderFactory;
import org.openmetadata.core.util.VersionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(OpenMetadata.class);
    private static final CatalogVersion CATALOG_VERSION_CLIENT = VersionUtils.getCatalogVersion((String)"/catalog/VERSION");
    private ApiClient apiClient;
    private OpenMetadataServerConnection serverConfig;
    private String basePath;
    private final String requestInterceptorKey = "custom";

    public OpenMetadata(OpenMetadataServerConnection config) {
        this.initClient(config);
        this.validateVersion();
    }

    public OpenMetadata(OpenMetadataServerConnection config, boolean validateVersion) {
        this.initClient(config);
        if (validateVersion) {
            this.validateVersion();
        }
    }

    public void initClient(OpenMetadataServerConnection config) {
        this.serverConfig = config;
        this.apiClient = new ApiClient();
        Feign.Builder builder = Feign.builder().encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder(this.apiClient.getObjectMapper()))).decoder((Decoder)new JacksonDecoder(this.apiClient.getObjectMapper())).logger((feign.Logger)new Slf4jLogger()).client((Client)new OkHttpClient());
        this.apiClient.setFeignBuilder(builder);
        AuthenticationProviderFactory factory = new AuthenticationProviderFactory();
        this.apiClient.addAuthorization("oauth", factory.getAuthProvider(config));
        this.basePath = config.getHostPort() + "/";
        this.apiClient.setBasePath(this.basePath);
        this.apiClient.getObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public <T extends ApiClient.Api> T buildClient(Class<T> clientClass) {
        return this.apiClient.buildClient(clientClass);
    }

    public <T extends ApiClient.Api, K> T buildClient(Class<T> clientClass, Class<K> requestClass) {
        this.updateRequestType(requestClass);
        return this.apiClient.buildClient(clientClass);
    }

    public <K> void updateRequestType(Class<K> requestClass) {
        if (this.apiClient.getApiAuthorizations().containsKey("custom")) {
            this.apiClient.getApiAuthorizations().remove("custom");
        }
        CustomRequestInterceptor<K> newInterceptor = new CustomRequestInterceptor<K>(this.apiClient.getObjectMapper(), requestClass);
        this.apiClient.addAuthorization("custom", newInterceptor);
    }

    public void addRequestInterceptor(String requestInterceptorKey, RequestInterceptor interceptor) {
        if (this.apiClient.getApiAuthorizations().containsKey(requestInterceptorKey)) {
            LOG.info("Interceptor with this key already exists");
            return;
        }
        this.apiClient.addAuthorization(requestInterceptorKey, interceptor);
    }

    public void validateVersion() {
        String[] clientVersion = this.getClientVersion();
        String[] serverVersion = this.getServerVersion();
        if (serverVersion[0].equals(clientVersion[0]) && serverVersion[1].equals(clientVersion[1]) && serverVersion[2].equals(clientVersion[2])) {
            LOG.debug("OpenMetaData Client Initialized successfully.");
        } else {
            LOG.error("OpenMetaData Client Failed to be Initialized successfully. Version mismatch between CLient and Server issue");
        }
    }

    public String[] getServerVersion() {
        CatalogApi api = this.apiClient.buildClient(CatalogApi.class);
        io.swagger.client.model.CatalogVersion serverVersion = api.getCatalogVersion();
        return VersionUtils.getVersionFromString((String)serverVersion.getVersion());
    }

    public String[] getClientVersion() {
        return VersionUtils.getVersionFromString((String)CATALOG_VERSION_CLIENT.getVersion());
    }
}

