/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.interceptors;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.openmetadata.catalog.security.client.Auth0SSOClientConfig;
import org.openmetadata.client.model.AccessTokenResponse;

public class Auth0AccessTokenRequestInterceptor
implements RequestInterceptor {
    private final Auth0SSOClientConfig securityConfig;

    public Auth0AccessTokenRequestInterceptor(Auth0SSOClientConfig config) {
        this.securityConfig = config;
    }

    public void apply(RequestTemplate requestTemplate) {
        String requestBody = "grant_type=" + AccessTokenResponse.GrantType.CLIENT_CREDENTIALS + "&client_id=" + this.securityConfig.getClientId() + "&client_secret=" + this.securityConfig.getSecretKey() + "&audience=https://" + this.securityConfig.getDomain() + "/api/v2/";
        requestTemplate.body(requestBody);
    }
}

