/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.interceptors;

import feign.RequestTemplate;
import java.util.Base64;
import org.openmetadata.catalog.services.connections.metadata.OpenMetadataServerConnection;
import org.openmetadata.client.model.OktaSSOConfig;
import org.openmetadata.client.security.interfaces.AuthenticationProvider;

public class OktaAccessTokenRequestInterceptor
implements AuthenticationProvider {
    private OktaSSOConfig securityConfig;
    private String base64Credentials;

    public OktaAccessTokenRequestInterceptor(OktaSSOConfig config) {
        this.securityConfig = config;
    }

    public void apply(RequestTemplate requestTemplate) {
        if (requestTemplate.headers().containsKey("Authorization")) {
            return;
        }
        if (this.base64Credentials == null) {
            this.authToken();
        }
        requestTemplate.header("Authorization", new String[]{"Basic " + this.getAccessToken()});
    }

    @Override
    public AuthenticationProvider create(OpenMetadataServerConnection iConfig) {
        return new OktaAccessTokenRequestInterceptor((OktaSSOConfig)iConfig.getSecurityConfig());
    }

    @Override
    public String authToken() {
        this.base64Credentials = Base64.getEncoder().encodeToString((this.securityConfig.getClientId() + ":" + this.securityConfig.getClientSecret()).getBytes());
        return this.base64Credentials;
    }

    @Override
    public String getAccessToken() {
        return this.base64Credentials;
    }
}

