/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.security;

import feign.RequestTemplate;
import io.swagger.client.ApiClient;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.openmetadata.catalog.security.client.Auth0SSOClientConfig;
import org.openmetadata.catalog.services.connections.metadata.OpenMetadataServerConnection;
import org.openmetadata.client.interceptors.Auth0AccessTokenRequestInterceptor;
import org.openmetadata.client.model.AccessTokenResponse;
import org.openmetadata.client.security.interfaces.Auth0AccessTokenApi;
import org.openmetadata.client.security.interfaces.AuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Auth0AuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(Auth0AuthenticationProvider.class);
    private OpenMetadataServerConnection serverConfig;
    private final Auth0SSOClientConfig securityConfig;
    private String generatedAuthToken;
    private Long expirationTimeMillis;
    private final Auth0AccessTokenApi auth0SSOClient;

    public Auth0AuthenticationProvider(OpenMetadataServerConnection iConfig) {
        if (!iConfig.getAuthProvider().equals((Object)OpenMetadataServerConnection.AuthProvider.AUTH_0)) {
            LOG.error("Required type to invoke is Auth0 for Auth0Authentication Provider");
            throw new RuntimeException("Required type to invoke is Auth0 for Auth0Authentication Provider");
        }
        this.serverConfig = iConfig;
        this.securityConfig = (Auth0SSOClientConfig)iConfig.getSecurityConfig();
        if (this.securityConfig == null) {
            LOG.error("Security Config is missing, it is required");
            throw new RuntimeException("Security Config is missing, it is required");
        }
        this.generatedAuthToken = "";
        ApiClient auth0SSO = new ApiClient();
        auth0SSO.setBasePath("https://" + this.securityConfig.getDomain());
        Auth0AccessTokenRequestInterceptor interceptor = new Auth0AccessTokenRequestInterceptor(this.securityConfig);
        auth0SSO.addAuthorization("0AuthToken", interceptor);
        this.auth0SSOClient = auth0SSO.buildClient(Auth0AccessTokenApi.class);
    }

    @Override
    public AuthenticationProvider create(OpenMetadataServerConnection iConfig) {
        return new Auth0AuthenticationProvider(iConfig);
    }

    @Override
    public String authToken() {
        AccessTokenResponse resp = this.auth0SSOClient.getAccessToken();
        this.generatedAuthToken = resp.getAccessToken();
        this.expirationTimeMillis = Date.from(Instant.now().plus((long)resp.getExpiresIn(), ChronoUnit.SECONDS)).getTime();
        return this.generatedAuthToken;
    }

    @Override
    public String getAccessToken() {
        return this.generatedAuthToken;
    }

    public void apply(RequestTemplate requestTemplate) {
        if (requestTemplate.url().contains("version")) {
            return;
        }
        if (requestTemplate.headers().containsKey("Authorization")) {
            return;
        }
        if (this.expirationTimeMillis == null || System.currentTimeMillis() >= this.expirationTimeMillis) {
            this.authToken();
        }
        if (this.getAccessToken() != null) {
            requestTemplate.header("Authorization", new String[]{"Bearer " + this.getAccessToken()});
        }
    }
}

