/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.security;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import io.swagger.client.ApiClient;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.openmetadata.catalog.security.client.CustomOIDCSSOClientConfig;
import org.openmetadata.catalog.services.connections.metadata.OpenMetadataServerConnection;
import org.openmetadata.client.model.AccessTokenResponse;
import org.openmetadata.client.security.interfaces.AuthenticationProvider;
import org.openmetadata.client.security.interfaces.CustomOIDCAccessTokenApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomOIDCAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CustomOIDCAuthenticationProvider.class);
    private OpenMetadataServerConnection serverConfig;
    private final CustomOIDCSSOClientConfig securityConfig;
    private String generatedAuthToken;
    private Long expirationTimeMillis;
    private final CustomOIDCAccessTokenApi customSSOClient;

    public CustomOIDCAuthenticationProvider(OpenMetadataServerConnection iConfig) {
        if (!iConfig.getAuthProvider().equals((Object)OpenMetadataServerConnection.AuthProvider.CUSTOM_OIDC)) {
            LOG.error("Required type to invoke is CustomOIDC for CustomOIDCAuthentication Provider");
            throw new RuntimeException("Required type to invoke is CustomOIDC for CustomOIDCAuthentication Provider");
        }
        this.serverConfig = iConfig;
        this.securityConfig = (CustomOIDCSSOClientConfig)iConfig.getSecurityConfig();
        if (this.securityConfig == null) {
            LOG.error("Security Config is missing, it is required");
            throw new RuntimeException("Security Config is missing, it is required");
        }
        this.generatedAuthToken = "";
        ApiClient customOIDCSSO = new ApiClient();
        customOIDCSSO.setBasePath(this.securityConfig.getTokenEndpoint());
        RequestInterceptor requestInterceptor = requestTemplate -> {
            String requestBody = "grant_type=" + AccessTokenResponse.GrantType.CLIENT_CREDENTIALS + "&client_id=" + this.securityConfig.getClientId() + "&client_secret=" + this.securityConfig.getSecretKey();
            requestTemplate.body(requestBody);
        };
        customOIDCSSO.addAuthorization("OAuthToken", requestInterceptor);
        this.customSSOClient = customOIDCSSO.buildClient(CustomOIDCAccessTokenApi.class);
    }

    @Override
    public AuthenticationProvider create(OpenMetadataServerConnection iConfig) {
        return new CustomOIDCAuthenticationProvider(iConfig);
    }

    @Override
    public String authToken() {
        AccessTokenResponse resp = this.customSSOClient.getAccessToken();
        this.generatedAuthToken = resp.getAccessToken();
        this.expirationTimeMillis = Date.from(Instant.now().plus((long)resp.getExpiresIn(), ChronoUnit.SECONDS)).getTime();
        return this.generatedAuthToken;
    }

    @Override
    public String getAccessToken() {
        return this.generatedAuthToken;
    }

    public void apply(RequestTemplate requestTemplate) {
        if (requestTemplate.url().contains("version")) {
            return;
        }
        if (requestTemplate.headers().containsKey("Authorization")) {
            return;
        }
        if (this.expirationTimeMillis == null || System.currentTimeMillis() >= this.expirationTimeMillis) {
            this.authToken();
        }
        if (this.getAccessToken() != null) {
            requestTemplate.header("Authorization", new String[]{"Bearer " + this.getAccessToken()});
        }
    }
}

