/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.security;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.IdTokenCredentials;
import com.google.auth.oauth2.IdTokenProvider;
import com.google.auth.oauth2.ServiceAccountCredentials;
import feign.RequestTemplate;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.openmetadata.catalog.security.client.GoogleSSOClientConfig;
import org.openmetadata.catalog.services.connections.metadata.OpenMetadataServerConnection;
import org.openmetadata.client.security.interfaces.AuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleAuthenticationProvider.class);
    private OpenMetadataServerConnection serverConfig;
    private GoogleSSOClientConfig securityConfig;
    private String generatedAuthToken;
    private Long expirationTimeMillis;
    private final String OPENID_SCOPE = "https://www.googleapis.com/auth/plus.me";
    private final String PROFILE_SCOPE = "https://www.googleapis.com/auth/userinfo.profile";
    private final String EMAIL_SCOPE = "https://www.googleapis.com/auth/userinfo.email";

    public GoogleAuthenticationProvider(OpenMetadataServerConnection iConfig) {
        if (!iConfig.getAuthProvider().equals((Object)OpenMetadataServerConnection.AuthProvider.GOOGLE)) {
            LOG.error("Required type to invoke is Google for GoogleAuthentication Provider");
            throw new RuntimeException("Required type to invoke is Google for GoogleAuthentication Provider");
        }
        this.serverConfig = iConfig;
        this.securityConfig = (GoogleSSOClientConfig)iConfig.getSecurityConfig();
        if (this.securityConfig == null) {
            LOG.error("Security Config is missing, it is required");
            throw new RuntimeException("Security Config is missing, it is required");
        }
        this.generatedAuthToken = "";
    }

    @Override
    public AuthenticationProvider create(OpenMetadataServerConnection iConfig) {
        return new GoogleAuthenticationProvider(iConfig);
    }

    @Override
    public String authToken() {
        try {
            String credPath = this.securityConfig.getSecretKey();
            String targetAudience = this.securityConfig.getAudience();
            if (credPath != null && !credPath.equals("") && targetAudience != null && !targetAudience.equals("")) {
                ServiceAccountCredentials saCreds = ServiceAccountCredentials.fromStream((InputStream)new FileInputStream(credPath));
                saCreds = (ServiceAccountCredentials)saCreds.createScoped(Arrays.asList("https://www.googleapis.com/auth/plus.me", "https://www.googleapis.com/auth/userinfo.profile", "https://www.googleapis.com/auth/userinfo.email"));
                IdTokenCredentials tokenCredential = IdTokenCredentials.newBuilder().setIdTokenProvider((IdTokenProvider)saCreds).setTargetAudience(targetAudience).build();
                AccessToken token = tokenCredential.refreshAccessToken();
                this.expirationTimeMillis = token.getExpirationTime().getTime();
                this.generatedAuthToken = token.getTokenValue();
            } else {
                LOG.error("Credentials Path or Target Audience is null");
            }
        }
        catch (Exception ex) {
            LOG.error("Google Authentication Provider error in getting access token" + ex.getMessage());
        }
        return this.generatedAuthToken;
    }

    @Override
    public String getAccessToken() {
        return this.generatedAuthToken;
    }

    public void apply(RequestTemplate requestTemplate) {
        if (requestTemplate.url().contains("version")) {
            return;
        }
        if (requestTemplate.headers().containsKey("Authorization")) {
            return;
        }
        if (this.expirationTimeMillis == null || System.currentTimeMillis() >= this.expirationTimeMillis) {
            this.authToken();
        }
        if (this.getAccessToken() != null) {
            requestTemplate.header("Authorization", new String[]{"Bearer " + this.getAccessToken()});
        }
    }
}

