/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.security;

import feign.RequestTemplate;
import org.openmetadata.catalog.security.client.OpenMetadataJWTClientConfig;
import org.openmetadata.catalog.services.connections.metadata.OpenMetadataServerConnection;
import org.openmetadata.client.security.interfaces.AuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenMetadataAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OpenMetadataAuthenticationProvider.class);
    private final OpenMetadataJWTClientConfig securityConfig;
    private String generatedAuthToken;
    private Long expirationTimeMillis;

    public OpenMetadataAuthenticationProvider(OpenMetadataServerConnection iConfig) {
        if (!iConfig.getAuthProvider().equals((Object)OpenMetadataServerConnection.AuthProvider.OPENMETADATA)) {
            LOG.error("Required type to invoke is OpenMetadata for OpenMetadataAuthentication Provider");
            throw new RuntimeException("Required type to invoke is OpenMetadata for OpenMetadataAuthentication Provider");
        }
        this.securityConfig = (OpenMetadataJWTClientConfig)iConfig.getSecurityConfig();
        if (this.securityConfig == null) {
            LOG.error("Security Config is missing, it is required");
            throw new RuntimeException("Security Config is missing, it is required");
        }
        this.generatedAuthToken = "";
    }

    @Override
    public AuthenticationProvider create(OpenMetadataServerConnection iConfig) {
        return new OpenMetadataAuthenticationProvider(iConfig);
    }

    @Override
    public String authToken() {
        this.generatedAuthToken = this.securityConfig.getJwtToken();
        return this.generatedAuthToken;
    }

    @Override
    public String getAccessToken() {
        return this.generatedAuthToken;
    }

    public void apply(RequestTemplate requestTemplate) {
        if (requestTemplate.url().contains("version")) {
            return;
        }
        if (requestTemplate.headers().containsKey("Authorization")) {
            return;
        }
        if (this.expirationTimeMillis == null || System.currentTimeMillis() >= this.expirationTimeMillis) {
            this.authToken();
        }
        if (this.getAccessToken() != null) {
            requestTemplate.header("Authorization", new String[]{"Bearer " + this.getAccessToken()});
        }
    }
}

