/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.Classification;
import org.openmetadata.client.model.ClassificationList;
import org.openmetadata.client.model.CreateClassification;
import org.openmetadata.client.model.CreateTag;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.Table;
import org.openmetadata.client.model.Tag;
import org.openmetadata.client.model.TagList;

public interface ClassificationsApi
extends ApiClient.Api {
    @RequestLine(value="POST /v1/classifications")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Classification createClassification(CreateClassification var1);

    @RequestLine(value="POST /v1/classifications")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Classification> createClassificationWithHttpInfo(CreateClassification var1);

    @RequestLine(value="PUT /v1/classifications")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void createOrUpdateClassification(CreateClassification var1);

    @RequestLine(value="PUT /v1/classifications")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> createOrUpdateClassificationWithHttpInfo(CreateClassification var1);

    @RequestLine(value="PUT /v1/tags")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Tag createOrUpdateTag(CreateTag var1);

    @RequestLine(value="PUT /v1/tags")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Tag> createOrUpdateTagWithHttpInfo(CreateTag var1);

    @RequestLine(value="POST /v1/tags")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Tag createTag(CreateTag var1);

    @RequestLine(value="POST /v1/tags")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Tag> createTagWithHttpInfo(CreateTag var1);

    @RequestLine(value="DELETE /v1/classifications/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteClassification(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/classifications/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteClassificationWithHttpInfo(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/classifications/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteClassification(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/classifications/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteClassificationWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/classifications/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteClassificationByName(@Param(value="name") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/classifications/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteClassificationByNameWithHttpInfo(@Param(value="name") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/classifications/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteClassificationByName(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/classifications/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteClassificationByNameWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/tags/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTag(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/tags/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTagWithHttpInfo(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/tags/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTag(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/tags/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTagWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/tags/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTagByName(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/tags/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTagByNameWithHttpInfo(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/tags/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTagByName(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/tags/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTagByNameWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/classifications/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Classification getClassificationByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/classifications/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Classification> getClassificationByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/classifications/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Classification getClassificationByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/classifications/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Classification> getClassificationByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/classifications/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Classification getClassificationByName(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/classifications/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Classification> getClassificationByNameWithHttpInfo(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/classifications/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Classification getClassificationByName(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/classifications/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Classification> getClassificationByNameWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/classifications/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Classification getSpecificClassificationVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/classifications/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Classification> getSpecificClassificationVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/tags/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Tag getSpecificTagVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/tags/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Tag> getSpecificTagVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/tags/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Tag getTagByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/tags/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Tag> getTagByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/tags/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Tag getTagByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/tags/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Tag> getTagByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/tags/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Tag getTagByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/tags/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Tag> getTagByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/tags/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Tag getTagByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/tags/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Tag> getTagByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/classifications/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllClassificationVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/classifications/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllClassificationVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/tags/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllTagVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/tags/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllTagVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/classifications?fields={fields}&disabled={disabled}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ClassificationList listClassifications(@Param(value="fields") String var1, @Param(value="disabled") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/classifications?fields={fields}&disabled={disabled}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ClassificationList> listClassificationsWithHttpInfo(@Param(value="fields") String var1, @Param(value="disabled") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/classifications?fields={fields}&disabled={disabled}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ClassificationList listClassifications(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/classifications?fields={fields}&disabled={disabled}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ClassificationList> listClassificationsWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/tags?parent={parent}&fields={fields}&disabled={disabled}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TagList listTags(@Param(value="parent") String var1, @Param(value="fields") String var2, @Param(value="disabled") String var3, @Param(value="limit") Integer var4, @Param(value="before") String var5, @Param(value="after") String var6, @Param(value="include") String var7);

    @RequestLine(value="GET /v1/tags?parent={parent}&fields={fields}&disabled={disabled}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TagList> listTagsWithHttpInfo(@Param(value="parent") String var1, @Param(value="fields") String var2, @Param(value="disabled") String var3, @Param(value="limit") Integer var4, @Param(value="before") String var5, @Param(value="after") String var6, @Param(value="include") String var7);

    @RequestLine(value="GET /v1/tags?parent={parent}&fields={fields}&disabled={disabled}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TagList listTags(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/tags?parent={parent}&fields={fields}&disabled={disabled}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TagList> listTagsWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/classifications/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchClassification(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/classifications/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchClassificationWithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/tags/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchTag(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/tags/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchTagWithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PUT /v1/classifications/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table restoreClassification(RestoreEntity var1);

    @RequestLine(value="PUT /v1/classifications/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Table> restoreClassificationWithHttpInfo(RestoreEntity var1);

    @RequestLine(value="PUT /v1/tags/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Tag restoreTag(RestoreEntity var1);

    @RequestLine(value="PUT /v1/tags/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Tag> restoreTagWithHttpInfo(RestoreEntity var1);

    public static class ListTagsQueryParams
    extends HashMap<String, Object> {
        public ListTagsQueryParams parent(String value) {
            this.put("parent", EncodingUtils.encode(value));
            return this;
        }

        public ListTagsQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListTagsQueryParams disabled(String value) {
            this.put("disabled", EncodingUtils.encode(value));
            return this;
        }

        public ListTagsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListTagsQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListTagsQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListTagsQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListClassificationsQueryParams
    extends HashMap<String, Object> {
        public ListClassificationsQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListClassificationsQueryParams disabled(String value) {
            this.put("disabled", EncodingUtils.encode(value));
            return this;
        }

        public ListClassificationsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListClassificationsQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListClassificationsQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListClassificationsQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTagByIDQueryParams
    extends HashMap<String, Object> {
        public GetTagByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTagByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTagByFQNQueryParams
    extends HashMap<String, Object> {
        public GetTagByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTagByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetClassificationByNameQueryParams
    extends HashMap<String, Object> {
        public GetClassificationByNameQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetClassificationByNameQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetClassificationByIDQueryParams
    extends HashMap<String, Object> {
        public GetClassificationByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetClassificationByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTagByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteTagByNameQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTagQueryParams
    extends HashMap<String, Object> {
        public DeleteTagQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteTagQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteClassificationByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteClassificationByNameQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteClassificationQueryParams
    extends HashMap<String, Object> {
        public DeleteClassificationQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteClassificationQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

