/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.Map;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CloseTask;
import org.openmetadata.client.model.CreatePost;
import org.openmetadata.client.model.CreateThread;
import org.openmetadata.client.model.PostList;
import org.openmetadata.client.model.ResolveTask;
import org.openmetadata.client.model.Thread;
import org.openmetadata.client.model.ThreadCount;
import org.openmetadata.client.model.ThreadList;

public interface FeedsApi
extends ApiClient.Api {
    @RequestLine(value="POST /v1/feed/{id}/posts")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Thread addPostToThread(@Param(value="id") String var1, CreatePost var2);

    @RequestLine(value="POST /v1/feed/{id}/posts")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Thread> addPostToThreadWithHttpInfo(@Param(value="id") String var1, CreatePost var2);

    @RequestLine(value="PUT /v1/feed/tasks/{id}/close")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Thread closeTask(@Param(value="id") String var1, CloseTask var2);

    @RequestLine(value="PUT /v1/feed/tasks/{id}/close")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Thread> closeTaskWithHttpInfo(@Param(value="id") String var1, CloseTask var2);

    @RequestLine(value="GET /v1/feed/count?entityLink={entityLink}&type={type}&taskStatus={taskStatus}&isResolved={isResolved}")
    @Headers(value={"Accept: application/json"})
    public ThreadCount countThreads(@Param(value="entityLink") String var1, @Param(value="type") String var2, @Param(value="taskStatus") String var3, @Param(value="isResolved") Boolean var4);

    @RequestLine(value="GET /v1/feed/count?entityLink={entityLink}&type={type}&taskStatus={taskStatus}&isResolved={isResolved}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ThreadCount> countThreadsWithHttpInfo(@Param(value="entityLink") String var1, @Param(value="type") String var2, @Param(value="taskStatus") String var3, @Param(value="isResolved") Boolean var4);

    @RequestLine(value="GET /v1/feed/count?entityLink={entityLink}&type={type}&taskStatus={taskStatus}&isResolved={isResolved}")
    @Headers(value={"Accept: application/json"})
    public ThreadCount countThreads(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/feed/count?entityLink={entityLink}&type={type}&taskStatus={taskStatus}&isResolved={isResolved}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ThreadCount> countThreadsWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="POST /v1/feed")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Thread createThread(CreateThread var1);

    @RequestLine(value="POST /v1/feed")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Thread> createThreadWithHttpInfo(CreateThread var1);

    @RequestLine(value="DELETE /v1/feed/{threadId}/posts/{postId}")
    @Headers(value={"Accept: application/json"})
    public void deletePostFromThread(@Param(value="threadId") String var1, @Param(value="postId") String var2);

    @RequestLine(value="DELETE /v1/feed/{threadId}/posts/{postId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePostFromThreadWithHttpInfo(@Param(value="threadId") String var1, @Param(value="postId") String var2);

    @RequestLine(value="DELETE /v1/feed/{threadId}")
    @Headers(value={"Accept: application/json"})
    public void deleteThread(@Param(value="threadId") String var1);

    @RequestLine(value="DELETE /v1/feed/{threadId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteThreadWithHttpInfo(@Param(value="threadId") String var1);

    @RequestLine(value="GET /v1/feed/{id}/posts")
    @Headers(value={"Accept: application/json"})
    public PostList getAllPostOfThread(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/feed/{id}/posts")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PostList> getAllPostOfThreadWithHttpInfo(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/feed/tasks/{id}")
    @Headers(value={"Accept: application/json"})
    public Thread getTaskByID(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/feed/tasks/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Thread> getTaskByIDWithHttpInfo(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/feed/{id}")
    @Headers(value={"Accept: application/json"})
    public Thread getThreadByID(@Param(value="id") String var1, @Param(value="entityType") String var2);

    @RequestLine(value="GET /v1/feed/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Thread> getThreadByIDWithHttpInfo(@Param(value="id") String var1, @Param(value="entityType") String var2);

    @RequestLine(value="GET /v1/feed?limitPosts={limitPosts}&limit={limit}&before={before}&after={after}&entityLink={entityLink}&userId={userId}&filterType={filterType}&resolved={resolved}&type={type}&taskStatus={taskStatus}&activeAnnouncement={activeAnnouncement}")
    @Headers(value={"Accept: application/json"})
    public ThreadList listThreads(@Param(value="limitPosts") Long var1, @Param(value="limit") Integer var2, @Param(value="before") String var3, @Param(value="after") String var4, @Param(value="entityLink") String var5, @Param(value="userId") String var6, @Param(value="filterType") String var7, @Param(value="resolved") Boolean var8, @Param(value="type") String var9, @Param(value="taskStatus") String var10, @Param(value="activeAnnouncement") Boolean var11);

    @RequestLine(value="GET /v1/feed?limitPosts={limitPosts}&limit={limit}&before={before}&after={after}&entityLink={entityLink}&userId={userId}&filterType={filterType}&resolved={resolved}&type={type}&taskStatus={taskStatus}&activeAnnouncement={activeAnnouncement}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ThreadList> listThreadsWithHttpInfo(@Param(value="limitPosts") Long var1, @Param(value="limit") Integer var2, @Param(value="before") String var3, @Param(value="after") String var4, @Param(value="entityLink") String var5, @Param(value="userId") String var6, @Param(value="filterType") String var7, @Param(value="resolved") Boolean var8, @Param(value="type") String var9, @Param(value="taskStatus") String var10, @Param(value="activeAnnouncement") Boolean var11);

    @RequestLine(value="GET /v1/feed?limitPosts={limitPosts}&limit={limit}&before={before}&after={after}&entityLink={entityLink}&userId={userId}&filterType={filterType}&resolved={resolved}&type={type}&taskStatus={taskStatus}&activeAnnouncement={activeAnnouncement}")
    @Headers(value={"Accept: application/json"})
    public ThreadList listThreads(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/feed?limitPosts={limitPosts}&limit={limit}&before={before}&after={after}&entityLink={entityLink}&userId={userId}&filterType={filterType}&resolved={resolved}&type={type}&taskStatus={taskStatus}&activeAnnouncement={activeAnnouncement}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ThreadList> listThreadsWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/feed/{threadId}/posts/{postId}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchPostOfThread(@Param(value="threadId") String var1, @Param(value="postId") String var2, Object var3);

    @RequestLine(value="PATCH /v1/feed/{threadId}/posts/{postId}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchPostOfThreadWithHttpInfo(@Param(value="threadId") String var1, @Param(value="postId") String var2, Object var3);

    @RequestLine(value="PATCH /v1/feed/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchThread(@Param(value="id") String var1, Object var2);

    @RequestLine(value="PATCH /v1/feed/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchThreadWithHttpInfo(@Param(value="id") String var1, Object var2);

    @RequestLine(value="PUT /v1/feed/tasks/{id}/resolve")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Thread resolveTask(@Param(value="id") String var1, ResolveTask var2);

    @RequestLine(value="PUT /v1/feed/tasks/{id}/resolve")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Thread> resolveTaskWithHttpInfo(@Param(value="id") String var1, ResolveTask var2);

    public static class ListThreadsQueryParams
    extends HashMap<String, Object> {
        public ListThreadsQueryParams limitPosts(Long value) {
            this.put("limitPosts", EncodingUtils.encode(value));
            return this;
        }

        public ListThreadsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListThreadsQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListThreadsQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListThreadsQueryParams entityLink(String value) {
            this.put("entityLink", EncodingUtils.encode(value));
            return this;
        }

        public ListThreadsQueryParams userId(String value) {
            this.put("userId", EncodingUtils.encode(value));
            return this;
        }

        public ListThreadsQueryParams filterType(String value) {
            this.put("filterType", EncodingUtils.encode(value));
            return this;
        }

        public ListThreadsQueryParams resolved(Boolean value) {
            this.put("resolved", EncodingUtils.encode(value));
            return this;
        }

        public ListThreadsQueryParams type(String value) {
            this.put("type", EncodingUtils.encode(value));
            return this;
        }

        public ListThreadsQueryParams taskStatus(String value) {
            this.put("taskStatus", EncodingUtils.encode(value));
            return this;
        }

        public ListThreadsQueryParams activeAnnouncement(Boolean value) {
            this.put("activeAnnouncement", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class CountThreadsQueryParams
    extends HashMap<String, Object> {
        public CountThreadsQueryParams entityLink(String value) {
            this.put("entityLink", EncodingUtils.encode(value));
            return this;
        }

        public CountThreadsQueryParams type(String value) {
            this.put("type", EncodingUtils.encode(value));
            return this;
        }

        public CountThreadsQueryParams taskStatus(String value) {
            this.put("taskStatus", EncodingUtils.encode(value));
            return this;
        }

        public CountThreadsQueryParams isResolved(Boolean value) {
            this.put("isResolved", EncodingUtils.encode(value));
            return this;
        }
    }
}

