/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CreateGlossary;
import org.openmetadata.client.model.CreateGlossaryTerm;
import org.openmetadata.client.model.CsvImportResult;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.Glossary;
import org.openmetadata.client.model.GlossaryList;
import org.openmetadata.client.model.GlossaryTerm;
import org.openmetadata.client.model.GlossaryTermList;
import org.openmetadata.client.model.RestoreEntity;

public interface GlossariesApi
extends ApiClient.Api {
    @RequestLine(value="POST /v1/glossaries")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Glossary createGlossary(CreateGlossary var1);

    @RequestLine(value="POST /v1/glossaries")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Glossary> createGlossaryWithHttpInfo(CreateGlossary var1);

    @RequestLine(value="POST /v1/glossaryTerms")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public GlossaryTerm createGlossaryTerm(CreateGlossaryTerm var1);

    @RequestLine(value="POST /v1/glossaryTerms")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<GlossaryTerm> createGlossaryTermWithHttpInfo(CreateGlossaryTerm var1);

    @RequestLine(value="PUT /v1/glossaries")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Glossary createOrUpdateGlossary(CreateGlossary var1);

    @RequestLine(value="PUT /v1/glossaries")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Glossary> createOrUpdateGlossaryWithHttpInfo(CreateGlossary var1);

    @RequestLine(value="PUT /v1/glossaryTerms")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public GlossaryTerm createOrUpdateGlossaryTerm(CreateGlossaryTerm var1);

    @RequestLine(value="PUT /v1/glossaryTerms")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<GlossaryTerm> createOrUpdateGlossaryTermWithHttpInfo(CreateGlossaryTerm var1);

    @RequestLine(value="DELETE /v1/glossaryTerms/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void delete(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/glossaryTerms/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteWithHttpInfo(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/glossaryTerms/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void delete(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/glossaryTerms/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/glossaries/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteGlossary(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/glossaries/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteGlossaryWithHttpInfo(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/glossaries/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteGlossary(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/glossaries/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteGlossaryWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/glossaries/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteGlossaryByName(@Param(value="name") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/glossaries/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteGlossaryByNameWithHttpInfo(@Param(value="name") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/glossaries/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteGlossaryByName(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/glossaries/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteGlossaryByNameWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/glossaryTerms/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteGlossaryTermByName(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/glossaryTerms/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteGlossaryTermByNameWithHttpInfo(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/glossaryTerms/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteGlossaryTermByName(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/glossaryTerms/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteGlossaryTermByNameWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/glossaries/name/{name}/export")
    @Headers(value={"Accept: application/json"})
    public String exportGlossary(@Param(value="name") String var1);

    @RequestLine(value="GET /v1/glossaries/name/{name}/export")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<String> exportGlossaryWithHttpInfo(@Param(value="name") String var1);

    @RequestLine(value="GET /v1/glossaries/documentation/csv")
    @Headers(value={"Accept: application/json"})
    public String getCsvDocumentation(@Param(value="name") String var1);

    @RequestLine(value="GET /v1/glossaries/documentation/csv")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<String> getCsvDocumentationWithHttpInfo(@Param(value="name") String var1);

    @RequestLine(value="GET /v1/glossaries/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Glossary getGlossaryByFQN(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/glossaries/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Glossary> getGlossaryByFQNWithHttpInfo(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/glossaries/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Glossary getGlossaryByFQN(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/glossaries/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Glossary> getGlossaryByFQNWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/glossaries/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Glossary getGlossaryByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/glossaries/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Glossary> getGlossaryByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/glossaries/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Glossary getGlossaryByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/glossaries/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Glossary> getGlossaryByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/glossaryTerms/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Glossary getGlossaryTermByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/glossaryTerms/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Glossary> getGlossaryTermByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/glossaryTerms/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Glossary getGlossaryTermByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/glossaryTerms/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Glossary> getGlossaryTermByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/glossaryTerms/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Glossary getGlossaryTermByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/glossaryTerms/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Glossary> getGlossaryTermByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/glossaryTerms/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Glossary getGlossaryTermByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/glossaryTerms/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Glossary> getGlossaryTermByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/glossaryTerms/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Glossary getSpecificGlossaryTermVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/glossaryTerms/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Glossary> getSpecificGlossaryTermVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/glossaries/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Glossary getSpecificGlossaryVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/glossaries/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Glossary> getSpecificGlossaryVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="PUT /v1/glossaries/name/{name}/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public CsvImportResult importGlossary(@Param(value="name") String var1, @Param(value="dryRun") Boolean var2, String var3);

    @RequestLine(value="PUT /v1/glossaries/name/{name}/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importGlossaryWithHttpInfo(@Param(value="name") String var1, @Param(value="dryRun") Boolean var2, String var3);

    @RequestLine(value="PUT /v1/glossaries/name/{name}/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public CsvImportResult importGlossary(@Param(value="name") String var1, String var2, @QueryMap(encoded=true) Map<String, Object> var3);

    @RequestLine(value="PUT /v1/glossaries/name/{name}/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importGlossaryWithHttpInfo(@Param(value="name") String var1, String var2, @QueryMap(encoded=true) Map<String, Object> var3);

    @RequestLine(value="GET /v1/glossaryTerms/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllGlossaryTermVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/glossaryTerms/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllGlossaryTermVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/glossaries/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllGlossaryVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/glossaries/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllGlossaryVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/glossaries?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public GlossaryList listGlossaries(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="before") String var3, @Param(value="after") String var4, @Param(value="include") String var5);

    @RequestLine(value="GET /v1/glossaries?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<GlossaryList> listGlossariesWithHttpInfo(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="before") String var3, @Param(value="after") String var4, @Param(value="include") String var5);

    @RequestLine(value="GET /v1/glossaries?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public GlossaryList listGlossaries(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/glossaries?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<GlossaryList> listGlossariesWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/glossaryTerms?glossary={glossary}&parent={parent}&fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public GlossaryTermList listGlossaryTerm(@Param(value="glossary") String var1, @Param(value="parent") String var2, @Param(value="fields") String var3, @Param(value="limit") Integer var4, @Param(value="before") String var5, @Param(value="after") String var6, @Param(value="include") String var7);

    @RequestLine(value="GET /v1/glossaryTerms?glossary={glossary}&parent={parent}&fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<GlossaryTermList> listGlossaryTermWithHttpInfo(@Param(value="glossary") String var1, @Param(value="parent") String var2, @Param(value="fields") String var3, @Param(value="limit") Integer var4, @Param(value="before") String var5, @Param(value="after") String var6, @Param(value="include") String var7);

    @RequestLine(value="GET /v1/glossaryTerms?glossary={glossary}&parent={parent}&fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public GlossaryTermList listGlossaryTerm(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/glossaryTerms?glossary={glossary}&parent={parent}&fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<GlossaryTermList> listGlossaryTermWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/glossaries/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchGlossary(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/glossaries/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchGlossaryWithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/glossaryTerms/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchGlossaryTerm(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/glossaryTerms/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchGlossaryTermWithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PUT /v1/glossaries/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Glossary restore10(RestoreEntity var1);

    @RequestLine(value="PUT /v1/glossaries/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Glossary> restore10WithHttpInfo(RestoreEntity var1);

    @RequestLine(value="PUT /v1/glossaryTerms/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public GlossaryTerm restore11(RestoreEntity var1);

    @RequestLine(value="PUT /v1/glossaryTerms/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<GlossaryTerm> restore11WithHttpInfo(RestoreEntity var1);

    public static class ListGlossaryTermQueryParams
    extends HashMap<String, Object> {
        public ListGlossaryTermQueryParams glossary(String value) {
            this.put("glossary", EncodingUtils.encode(value));
            return this;
        }

        public ListGlossaryTermQueryParams parent(String value) {
            this.put("parent", EncodingUtils.encode(value));
            return this;
        }

        public ListGlossaryTermQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListGlossaryTermQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListGlossaryTermQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListGlossaryTermQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListGlossaryTermQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListGlossariesQueryParams
    extends HashMap<String, Object> {
        public ListGlossariesQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListGlossariesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListGlossariesQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListGlossariesQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListGlossariesQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ImportGlossaryQueryParams
    extends HashMap<String, Object> {
        public ImportGlossaryQueryParams dryRun(Boolean value) {
            this.put("dryRun", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetGlossaryTermByIDQueryParams
    extends HashMap<String, Object> {
        public GetGlossaryTermByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetGlossaryTermByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetGlossaryTermByFQNQueryParams
    extends HashMap<String, Object> {
        public GetGlossaryTermByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetGlossaryTermByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetGlossaryByIDQueryParams
    extends HashMap<String, Object> {
        public GetGlossaryByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetGlossaryByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetGlossaryByFQNQueryParams
    extends HashMap<String, Object> {
        public GetGlossaryByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetGlossaryByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteGlossaryTermByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteGlossaryTermByNameQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteGlossaryByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteGlossaryByNameQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteGlossaryQueryParams
    extends HashMap<String, Object> {
        public DeleteGlossaryQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteGlossaryQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteQueryParams
    extends HashMap<String, Object> {
        public DeleteQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

