/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CreateMetadataService;
import org.openmetadata.client.model.DatabaseService;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.MetadataService;
import org.openmetadata.client.model.MetadataServiceList;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.Table;
import org.openmetadata.client.model.TestConnectionResult;

public interface MetadataServicesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/services/metadataServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DatabaseService addTestConnectionResult3(@Param(value="id") UUID var1, TestConnectionResult var2);

    @RequestLine(value="PUT /v1/services/metadataServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DatabaseService> addTestConnectionResult3WithHttpInfo(@Param(value="id") UUID var1, TestConnectionResult var2);

    @RequestLine(value="POST /v1/services/metadataServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public MetadataService createMetadataService(CreateMetadataService var1);

    @RequestLine(value="POST /v1/services/metadataServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<MetadataService> createMetadataServiceWithHttpInfo(CreateMetadataService var1);

    @RequestLine(value="PUT /v1/services/metadataServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public MetadataService createOrUpdateMetadataService(CreateMetadataService var1);

    @RequestLine(value="PUT /v1/services/metadataServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<MetadataService> createOrUpdateMetadataServiceWithHttpInfo(CreateMetadataService var1);

    @RequestLine(value="DELETE /v1/services/metadataServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMetadataService(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/services/metadataServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMetadataServiceWithHttpInfo(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/services/metadataServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMetadataService(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/services/metadataServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMetadataServiceWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/services/metadataServices/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMetadataServiceByName(@Param(value="name") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/services/metadataServices/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMetadataServiceByNameWithHttpInfo(@Param(value="name") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/services/metadataServices/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMetadataServiceByName(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/services/metadataServices/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMetadataServiceByNameWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/services/metadataServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MetadataService getMetadataServiceByFQN(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/metadataServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MetadataService> getMetadataServiceByFQNWithHttpInfo(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/metadataServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MetadataService getMetadataServiceByFQN(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/services/metadataServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MetadataService> getMetadataServiceByFQNWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/services/metadataServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MetadataService getMetadataServiceByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/metadataServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MetadataService> getMetadataServiceByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/metadataServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MetadataService getMetadataServiceByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/services/metadataServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MetadataService> getMetadataServiceByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/services/metadataServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public MetadataService getSpecificMetadataServiceVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/services/metadataServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MetadataService> getSpecificMetadataServiceVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/services/metadataServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllMetadataServiceVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/services/metadataServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllMetadataServiceVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/services/metadataServices?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MetadataServiceList listMetadataServices(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="before") String var3, @Param(value="after") String var4, @Param(value="include") String var5);

    @RequestLine(value="GET /v1/services/metadataServices?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MetadataServiceList> listMetadataServicesWithHttpInfo(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="before") String var3, @Param(value="after") String var4, @Param(value="include") String var5);

    @RequestLine(value="GET /v1/services/metadataServices?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MetadataServiceList listMetadataServices(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/services/metadataServices?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MetadataServiceList> listMetadataServicesWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/services/metadataServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchMetadataService(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/services/metadataServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchMetadataServiceWithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PUT /v1/services/metadataServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table restore19(RestoreEntity var1);

    @RequestLine(value="PUT /v1/services/metadataServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Table> restore19WithHttpInfo(RestoreEntity var1);

    public static class ListMetadataServicesQueryParams
    extends HashMap<String, Object> {
        public ListMetadataServicesQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListMetadataServicesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListMetadataServicesQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListMetadataServicesQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListMetadataServicesQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetMetadataServiceByIDQueryParams
    extends HashMap<String, Object> {
        public GetMetadataServiceByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetMetadataServiceByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetMetadataServiceByFQNQueryParams
    extends HashMap<String, Object> {
        public GetMetadataServiceByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetMetadataServiceByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteMetadataServiceByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteMetadataServiceByNameQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteMetadataServiceQueryParams
    extends HashMap<String, Object> {
        public DeleteMetadataServiceQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteMetadataServiceQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

