/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.TestCaseParameter;

@JsonPropertyOrder(value={"description", "displayName", "entityType", "extension", "name", "owner", "parameterDefinition", "supportedDataTypes", "testPlatforms"})
public class CreateTestDefinition {
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;
    public static final String JSON_PROPERTY_ENTITY_TYPE = "entityType";
    private EntityTypeEnum entityType;
    public static final String JSON_PROPERTY_EXTENSION = "extension";
    private Object extension;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OWNER = "owner";
    private EntityReference owner;
    public static final String JSON_PROPERTY_PARAMETER_DEFINITION = "parameterDefinition";
    private List<TestCaseParameter> parameterDefinition = null;
    public static final String JSON_PROPERTY_SUPPORTED_DATA_TYPES = "supportedDataTypes";
    private List<SupportedDataTypesEnum> supportedDataTypes = null;
    public static final String JSON_PROPERTY_TEST_PLATFORMS = "testPlatforms";
    private List<TestPlatformsEnum> testPlatforms = new ArrayList<TestPlatformsEnum>();

    public CreateTestDefinition description(String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateTestDefinition displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateTestDefinition entityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="entityType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EntityTypeEnum getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="entityType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEntityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
    }

    public CreateTestDefinition extension(Object extension) {
        this.extension = extension;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public CreateTestDefinition name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public CreateTestDefinition owner(EntityReference owner) {
        this.owner = owner;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwner(EntityReference owner) {
        this.owner = owner;
    }

    public CreateTestDefinition parameterDefinition(List<TestCaseParameter> parameterDefinition) {
        this.parameterDefinition = parameterDefinition;
        return this;
    }

    public CreateTestDefinition addParameterDefinitionItem(TestCaseParameter parameterDefinitionItem) {
        if (this.parameterDefinition == null) {
            this.parameterDefinition = new ArrayList<TestCaseParameter>();
        }
        this.parameterDefinition.add(parameterDefinitionItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="parameterDefinition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TestCaseParameter> getParameterDefinition() {
        return this.parameterDefinition;
    }

    @JsonProperty(value="parameterDefinition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParameterDefinition(List<TestCaseParameter> parameterDefinition) {
        this.parameterDefinition = parameterDefinition;
    }

    public CreateTestDefinition supportedDataTypes(List<SupportedDataTypesEnum> supportedDataTypes) {
        this.supportedDataTypes = supportedDataTypes;
        return this;
    }

    public CreateTestDefinition addSupportedDataTypesItem(SupportedDataTypesEnum supportedDataTypesItem) {
        if (this.supportedDataTypes == null) {
            this.supportedDataTypes = new ArrayList<SupportedDataTypesEnum>();
        }
        this.supportedDataTypes.add(supportedDataTypesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="supportedDataTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SupportedDataTypesEnum> getSupportedDataTypes() {
        return this.supportedDataTypes;
    }

    @JsonProperty(value="supportedDataTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSupportedDataTypes(List<SupportedDataTypesEnum> supportedDataTypes) {
        this.supportedDataTypes = supportedDataTypes;
    }

    public CreateTestDefinition testPlatforms(List<TestPlatformsEnum> testPlatforms) {
        this.testPlatforms = testPlatforms;
        return this;
    }

    public CreateTestDefinition addTestPlatformsItem(TestPlatformsEnum testPlatformsItem) {
        this.testPlatforms.add(testPlatformsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="testPlatforms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<TestPlatformsEnum> getTestPlatforms() {
        return this.testPlatforms;
    }

    @JsonProperty(value="testPlatforms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTestPlatforms(List<TestPlatformsEnum> testPlatforms) {
        this.testPlatforms = testPlatforms;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTestDefinition createTestDefinition = (CreateTestDefinition)o;
        return Objects.equals(this.description, createTestDefinition.description) && Objects.equals(this.displayName, createTestDefinition.displayName) && Objects.equals((Object)this.entityType, (Object)createTestDefinition.entityType) && Objects.equals(this.extension, createTestDefinition.extension) && Objects.equals(this.name, createTestDefinition.name) && Objects.equals(this.owner, createTestDefinition.owner) && Objects.equals(this.parameterDefinition, createTestDefinition.parameterDefinition) && Objects.equals(this.supportedDataTypes, createTestDefinition.supportedDataTypes) && Objects.equals(this.testPlatforms, createTestDefinition.testPlatforms);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.displayName, this.entityType, this.extension, this.name, this.owner, this.parameterDefinition, this.supportedDataTypes, this.testPlatforms});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateTestDefinition {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    entityType: ").append(this.toIndentedString((Object)this.entityType)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    parameterDefinition: ").append(this.toIndentedString(this.parameterDefinition)).append("\n");
        sb.append("    supportedDataTypes: ").append(this.toIndentedString(this.supportedDataTypes)).append("\n");
        sb.append("    testPlatforms: ").append(this.toIndentedString(this.testPlatforms)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TestPlatformsEnum {
        OPENMETADATA("OpenMetadata"),
        GREATEXPECTATIONS("GreatExpectations"),
        DBT("DBT"),
        DEEQU("Deequ"),
        SODA("Soda"),
        OTHER("Other");

        private String value;

        private TestPlatformsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TestPlatformsEnum fromValue(String value) {
            for (TestPlatformsEnum b : TestPlatformsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum SupportedDataTypesEnum {
        NUMBER("NUMBER"),
        TINYINT("TINYINT"),
        SMALLINT("SMALLINT"),
        INT("INT"),
        BIGINT("BIGINT"),
        BYTEINT("BYTEINT"),
        BYTES("BYTES"),
        FLOAT("FLOAT"),
        DOUBLE("DOUBLE"),
        DECIMAL("DECIMAL"),
        NUMERIC("NUMERIC"),
        TIMESTAMP("TIMESTAMP"),
        TIMESTAMPZ("TIMESTAMPZ"),
        TIME("TIME"),
        DATE("DATE"),
        DATETIME("DATETIME"),
        INTERVAL("INTERVAL"),
        STRING("STRING"),
        MEDIUMTEXT("MEDIUMTEXT"),
        TEXT("TEXT"),
        CHAR("CHAR"),
        LONG("LONG"),
        VARCHAR("VARCHAR"),
        BOOLEAN("BOOLEAN"),
        BINARY("BINARY"),
        VARBINARY("VARBINARY"),
        ARRAY("ARRAY"),
        BLOB("BLOB"),
        LONGBLOB("LONGBLOB"),
        MEDIUMBLOB("MEDIUMBLOB"),
        MAP("MAP"),
        STRUCT("STRUCT"),
        UNION("UNION"),
        SET("SET"),
        GEOGRAPHY("GEOGRAPHY"),
        ENUM("ENUM"),
        JSON("JSON"),
        UUID("UUID"),
        VARIANT("VARIANT"),
        GEOMETRY("GEOMETRY"),
        BYTEA("BYTEA"),
        AGGREGATEFUNCTION("AGGREGATEFUNCTION"),
        ERROR("ERROR"),
        FIXED("FIXED"),
        RECORD("RECORD"),
        NULL("NULL"),
        SUPER("SUPER"),
        HLLSKETCH("HLLSKETCH"),
        PG_LSN("PG_LSN"),
        PG_SNAPSHOT("PG_SNAPSHOT"),
        TSQUERY("TSQUERY"),
        TXID_SNAPSHOT("TXID_SNAPSHOT"),
        XML("XML"),
        MACADDR("MACADDR"),
        TSVECTOR("TSVECTOR"),
        UNKNOWN("UNKNOWN"),
        CIDR("CIDR"),
        INET("INET"),
        CLOB("CLOB"),
        ROWID("ROWID"),
        LOWCARDINALITY("LOWCARDINALITY"),
        YEAR("YEAR"),
        POINT("POINT"),
        POLYGON("POLYGON"),
        TUPLE("TUPLE"),
        SPATIAL("SPATIAL"),
        TABLE("TABLE"),
        NTEXT("NTEXT"),
        IMAGE("IMAGE"),
        IPV4("IPV4"),
        IPV6("IPV6"),
        DATETIMERANGE("DATETIMERANGE");

        private String value;

        private SupportedDataTypesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SupportedDataTypesEnum fromValue(String value) {
            for (SupportedDataTypesEnum b : SupportedDataTypesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum EntityTypeEnum {
        TABLE("TABLE"),
        COLUMN("COLUMN");

        private String value;

        private EntityTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EntityTypeEnum fromValue(String value) {
            for (EntityTypeEnum b : EntityTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

