/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"JWTToken", "JWTTokenExpiresAt", "JWTTokenExpiry"})
public class JWTAuthMechanism {
    public static final String JSON_PROPERTY_JW_T_TOKEN = "JWTToken";
    private String jwTToken;
    public static final String JSON_PROPERTY_JW_T_TOKEN_EXPIRES_AT = "JWTTokenExpiresAt";
    private Long jwTTokenExpiresAt;
    public static final String JSON_PROPERTY_JW_T_TOKEN_EXPIRY = "JWTTokenExpiry";
    private JwTTokenExpiryEnum jwTTokenExpiry;

    public JWTAuthMechanism jwTToken(String jwTToken) {
        this.jwTToken = jwTToken;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="JWTToken")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getJwTToken() {
        return this.jwTToken;
    }

    @JsonProperty(value="JWTToken")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setJwTToken(String jwTToken) {
        this.jwTToken = jwTToken;
    }

    public JWTAuthMechanism jwTTokenExpiresAt(Long jwTTokenExpiresAt) {
        this.jwTTokenExpiresAt = jwTTokenExpiresAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="JWTTokenExpiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getJwTTokenExpiresAt() {
        return this.jwTTokenExpiresAt;
    }

    @JsonProperty(value="JWTTokenExpiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJwTTokenExpiresAt(Long jwTTokenExpiresAt) {
        this.jwTTokenExpiresAt = jwTTokenExpiresAt;
    }

    public JWTAuthMechanism jwTTokenExpiry(JwTTokenExpiryEnum jwTTokenExpiry) {
        this.jwTTokenExpiry = jwTTokenExpiry;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="JWTTokenExpiry")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public JwTTokenExpiryEnum getJwTTokenExpiry() {
        return this.jwTTokenExpiry;
    }

    @JsonProperty(value="JWTTokenExpiry")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setJwTTokenExpiry(JwTTokenExpiryEnum jwTTokenExpiry) {
        this.jwTTokenExpiry = jwTTokenExpiry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JWTAuthMechanism jwTAuthMechanism = (JWTAuthMechanism)o;
        return Objects.equals(this.jwTToken, jwTAuthMechanism.jwTToken) && Objects.equals(this.jwTTokenExpiresAt, jwTAuthMechanism.jwTTokenExpiresAt) && Objects.equals((Object)this.jwTTokenExpiry, (Object)jwTAuthMechanism.jwTTokenExpiry);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jwTToken, this.jwTTokenExpiresAt, this.jwTTokenExpiry});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JWTAuthMechanism {\n");
        sb.append("    jwTToken: ").append(this.toIndentedString(this.jwTToken)).append("\n");
        sb.append("    jwTTokenExpiresAt: ").append(this.toIndentedString(this.jwTTokenExpiresAt)).append("\n");
        sb.append("    jwTTokenExpiry: ").append(this.toIndentedString((Object)this.jwTTokenExpiry)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum JwTTokenExpiryEnum {
        ONEHOUR("OneHour"),
        _1("1"),
        _7("7"),
        _30("30"),
        _60("60"),
        _90("90"),
        UNLIMITED("Unlimited");

        private String value;

        private JwTTokenExpiryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static JwTTokenExpiryEnum fromValue(String value) {
            for (JwTTokenExpiryEnum b : JwTTokenExpiryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

