/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openmetadata.client.model.Field;

@JsonPropertyOrder(value={"schemaFields", "schemaText", "schemaType"})
public class MessageSchema {
    public static final String JSON_PROPERTY_SCHEMA_FIELDS = "schemaFields";
    private List<Field> schemaFields = null;
    public static final String JSON_PROPERTY_SCHEMA_TEXT = "schemaText";
    private String schemaText;
    public static final String JSON_PROPERTY_SCHEMA_TYPE = "schemaType";
    private SchemaTypeEnum schemaType;

    public MessageSchema schemaFields(List<Field> schemaFields) {
        this.schemaFields = schemaFields;
        return this;
    }

    public MessageSchema addSchemaFieldsItem(Field schemaFieldsItem) {
        if (this.schemaFields == null) {
            this.schemaFields = new ArrayList<Field>();
        }
        this.schemaFields.add(schemaFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="schemaFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Field> getSchemaFields() {
        return this.schemaFields;
    }

    @JsonProperty(value="schemaFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchemaFields(List<Field> schemaFields) {
        this.schemaFields = schemaFields;
    }

    public MessageSchema schemaText(String schemaText) {
        this.schemaText = schemaText;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="schemaText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSchemaText() {
        return this.schemaText;
    }

    @JsonProperty(value="schemaText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchemaText(String schemaText) {
        this.schemaText = schemaText;
    }

    public MessageSchema schemaType(SchemaTypeEnum schemaType) {
        this.schemaType = schemaType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="schemaType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SchemaTypeEnum getSchemaType() {
        return this.schemaType;
    }

    @JsonProperty(value="schemaType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchemaType(SchemaTypeEnum schemaType) {
        this.schemaType = schemaType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageSchema messageSchema = (MessageSchema)o;
        return Objects.equals(this.schemaFields, messageSchema.schemaFields) && Objects.equals(this.schemaText, messageSchema.schemaText) && Objects.equals((Object)this.schemaType, (Object)messageSchema.schemaType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.schemaFields, this.schemaText, this.schemaType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageSchema {\n");
        sb.append("    schemaFields: ").append(this.toIndentedString(this.schemaFields)).append("\n");
        sb.append("    schemaText: ").append(this.toIndentedString(this.schemaText)).append("\n");
        sb.append("    schemaType: ").append(this.toIndentedString((Object)this.schemaType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SchemaTypeEnum {
        AVRO("Avro"),
        PROTOBUF("Protobuf"),
        JSON("JSON"),
        OTHER("Other"),
        NONE("None");

        private String value;

        private SchemaTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SchemaTypeEnum fromValue(String value) {
            for (SchemaTypeEnum b : SchemaTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

