/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openmetadata.client.model.MlFeatureSource;
import org.openmetadata.client.model.TagLabel;

@JsonPropertyOrder(value={"dataType", "description", "featureAlgorithm", "featureSources", "fullyQualifiedName", "name", "tags"})
public class MlFeature {
    public static final String JSON_PROPERTY_DATA_TYPE = "dataType";
    private DataTypeEnum dataType;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_FEATURE_ALGORITHM = "featureAlgorithm";
    private String featureAlgorithm;
    public static final String JSON_PROPERTY_FEATURE_SOURCES = "featureSources";
    private List<MlFeatureSource> featureSources = null;
    public static final String JSON_PROPERTY_FULLY_QUALIFIED_NAME = "fullyQualifiedName";
    private String fullyQualifiedName;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<TagLabel> tags = null;

    public MlFeature dataType(DataTypeEnum dataType) {
        this.dataType = dataType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="dataType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DataTypeEnum getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="dataType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataType(DataTypeEnum dataType) {
        this.dataType = dataType;
    }

    public MlFeature description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public MlFeature featureAlgorithm(String featureAlgorithm) {
        this.featureAlgorithm = featureAlgorithm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="featureAlgorithm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFeatureAlgorithm() {
        return this.featureAlgorithm;
    }

    @JsonProperty(value="featureAlgorithm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFeatureAlgorithm(String featureAlgorithm) {
        this.featureAlgorithm = featureAlgorithm;
    }

    public MlFeature featureSources(List<MlFeatureSource> featureSources) {
        this.featureSources = featureSources;
        return this;
    }

    public MlFeature addFeatureSourcesItem(MlFeatureSource featureSourcesItem) {
        if (this.featureSources == null) {
            this.featureSources = new ArrayList<MlFeatureSource>();
        }
        this.featureSources.add(featureSourcesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="featureSources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MlFeatureSource> getFeatureSources() {
        return this.featureSources;
    }

    @JsonProperty(value="featureSources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFeatureSources(List<MlFeatureSource> featureSources) {
        this.featureSources = featureSources;
    }

    public MlFeature fullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public MlFeature name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public MlFeature tags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    public MlFeature addTagsItem(TagLabel tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagLabel>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MlFeature mlFeature = (MlFeature)o;
        return Objects.equals((Object)this.dataType, (Object)mlFeature.dataType) && Objects.equals(this.description, mlFeature.description) && Objects.equals(this.featureAlgorithm, mlFeature.featureAlgorithm) && Objects.equals(this.featureSources, mlFeature.featureSources) && Objects.equals(this.fullyQualifiedName, mlFeature.fullyQualifiedName) && Objects.equals(this.name, mlFeature.name) && Objects.equals(this.tags, mlFeature.tags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dataType, this.description, this.featureAlgorithm, this.featureSources, this.fullyQualifiedName, this.name, this.tags});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MlFeature {\n");
        sb.append("    dataType: ").append(this.toIndentedString((Object)this.dataType)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    featureAlgorithm: ").append(this.toIndentedString(this.featureAlgorithm)).append("\n");
        sb.append("    featureSources: ").append(this.toIndentedString(this.featureSources)).append("\n");
        sb.append("    fullyQualifiedName: ").append(this.toIndentedString(this.fullyQualifiedName)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DataTypeEnum {
        NUMERICAL("numerical"),
        CATEGORICAL("categorical");

        private String value;

        private DataTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DataTypeEnum fromValue(String value) {
            for (DataTypeEnum b : DataTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

