/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.Status;

@JsonPropertyOrder(value={"executionStatus", "taskStatus", "timestamp"})
public class PipelineStatus {
    public static final String JSON_PROPERTY_EXECUTION_STATUS = "executionStatus";
    private ExecutionStatusEnum executionStatus;
    public static final String JSON_PROPERTY_TASK_STATUS = "taskStatus";
    private List<Status> taskStatus = null;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private Long timestamp;

    public PipelineStatus executionStatus(ExecutionStatusEnum executionStatus) {
        this.executionStatus = executionStatus;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="executionStatus")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ExecutionStatusEnum getExecutionStatus() {
        return this.executionStatus;
    }

    @JsonProperty(value="executionStatus")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExecutionStatus(ExecutionStatusEnum executionStatus) {
        this.executionStatus = executionStatus;
    }

    public PipelineStatus taskStatus(List<Status> taskStatus) {
        this.taskStatus = taskStatus;
        return this;
    }

    public PipelineStatus addTaskStatusItem(Status taskStatusItem) {
        if (this.taskStatus == null) {
            this.taskStatus = new ArrayList<Status>();
        }
        this.taskStatus.add(taskStatusItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="taskStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Status> getTaskStatus() {
        return this.taskStatus;
    }

    @JsonProperty(value="taskStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTaskStatus(List<Status> taskStatus) {
        this.taskStatus = taskStatus;
    }

    public PipelineStatus timestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineStatus pipelineStatus = (PipelineStatus)o;
        return Objects.equals((Object)this.executionStatus, (Object)pipelineStatus.executionStatus) && Objects.equals(this.taskStatus, pipelineStatus.taskStatus) && Objects.equals(this.timestamp, pipelineStatus.timestamp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.executionStatus, this.taskStatus, this.timestamp});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PipelineStatus {\n");
        sb.append("    executionStatus: ").append(this.toIndentedString((Object)this.executionStatus)).append("\n");
        sb.append("    taskStatus: ").append(this.toIndentedString(this.taskStatus)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ExecutionStatusEnum {
        SUCCESSFUL("Successful"),
        FAILED("Failed"),
        PENDING("Pending");

        private String value;

        private ExecutionStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ExecutionStatusEnum fromValue(String value) {
            for (ExecutionStatusEnum b : ExecutionStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

