/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.security;

import feign.RequestTemplate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.interceptors.OktaAccessTokenRequestInterceptor;
import org.openmetadata.client.model.AccessTokenResponse;
import org.openmetadata.client.model.OktaSSOConfig;
import org.openmetadata.client.security.interfaces.AuthenticationProvider;
import org.openmetadata.client.security.interfaces.OktaAccessTokenApi;
import org.openmetadata.schema.services.connections.metadata.AuthProvider;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OktaAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OktaAuthenticationProvider.class);
    private String generatedAuthToken;
    private Long expirationTimeMillis;
    private final OktaAccessTokenApi oktaSSOClient;

    public OktaAuthenticationProvider(OpenMetadataConnection iConfig) {
        if (!iConfig.getAuthProvider().equals((Object)AuthProvider.OKTA)) {
            LOG.error("Required type to invoke is OKTA for OKTA Authentication Provider");
            throw new RuntimeException("Required type to invoke is OKTA for OKTA Authentication Provider");
        }
        OktaSSOConfig securityConfig = (OktaSSOConfig)iConfig.getSecurityConfig();
        if (securityConfig == null) {
            LOG.error("Security Config is missing, it is required");
            throw new RuntimeException("Security Config is missing, it is required");
        }
        this.generatedAuthToken = "";
        ApiClient oktaSSO = new ApiClient();
        oktaSSO.setBasePath(securityConfig.getAuthorizationServerURL());
        OktaAccessTokenRequestInterceptor interceptor = new OktaAccessTokenRequestInterceptor(securityConfig);
        oktaSSO.addAuthorization("OAuthToken", interceptor);
        this.oktaSSOClient = oktaSSO.buildClient(OktaAccessTokenApi.class);
    }

    @Override
    public AuthenticationProvider create(OpenMetadataConnection iConfig) {
        return new OktaAuthenticationProvider(iConfig);
    }

    @Override
    public String authToken() {
        AccessTokenResponse resp = this.oktaSSOClient.getAccessToken("client_credentials", "test");
        this.generatedAuthToken = resp.getAccessToken();
        this.expirationTimeMillis = Date.from(Instant.now().plus((long)resp.getExpiresIn(), ChronoUnit.SECONDS)).getTime();
        return this.generatedAuthToken;
    }

    @Override
    public String getAccessToken() {
        return this.generatedAuthToken;
    }

    public void apply(RequestTemplate requestTemplate) {
        if (requestTemplate.url().contains("version")) {
            return;
        }
        if (requestTemplate.headers().containsKey("Authorization")) {
            return;
        }
        if (this.expirationTimeMillis == null || System.currentTimeMillis() >= this.expirationTimeMillis) {
            this.authToken();
        }
        if (this.getAccessToken() != null) {
            requestTemplate.header("Authorization", new String[]{"Bearer " + this.getAccessToken()});
        }
    }
}

