/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.EntityReference;

@JsonPropertyOrder(value={"associatedTags", "classification", "description", "displayName", "extension", "mutuallyExclusive", "name", "owner", "parent", "provider"})
public class CreateTag {
    public static final String JSON_PROPERTY_ASSOCIATED_TAGS = "associatedTags";
    private List<String> associatedTags = null;
    public static final String JSON_PROPERTY_CLASSIFICATION = "classification";
    private String classification;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;
    public static final String JSON_PROPERTY_EXTENSION = "extension";
    private Object extension;
    public static final String JSON_PROPERTY_MUTUALLY_EXCLUSIVE = "mutuallyExclusive";
    private Boolean mutuallyExclusive;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OWNER = "owner";
    private EntityReference owner;
    public static final String JSON_PROPERTY_PARENT = "parent";
    private String parent;
    public static final String JSON_PROPERTY_PROVIDER = "provider";
    private ProviderEnum provider;

    public CreateTag associatedTags(List<String> associatedTags) {
        this.associatedTags = associatedTags;
        return this;
    }

    public CreateTag addAssociatedTagsItem(String associatedTagsItem) {
        if (this.associatedTags == null) {
            this.associatedTags = new ArrayList<String>();
        }
        this.associatedTags.add(associatedTagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="associatedTags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAssociatedTags() {
        return this.associatedTags;
    }

    @JsonProperty(value="associatedTags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssociatedTags(List<String> associatedTags) {
        this.associatedTags = associatedTags;
    }

    public CreateTag classification(String classification) {
        this.classification = classification;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="classification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClassification() {
        return this.classification;
    }

    @JsonProperty(value="classification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClassification(String classification) {
        this.classification = classification;
    }

    public CreateTag description(String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateTag displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateTag extension(Object extension) {
        this.extension = extension;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public CreateTag mutuallyExclusive(Boolean mutuallyExclusive) {
        this.mutuallyExclusive = mutuallyExclusive;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="mutuallyExclusive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMutuallyExclusive() {
        return this.mutuallyExclusive;
    }

    @JsonProperty(value="mutuallyExclusive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMutuallyExclusive(Boolean mutuallyExclusive) {
        this.mutuallyExclusive = mutuallyExclusive;
    }

    public CreateTag name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public CreateTag owner(EntityReference owner) {
        this.owner = owner;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwner(EntityReference owner) {
        this.owner = owner;
    }

    public CreateTag parent(String parent) {
        this.parent = parent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="parent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getParent() {
        return this.parent;
    }

    @JsonProperty(value="parent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParent(String parent) {
        this.parent = parent;
    }

    public CreateTag provider(ProviderEnum provider) {
        this.provider = provider;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProviderEnum getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProvider(ProviderEnum provider) {
        this.provider = provider;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTag createTag = (CreateTag)o;
        return Objects.equals(this.associatedTags, createTag.associatedTags) && Objects.equals(this.classification, createTag.classification) && Objects.equals(this.description, createTag.description) && Objects.equals(this.displayName, createTag.displayName) && Objects.equals(this.extension, createTag.extension) && Objects.equals(this.mutuallyExclusive, createTag.mutuallyExclusive) && Objects.equals(this.name, createTag.name) && Objects.equals(this.owner, createTag.owner) && Objects.equals(this.parent, createTag.parent) && Objects.equals((Object)this.provider, (Object)createTag.provider);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.associatedTags, this.classification, this.description, this.displayName, this.extension, this.mutuallyExclusive, this.name, this.owner, this.parent, this.provider});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateTag {\n");
        sb.append("    associatedTags: ").append(this.toIndentedString(this.associatedTags)).append("\n");
        sb.append("    classification: ").append(this.toIndentedString(this.classification)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("    mutuallyExclusive: ").append(this.toIndentedString(this.mutuallyExclusive)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    parent: ").append(this.toIndentedString(this.parent)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString((Object)this.provider)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProviderEnum {
        SYSTEM("system"),
        USER("user");

        private String value;

        private ProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProviderEnum fromValue(String value) {
            for (ProviderEnum b : ProviderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

