/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateMlModel;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.MlModel;
import org.openmetadata.client.model.MlModelList;
import org.openmetadata.client.model.RestoreEntity;

public interface MlModelsApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/mlmodels/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollower(@Param(value="id") UUID var1, UUID var2);

    @RequestLine(value="PUT /v1/mlmodels/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerWithHttpInfo(@Param(value="id") UUID var1, UUID var2);

    @RequestLine(value="POST /v1/mlmodels")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public MlModel createMlModel(CreateMlModel var1);

    @RequestLine(value="POST /v1/mlmodels")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<MlModel> createMlModelWithHttpInfo(CreateMlModel var1);

    @RequestLine(value="PUT /v1/mlmodels")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public MlModel createOrUpdateMlModel(CreateMlModel var1);

    @RequestLine(value="PUT /v1/mlmodels")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<MlModel> createOrUpdateMlModelWithHttpInfo(CreateMlModel var1);

    @RequestLine(value="DELETE /v1/mlmodels/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower1(@Param(value="id") UUID var1, @Param(value="userId") UUID var2);

    @RequestLine(value="DELETE /v1/mlmodels/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower1WithHttpInfo(@Param(value="id") UUID var1, @Param(value="userId") UUID var2);

    @RequestLine(value="DELETE /v1/mlmodels/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMlModel(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/mlmodels/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMlModelWithHttpInfo(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/mlmodels/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMlModel(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/mlmodels/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMlModelWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/mlmodels/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMlModelByFQN(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/mlmodels/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMlModelByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/mlmodels/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMlModelByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/mlmodels/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMlModelByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/mlmodels/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MlModel getMlModelByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/mlmodels/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MlModel> getMlModelByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/mlmodels/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MlModel getMlModelByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/mlmodels/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MlModel> getMlModelByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/mlmodels/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MlModel getMlModelByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/mlmodels/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MlModel> getMlModelByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/mlmodels/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MlModel getMlModelByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/mlmodels/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MlModel> getMlModelByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/mlmodels/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public MlModel getSpecificMlModelVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/mlmodels/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MlModel> getSpecificMlModelVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/mlmodels/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllMlModelVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/mlmodels/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllMlModelVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/mlmodels?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MlModelList listMlModels(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/mlmodels?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MlModelList> listMlModelsWithHttpInfo(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/mlmodels?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MlModelList listMlModels(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/mlmodels?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MlModelList> listMlModelsWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/mlmodels/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchMlModel(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/mlmodels/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchMlModelWithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PUT /v1/mlmodels/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public MlModel restore12(RestoreEntity var1);

    @RequestLine(value="PUT /v1/mlmodels/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<MlModel> restore12WithHttpInfo(RestoreEntity var1);

    public static class ListMlModelsQueryParams
    extends HashMap<String, Object> {
        public ListMlModelsQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListMlModelsQueryParams service(String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListMlModelsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListMlModelsQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListMlModelsQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListMlModelsQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetMlModelByIDQueryParams
    extends HashMap<String, Object> {
        public GetMlModelByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetMlModelByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetMlModelByFQNQueryParams
    extends HashMap<String, Object> {
        public GetMlModelByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetMlModelByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteMlModelByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteMlModelByFQNQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteMlModelQueryParams
    extends HashMap<String, Object> {
        public DeleteMlModelQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

