/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateQuery;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.Query;
import org.openmetadata.client.model.QueryList;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.VoteRequest;

public interface QueriesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/queries/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollower2(@Param(value="id") UUID var1, UUID var2);

    @RequestLine(value="PUT /v1/queries/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollower2WithHttpInfo(@Param(value="id") UUID var1, UUID var2);

    @RequestLine(value="PUT /v1/queries/{id}/usage")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Query addQueryUsage(@Param(value="id") UUID var1, List<EntityReference> var2);

    @RequestLine(value="PUT /v1/queries/{id}/usage")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Query> addQueryUsageWithHttpInfo(@Param(value="id") UUID var1, List<EntityReference> var2);

    @RequestLine(value="PUT /v1/queries/{id}/usedBy")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Query addQueryUsedBy(@Param(value="id") UUID var1, List<String> var2);

    @RequestLine(value="PUT /v1/queries/{id}/usedBy")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Query> addQueryUsedByWithHttpInfo(@Param(value="id") UUID var1, List<String> var2);

    @RequestLine(value="PUT /v1/queries/{id}/users")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Query addQueryUsers(@Param(value="id") UUID var1, List<String> var2);

    @RequestLine(value="PUT /v1/queries/{id}/users")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Query> addQueryUsersWithHttpInfo(@Param(value="id") UUID var1, List<String> var2);

    @RequestLine(value="PUT /v1/queries")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Query createOrUpdateQuery(CreateQuery var1);

    @RequestLine(value="PUT /v1/queries")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Query> createOrUpdateQueryWithHttpInfo(CreateQuery var1);

    @RequestLine(value="POST /v1/queries")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public QueryList createQuery(CreateQuery var1);

    @RequestLine(value="POST /v1/queries")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<QueryList> createQueryWithHttpInfo(CreateQuery var1);

    @RequestLine(value="DELETE /v1/queries/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower3(@Param(value="id") UUID var1, @Param(value="userId") UUID var2);

    @RequestLine(value="DELETE /v1/queries/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower3WithHttpInfo(@Param(value="id") UUID var1, @Param(value="userId") UUID var2);

    @RequestLine(value="DELETE /v1/queries/{id}")
    @Headers(value={"Accept: application/json"})
    public void deleteQuery(@Param(value="id") UUID var1);

    @RequestLine(value="DELETE /v1/queries/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteQueryWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="DELETE /v1/queries/name/{fqn}")
    @Headers(value={"Accept: application/json"})
    public void deleteQueryByFQN(@Param(value="fqn") String var1);

    @RequestLine(value="DELETE /v1/queries/name/{fqn}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteQueryByFQNWithHttpInfo(@Param(value="fqn") String var1);

    @RequestLine(value="GET /v1/queries/{id}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public Query getQueryById(@Param(value="id") UUID var1, @Param(value="fields") String var2);

    @RequestLine(value="GET /v1/queries/{id}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Query> getQueryByIdWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2);

    @RequestLine(value="GET /v1/queries/{id}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public Query getQueryById(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/queries/{id}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Query> getQueryByIdWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/queries/name/{fqn}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public Query getQueryFqn(@Param(value="fqn") String var1, @Param(value="fields") String var2);

    @RequestLine(value="GET /v1/queries/name/{fqn}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Query> getQueryFqnWithHttpInfo(@Param(value="fqn") String var1, @Param(value="fields") String var2);

    @RequestLine(value="GET /v1/queries/name/{fqn}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public Query getQueryFqn(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/queries/name/{fqn}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Query> getQueryFqnWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/queries/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Query getSpecificQueryVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/queries/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Query> getSpecificQueryVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/queries/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllQueryVersion(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/queries/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllQueryVersionWithHttpInfo(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/queries?fields={fields}&entityId={entityId}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public QueryList listQueries(@Param(value="fields") String var1, @Param(value="entityId") UUID var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5);

    @RequestLine(value="GET /v1/queries?fields={fields}&entityId={entityId}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<QueryList> listQueriesWithHttpInfo(@Param(value="fields") String var1, @Param(value="entityId") UUID var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5);

    @RequestLine(value="GET /v1/queries?fields={fields}&entityId={entityId}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public QueryList listQueries(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/queries?fields={fields}&entityId={entityId}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<QueryList> listQueriesWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/queries/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchQuery(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/queries/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchQueryWithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="DELETE /v1/queries/{id}/usage")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Query removeQueryUsedIn(@Param(value="id") UUID var1, List<EntityReference> var2);

    @RequestLine(value="DELETE /v1/queries/{id}/usage")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Query> removeQueryUsedInWithHttpInfo(@Param(value="id") UUID var1, List<EntityReference> var2);

    @RequestLine(value="PUT /v1/queries/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Query restore15(RestoreEntity var1);

    @RequestLine(value="PUT /v1/queries/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Query> restore15WithHttpInfo(RestoreEntity var1);

    @RequestLine(value="PUT /v1/queries/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVote(@Param(value="id") UUID var1, VoteRequest var2);

    @RequestLine(value="PUT /v1/queries/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteWithHttpInfo(@Param(value="id") UUID var1, VoteRequest var2);

    public static class ListQueriesQueryParams
    extends HashMap<String, Object> {
        public ListQueriesQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListQueriesQueryParams entityId(UUID value) {
            this.put("entityId", EncodingUtils.encode(value));
            return this;
        }

        public ListQueriesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListQueriesQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListQueriesQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetQueryFqnQueryParams
    extends HashMap<String, Object> {
        public GetQueryFqnQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetQueryByIdQueryParams
    extends HashMap<String, Object> {
        public GetQueryByIdQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }
}

