/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CreateTestDefinition;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.TestDefinition;
import org.openmetadata.client.model.TestDefinitionList;

public interface TestDefinitionsApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/dataQuality/testDefinitions")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestDefinition createOrUpdateTestDefinition(CreateTestDefinition var1);

    @RequestLine(value="PUT /v1/dataQuality/testDefinitions")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestDefinition> createOrUpdateTestDefinitionWithHttpInfo(CreateTestDefinition var1);

    @RequestLine(value="POST /v1/dataQuality/testDefinitions")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestDefinition createTestDefinition(CreateTestDefinition var1);

    @RequestLine(value="POST /v1/dataQuality/testDefinitions")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestDefinition> createTestDefinitionWithHttpInfo(CreateTestDefinition var1);

    @RequestLine(value="DELETE /v1/dataQuality/testDefinitions/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestDefinition(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/dataQuality/testDefinitions/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestDefinitionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/dataQuality/testDefinitions/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestDefinition(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/dataQuality/testDefinitions/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestDefinitionWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/dataQuality/testDefinitions/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestDefinitionByName(@Param(value="name") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/dataQuality/testDefinitions/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestDefinitionByNameWithHttpInfo(@Param(value="name") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/dataQuality/testDefinitions/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestDefinitionByName(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/dataQuality/testDefinitions/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestDefinitionByNameWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/dataQuality/testDefinitions/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestDefinition get1(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dataQuality/testDefinitions/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestDefinition> get1WithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dataQuality/testDefinitions/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestDefinition get1(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/dataQuality/testDefinitions/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestDefinition> get1WithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/dataQuality/testDefinitions/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public TestDefinition getSpecificTestDefinitionVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/dataQuality/testDefinitions/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestDefinition> getSpecificTestDefinitionVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/dataQuality/testDefinitions/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestDefinition getTestDefinitionByName(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dataQuality/testDefinitions/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestDefinition> getTestDefinitionByNameWithHttpInfo(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dataQuality/testDefinitions/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestDefinition getTestDefinitionByName(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/dataQuality/testDefinitions/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestDefinition> getTestDefinitionByNameWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/dataQuality/testDefinitions/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllTestDefinitionVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/dataQuality/testDefinitions/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllTestDefinitionVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/dataQuality/testDefinitions?fields={fields}&limit={limit}&before={before}&after={after}&include={include}&entityType={entityType}&testPlatform={testPlatform}&supportedDataType={supportedDataType}")
    @Headers(value={"Accept: application/json"})
    public TestDefinitionList listTestDefinitions(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="before") String var3, @Param(value="after") String var4, @Param(value="include") String var5, @Param(value="entityType") String var6, @Param(value="testPlatform") String var7, @Param(value="supportedDataType") String var8);

    @RequestLine(value="GET /v1/dataQuality/testDefinitions?fields={fields}&limit={limit}&before={before}&after={after}&include={include}&entityType={entityType}&testPlatform={testPlatform}&supportedDataType={supportedDataType}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestDefinitionList> listTestDefinitionsWithHttpInfo(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="before") String var3, @Param(value="after") String var4, @Param(value="include") String var5, @Param(value="entityType") String var6, @Param(value="testPlatform") String var7, @Param(value="supportedDataType") String var8);

    @RequestLine(value="GET /v1/dataQuality/testDefinitions?fields={fields}&limit={limit}&before={before}&after={after}&include={include}&entityType={entityType}&testPlatform={testPlatform}&supportedDataType={supportedDataType}")
    @Headers(value={"Accept: application/json"})
    public TestDefinitionList listTestDefinitions(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/dataQuality/testDefinitions?fields={fields}&limit={limit}&before={before}&after={after}&include={include}&entityType={entityType}&testPlatform={testPlatform}&supportedDataType={supportedDataType}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestDefinitionList> listTestDefinitionsWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/dataQuality/testDefinitions/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchTestDefinition(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/dataQuality/testDefinitions/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchTestDefinitionWithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PUT /v1/dataQuality/testDefinitions/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestDefinition restore8(RestoreEntity var1);

    @RequestLine(value="PUT /v1/dataQuality/testDefinitions/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestDefinition> restore8WithHttpInfo(RestoreEntity var1);

    public static class ListTestDefinitionsQueryParams
    extends HashMap<String, Object> {
        public ListTestDefinitionsQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListTestDefinitionsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListTestDefinitionsQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListTestDefinitionsQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListTestDefinitionsQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }

        public ListTestDefinitionsQueryParams entityType(String value) {
            this.put("entityType", EncodingUtils.encode(value));
            return this;
        }

        public ListTestDefinitionsQueryParams testPlatform(String value) {
            this.put("testPlatform", EncodingUtils.encode(value));
            return this;
        }

        public ListTestDefinitionsQueryParams supportedDataType(String value) {
            this.put("supportedDataType", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTestDefinitionByNameQueryParams
    extends HashMap<String, Object> {
        public GetTestDefinitionByNameQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTestDefinitionByNameQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class Get1QueryParams
    extends HashMap<String, Object> {
        public Get1QueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public Get1QueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTestDefinitionByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteTestDefinitionByNameQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTestDefinitionQueryParams
    extends HashMap<String, Object> {
        public DeleteTestDefinitionQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

