/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.ChangeDescription;

@JsonPropertyOrder(value={"changeDescription", "currentVersion", "entity", "entityFullyQualifiedName", "entityId", "entityType", "eventType", "previousVersion", "timestamp", "userName"})
public class ChangeEvent {
    public static final String JSON_PROPERTY_CHANGE_DESCRIPTION = "changeDescription";
    private ChangeDescription changeDescription;
    public static final String JSON_PROPERTY_CURRENT_VERSION = "currentVersion";
    private Double currentVersion;
    public static final String JSON_PROPERTY_ENTITY = "entity";
    private Object entity;
    public static final String JSON_PROPERTY_ENTITY_FULLY_QUALIFIED_NAME = "entityFullyQualifiedName";
    private String entityFullyQualifiedName;
    public static final String JSON_PROPERTY_ENTITY_ID = "entityId";
    private UUID entityId;
    public static final String JSON_PROPERTY_ENTITY_TYPE = "entityType";
    private String entityType;
    public static final String JSON_PROPERTY_EVENT_TYPE = "eventType";
    private EventTypeEnum eventType;
    public static final String JSON_PROPERTY_PREVIOUS_VERSION = "previousVersion";
    private Double previousVersion;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private Long timestamp;
    public static final String JSON_PROPERTY_USER_NAME = "userName";
    private String userName;

    public ChangeEvent changeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="changeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    @JsonProperty(value="changeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
    }

    public ChangeEvent currentVersion(Double currentVersion) {
        this.currentVersion = currentVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="currentVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getCurrentVersion() {
        return this.currentVersion;
    }

    @JsonProperty(value="currentVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrentVersion(Double currentVersion) {
        this.currentVersion = currentVersion;
    }

    public ChangeEvent entity(Object entity) {
        this.entity = entity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="entity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getEntity() {
        return this.entity;
    }

    @JsonProperty(value="entity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntity(Object entity) {
        this.entity = entity;
    }

    public ChangeEvent entityFullyQualifiedName(String entityFullyQualifiedName) {
        this.entityFullyQualifiedName = entityFullyQualifiedName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="entityFullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEntityFullyQualifiedName() {
        return this.entityFullyQualifiedName;
    }

    @JsonProperty(value="entityFullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntityFullyQualifiedName(String entityFullyQualifiedName) {
        this.entityFullyQualifiedName = entityFullyQualifiedName;
    }

    public ChangeEvent entityId(UUID entityId) {
        this.entityId = entityId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="entityId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getEntityId() {
        return this.entityId;
    }

    @JsonProperty(value="entityId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEntityId(UUID entityId) {
        this.entityId = entityId;
    }

    public ChangeEvent entityType(String entityType) {
        this.entityType = entityType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="entityType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="entityType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public ChangeEvent eventType(EventTypeEnum eventType) {
        this.eventType = eventType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="eventType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EventTypeEnum getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="eventType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEventType(EventTypeEnum eventType) {
        this.eventType = eventType;
    }

    public ChangeEvent previousVersion(Double previousVersion) {
        this.previousVersion = previousVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="previousVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getPreviousVersion() {
        return this.previousVersion;
    }

    @JsonProperty(value="previousVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPreviousVersion(Double previousVersion) {
        this.previousVersion = previousVersion;
    }

    public ChangeEvent timestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public ChangeEvent userName(String userName) {
        this.userName = userName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="userName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserName() {
        return this.userName;
    }

    @JsonProperty(value="userName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeEvent changeEvent = (ChangeEvent)o;
        return Objects.equals(this.changeDescription, changeEvent.changeDescription) && Objects.equals(this.currentVersion, changeEvent.currentVersion) && Objects.equals(this.entity, changeEvent.entity) && Objects.equals(this.entityFullyQualifiedName, changeEvent.entityFullyQualifiedName) && Objects.equals(this.entityId, changeEvent.entityId) && Objects.equals(this.entityType, changeEvent.entityType) && Objects.equals((Object)this.eventType, (Object)changeEvent.eventType) && Objects.equals(this.previousVersion, changeEvent.previousVersion) && Objects.equals(this.timestamp, changeEvent.timestamp) && Objects.equals(this.userName, changeEvent.userName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.changeDescription, this.currentVersion, this.entity, this.entityFullyQualifiedName, this.entityId, this.entityType, this.eventType, this.previousVersion, this.timestamp, this.userName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChangeEvent {\n");
        sb.append("    changeDescription: ").append(this.toIndentedString(this.changeDescription)).append("\n");
        sb.append("    currentVersion: ").append(this.toIndentedString(this.currentVersion)).append("\n");
        sb.append("    entity: ").append(this.toIndentedString(this.entity)).append("\n");
        sb.append("    entityFullyQualifiedName: ").append(this.toIndentedString(this.entityFullyQualifiedName)).append("\n");
        sb.append("    entityId: ").append(this.toIndentedString(this.entityId)).append("\n");
        sb.append("    entityType: ").append(this.toIndentedString(this.entityType)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString((Object)this.eventType)).append("\n");
        sb.append("    previousVersion: ").append(this.toIndentedString(this.previousVersion)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EventTypeEnum {
        ENTITYCREATED("entityCreated"),
        ENTITYUPDATED("entityUpdated"),
        ENTITYNOCHANGE("entityNoChange"),
        ENTITYSOFTDELETED("entitySoftDeleted"),
        ENTITYRESTORED("entityRestored"),
        ENTITYDELETED("entityDeleted");

        private String value;

        private EventTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EventTypeEnum fromValue(String value) {
            for (EventTypeEnum b : EventTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

