/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.UsageDetails;

@JsonPropertyOrder(value={"entity", "usage"})
public class EntityUsage {
    public static final String JSON_PROPERTY_ENTITY = "entity";
    private EntityReference entity;
    public static final String JSON_PROPERTY_USAGE = "usage";
    private List<UsageDetails> usage = new ArrayList<UsageDetails>();

    public EntityUsage entity(EntityReference entity) {
        this.entity = entity;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="entity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EntityReference getEntity() {
        return this.entity;
    }

    @JsonProperty(value="entity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEntity(EntityReference entity) {
        this.entity = entity;
    }

    public EntityUsage usage(List<UsageDetails> usage) {
        this.usage = usage;
        return this;
    }

    public EntityUsage addUsageItem(UsageDetails usageItem) {
        this.usage.add(usageItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="usage")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<UsageDetails> getUsage() {
        return this.usage;
    }

    @JsonProperty(value="usage")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUsage(List<UsageDetails> usage) {
        this.usage = usage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityUsage entityUsage = (EntityUsage)o;
        return Objects.equals(this.entity, entityUsage.entity) && Objects.equals(this.usage, entityUsage.usage);
    }

    public int hashCode() {
        return Objects.hash(this.entity, this.usage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EntityUsage {\n");
        sb.append("    entity: ").append(this.toIndentedString(this.entity)).append("\n");
        sb.append("    usage: ").append(this.toIndentedString(this.usage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

