/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.Paging;
import org.openmetadata.client.model.PersonalAccessToken;

@JsonPropertyOrder(value={"data", "errors", "paging"})
public class PersonalAccessTokenList {
    public static final String JSON_PROPERTY_DATA = "data";
    private List<PersonalAccessToken> data = new ArrayList<PersonalAccessToken>();
    public static final String JSON_PROPERTY_ERRORS = "errors";
    private List<String> errors = null;
    public static final String JSON_PROPERTY_PAGING = "paging";
    private Paging paging;

    public PersonalAccessTokenList data(List<PersonalAccessToken> data) {
        this.data = data;
        return this;
    }

    public PersonalAccessTokenList addDataItem(PersonalAccessToken dataItem) {
        this.data.add(dataItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<PersonalAccessToken> getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setData(List<PersonalAccessToken> data) {
        this.data = data;
    }

    public PersonalAccessTokenList errors(List<String> errors) {
        this.errors = errors;
        return this;
    }

    public PersonalAccessTokenList addErrorsItem(String errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public PersonalAccessTokenList paging(Paging paging) {
        this.paging = paging;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="paging")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Paging getPaging() {
        return this.paging;
    }

    @JsonProperty(value="paging")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaging(Paging paging) {
        this.paging = paging;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersonalAccessTokenList personalAccessTokenList = (PersonalAccessTokenList)o;
        return Objects.equals(this.data, personalAccessTokenList.data) && Objects.equals(this.errors, personalAccessTokenList.errors) && Objects.equals(this.paging, personalAccessTokenList.paging);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.errors, this.paging);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PersonalAccessTokenList {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    paging: ").append(this.toIndentedString(this.paging)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

