/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"name", "operations"})
public class ResourceDescriptor {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OPERATIONS = "operations";
    private List<OperationsEnum> operations = null;

    public ResourceDescriptor name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public ResourceDescriptor operations(List<OperationsEnum> operations) {
        this.operations = operations;
        return this;
    }

    public ResourceDescriptor addOperationsItem(OperationsEnum operationsItem) {
        if (this.operations == null) {
            this.operations = new ArrayList<OperationsEnum>();
        }
        this.operations.add(operationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="operations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<OperationsEnum> getOperations() {
        return this.operations;
    }

    @JsonProperty(value="operations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOperations(List<OperationsEnum> operations) {
        this.operations = operations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceDescriptor resourceDescriptor = (ResourceDescriptor)o;
        return Objects.equals(this.name, resourceDescriptor.name) && Objects.equals(this.operations, resourceDescriptor.operations);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.operations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceDescriptor {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    operations: ").append(this.toIndentedString(this.operations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OperationsEnum {
        ALL("All"),
        CREATE("Create"),
        DELETE("Delete"),
        VIEWALL("ViewAll"),
        VIEWBASIC("ViewBasic"),
        VIEWUSAGE("ViewUsage"),
        VIEWTESTS("ViewTests"),
        VIEWQUERIES("ViewQueries"),
        VIEWDATAPROFILE("ViewDataProfile"),
        VIEWSAMPLEDATA("ViewSampleData"),
        EDITALL("EditAll"),
        EDITCUSTOMFIELDS("EditCustomFields"),
        EDITDATAPROFILE("EditDataProfile"),
        EDITDESCRIPTION("EditDescription"),
        EDITDISPLAYNAME("EditDisplayName"),
        EDITLINEAGE("EditLineage"),
        EDITPOLICY("EditPolicy"),
        EDITOWNER("EditOwner"),
        EDITQUERIES("EditQueries"),
        EDITREVIEWERS("EditReviewers"),
        EDITROLE("EditRole"),
        EDITSAMPLEDATA("EditSampleData"),
        EDITSTATUS("EditStatus"),
        EDITTAGS("EditTags"),
        EDITTEAMS("EditTeams"),
        EDITTIER("EditTier"),
        EDITTESTS("EditTests"),
        EDITUSAGE("EditUsage"),
        EDITUSERS("EditUsers");

        private String value;

        private OperationsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OperationsEnum fromValue(String value) {
            for (OperationsEnum b : OperationsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

