/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openmetadata.client.model.Aggregations;
import org.openmetadata.client.model.Clusters;
import org.openmetadata.client.model.SearchHits;
import org.openmetadata.client.model.SearchProfileShardResult;
import org.openmetadata.client.model.SearchResponseSections;
import org.openmetadata.client.model.ShardSearchFailure;
import org.openmetadata.client.model.Suggest;
import org.openmetadata.client.model.TimeValue;

@JsonPropertyOrder(value={"aggregations", "clusters", "failedShards", "fragment", "hits", "internalResponse", "numReducePhases", "profileResults", "scrollId", "shardFailures", "skippedShards", "successfulShards", "suggest", "terminatedEarly", "timedOut", "took", "totalShards"})
public class SearchResponse {
    public static final String JSON_PROPERTY_AGGREGATIONS = "aggregations";
    private Aggregations aggregations;
    public static final String JSON_PROPERTY_CLUSTERS = "clusters";
    private Clusters clusters;
    public static final String JSON_PROPERTY_FAILED_SHARDS = "failedShards";
    private Integer failedShards;
    public static final String JSON_PROPERTY_FRAGMENT = "fragment";
    private Boolean fragment;
    public static final String JSON_PROPERTY_HITS = "hits";
    private SearchHits hits;
    public static final String JSON_PROPERTY_INTERNAL_RESPONSE = "internalResponse";
    private SearchResponseSections internalResponse;
    public static final String JSON_PROPERTY_NUM_REDUCE_PHASES = "numReducePhases";
    private Integer numReducePhases;
    public static final String JSON_PROPERTY_PROFILE_RESULTS = "profileResults";
    private Map<String, SearchProfileShardResult> profileResults = null;
    public static final String JSON_PROPERTY_SCROLL_ID = "scrollId";
    private String scrollId;
    public static final String JSON_PROPERTY_SHARD_FAILURES = "shardFailures";
    private List<ShardSearchFailure> shardFailures = null;
    public static final String JSON_PROPERTY_SKIPPED_SHARDS = "skippedShards";
    private Integer skippedShards;
    public static final String JSON_PROPERTY_SUCCESSFUL_SHARDS = "successfulShards";
    private Integer successfulShards;
    public static final String JSON_PROPERTY_SUGGEST = "suggest";
    private Suggest suggest;
    public static final String JSON_PROPERTY_TERMINATED_EARLY = "terminatedEarly";
    private Boolean terminatedEarly;
    public static final String JSON_PROPERTY_TIMED_OUT = "timedOut";
    private Boolean timedOut;
    public static final String JSON_PROPERTY_TOOK = "took";
    private TimeValue took;
    public static final String JSON_PROPERTY_TOTAL_SHARDS = "totalShards";
    private Integer totalShards;

    public SearchResponse aggregations(Aggregations aggregations) {
        this.aggregations = aggregations;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="aggregations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Aggregations getAggregations() {
        return this.aggregations;
    }

    @JsonProperty(value="aggregations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAggregations(Aggregations aggregations) {
        this.aggregations = aggregations;
    }

    public SearchResponse clusters(Clusters clusters) {
        this.clusters = clusters;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="clusters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Clusters getClusters() {
        return this.clusters;
    }

    @JsonProperty(value="clusters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClusters(Clusters clusters) {
        this.clusters = clusters;
    }

    public SearchResponse failedShards(Integer failedShards) {
        this.failedShards = failedShards;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="failedShards")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getFailedShards() {
        return this.failedShards;
    }

    @JsonProperty(value="failedShards")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailedShards(Integer failedShards) {
        this.failedShards = failedShards;
    }

    public SearchResponse fragment(Boolean fragment) {
        this.fragment = fragment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="fragment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getFragment() {
        return this.fragment;
    }

    @JsonProperty(value="fragment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFragment(Boolean fragment) {
        this.fragment = fragment;
    }

    public SearchResponse hits(SearchHits hits) {
        this.hits = hits;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="hits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SearchHits getHits() {
        return this.hits;
    }

    @JsonProperty(value="hits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHits(SearchHits hits) {
        this.hits = hits;
    }

    public SearchResponse internalResponse(SearchResponseSections internalResponse) {
        this.internalResponse = internalResponse;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="internalResponse")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SearchResponseSections getInternalResponse() {
        return this.internalResponse;
    }

    @JsonProperty(value="internalResponse")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalResponse(SearchResponseSections internalResponse) {
        this.internalResponse = internalResponse;
    }

    public SearchResponse numReducePhases(Integer numReducePhases) {
        this.numReducePhases = numReducePhases;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="numReducePhases")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNumReducePhases() {
        return this.numReducePhases;
    }

    @JsonProperty(value="numReducePhases")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumReducePhases(Integer numReducePhases) {
        this.numReducePhases = numReducePhases;
    }

    public SearchResponse profileResults(Map<String, SearchProfileShardResult> profileResults) {
        this.profileResults = profileResults;
        return this;
    }

    public SearchResponse putProfileResultsItem(String key, SearchProfileShardResult profileResultsItem) {
        if (this.profileResults == null) {
            this.profileResults = new HashMap<String, SearchProfileShardResult>();
        }
        this.profileResults.put(key, profileResultsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="profileResults")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, SearchProfileShardResult> getProfileResults() {
        return this.profileResults;
    }

    @JsonProperty(value="profileResults")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfileResults(Map<String, SearchProfileShardResult> profileResults) {
        this.profileResults = profileResults;
    }

    public SearchResponse scrollId(String scrollId) {
        this.scrollId = scrollId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="scrollId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getScrollId() {
        return this.scrollId;
    }

    @JsonProperty(value="scrollId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScrollId(String scrollId) {
        this.scrollId = scrollId;
    }

    public SearchResponse shardFailures(List<ShardSearchFailure> shardFailures) {
        this.shardFailures = shardFailures;
        return this;
    }

    public SearchResponse addShardFailuresItem(ShardSearchFailure shardFailuresItem) {
        if (this.shardFailures == null) {
            this.shardFailures = new ArrayList<ShardSearchFailure>();
        }
        this.shardFailures.add(shardFailuresItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="shardFailures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ShardSearchFailure> getShardFailures() {
        return this.shardFailures;
    }

    @JsonProperty(value="shardFailures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShardFailures(List<ShardSearchFailure> shardFailures) {
        this.shardFailures = shardFailures;
    }

    public SearchResponse skippedShards(Integer skippedShards) {
        this.skippedShards = skippedShards;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="skippedShards")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSkippedShards() {
        return this.skippedShards;
    }

    @JsonProperty(value="skippedShards")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSkippedShards(Integer skippedShards) {
        this.skippedShards = skippedShards;
    }

    public SearchResponse successfulShards(Integer successfulShards) {
        this.successfulShards = successfulShards;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="successfulShards")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSuccessfulShards() {
        return this.successfulShards;
    }

    @JsonProperty(value="successfulShards")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSuccessfulShards(Integer successfulShards) {
        this.successfulShards = successfulShards;
    }

    public SearchResponse suggest(Suggest suggest) {
        this.suggest = suggest;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="suggest")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Suggest getSuggest() {
        return this.suggest;
    }

    @JsonProperty(value="suggest")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSuggest(Suggest suggest) {
        this.suggest = suggest;
    }

    public SearchResponse terminatedEarly(Boolean terminatedEarly) {
        this.terminatedEarly = terminatedEarly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="terminatedEarly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getTerminatedEarly() {
        return this.terminatedEarly;
    }

    @JsonProperty(value="terminatedEarly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTerminatedEarly(Boolean terminatedEarly) {
        this.terminatedEarly = terminatedEarly;
    }

    public SearchResponse timedOut(Boolean timedOut) {
        this.timedOut = timedOut;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="timedOut")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getTimedOut() {
        return this.timedOut;
    }

    @JsonProperty(value="timedOut")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimedOut(Boolean timedOut) {
        this.timedOut = timedOut;
    }

    public SearchResponse took(TimeValue took) {
        this.took = took;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="took")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TimeValue getTook() {
        return this.took;
    }

    @JsonProperty(value="took")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTook(TimeValue took) {
        this.took = took;
    }

    public SearchResponse totalShards(Integer totalShards) {
        this.totalShards = totalShards;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="totalShards")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotalShards() {
        return this.totalShards;
    }

    @JsonProperty(value="totalShards")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalShards(Integer totalShards) {
        this.totalShards = totalShards;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchResponse searchResponse = (SearchResponse)o;
        return Objects.equals(this.aggregations, searchResponse.aggregations) && Objects.equals(this.clusters, searchResponse.clusters) && Objects.equals(this.failedShards, searchResponse.failedShards) && Objects.equals(this.fragment, searchResponse.fragment) && Objects.equals(this.hits, searchResponse.hits) && Objects.equals(this.internalResponse, searchResponse.internalResponse) && Objects.equals(this.numReducePhases, searchResponse.numReducePhases) && Objects.equals(this.profileResults, searchResponse.profileResults) && Objects.equals(this.scrollId, searchResponse.scrollId) && Objects.equals(this.shardFailures, searchResponse.shardFailures) && Objects.equals(this.skippedShards, searchResponse.skippedShards) && Objects.equals(this.successfulShards, searchResponse.successfulShards) && Objects.equals(this.suggest, searchResponse.suggest) && Objects.equals(this.terminatedEarly, searchResponse.terminatedEarly) && Objects.equals(this.timedOut, searchResponse.timedOut) && Objects.equals(this.took, searchResponse.took) && Objects.equals(this.totalShards, searchResponse.totalShards);
    }

    public int hashCode() {
        return Objects.hash(this.aggregations, this.clusters, this.failedShards, this.fragment, this.hits, this.internalResponse, this.numReducePhases, this.profileResults, this.scrollId, this.shardFailures, this.skippedShards, this.successfulShards, this.suggest, this.terminatedEarly, this.timedOut, this.took, this.totalShards);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchResponse {\n");
        sb.append("    aggregations: ").append(this.toIndentedString(this.aggregations)).append("\n");
        sb.append("    clusters: ").append(this.toIndentedString(this.clusters)).append("\n");
        sb.append("    failedShards: ").append(this.toIndentedString(this.failedShards)).append("\n");
        sb.append("    fragment: ").append(this.toIndentedString(this.fragment)).append("\n");
        sb.append("    hits: ").append(this.toIndentedString(this.hits)).append("\n");
        sb.append("    internalResponse: ").append(this.toIndentedString(this.internalResponse)).append("\n");
        sb.append("    numReducePhases: ").append(this.toIndentedString(this.numReducePhases)).append("\n");
        sb.append("    profileResults: ").append(this.toIndentedString(this.profileResults)).append("\n");
        sb.append("    scrollId: ").append(this.toIndentedString(this.scrollId)).append("\n");
        sb.append("    shardFailures: ").append(this.toIndentedString(this.shardFailures)).append("\n");
        sb.append("    skippedShards: ").append(this.toIndentedString(this.skippedShards)).append("\n");
        sb.append("    successfulShards: ").append(this.toIndentedString(this.successfulShards)).append("\n");
        sb.append("    suggest: ").append(this.toIndentedString(this.suggest)).append("\n");
        sb.append("    terminatedEarly: ").append(this.toIndentedString(this.terminatedEarly)).append("\n");
        sb.append("    timedOut: ").append(this.toIndentedString(this.timedOut)).append("\n");
        sb.append("    took: ").append(this.toIndentedString(this.took)).append("\n");
        sb.append("    totalShards: ").append(this.toIndentedString(this.totalShards)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

