/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.security;

import feign.RequestTemplate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.interceptors.Auth0AccessTokenRequestInterceptor;
import org.openmetadata.client.model.AccessTokenResponse;
import org.openmetadata.client.security.interfaces.Auth0AccessTokenApi;
import org.openmetadata.client.security.interfaces.AuthenticationProvider;
import org.openmetadata.schema.security.client.Auth0SSOClientConfig;
import org.openmetadata.schema.services.connections.metadata.AuthProvider;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Auth0AuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(Auth0AuthenticationProvider.class);
    private String generatedAuthToken;
    private Long expirationTimeMillis;
    private final Auth0AccessTokenApi auth0SSOClient;

    public Auth0AuthenticationProvider(OpenMetadataConnection iConfig) {
        if (!iConfig.getAuthProvider().equals((Object)AuthProvider.AUTH_0)) {
            LOG.error("Required type to invoke is Auth0 for Auth0Authentication Provider");
            throw new RuntimeException("Required type to invoke is Auth0 for Auth0Authentication Provider");
        }
        Auth0SSOClientConfig securityConfig = (Auth0SSOClientConfig)iConfig.getSecurityConfig();
        if (securityConfig == null) {
            LOG.error("Security Config is missing, it is required");
            throw new RuntimeException("Security Config is missing, it is required");
        }
        this.generatedAuthToken = "";
        ApiClient auth0SSO = new ApiClient();
        auth0SSO.setBasePath("https://" + securityConfig.getDomain());
        Auth0AccessTokenRequestInterceptor interceptor = new Auth0AccessTokenRequestInterceptor(securityConfig);
        auth0SSO.addAuthorization("0AuthToken", interceptor);
        this.auth0SSOClient = auth0SSO.buildClient(Auth0AccessTokenApi.class);
    }

    @Override
    public AuthenticationProvider create(OpenMetadataConnection iConfig) {
        return new Auth0AuthenticationProvider(iConfig);
    }

    @Override
    public String authToken() {
        AccessTokenResponse resp = this.auth0SSOClient.getAccessToken();
        this.generatedAuthToken = resp.getAccessToken();
        this.expirationTimeMillis = Date.from(Instant.now().plus((long)resp.getExpiresIn(), ChronoUnit.SECONDS)).getTime();
        return this.generatedAuthToken;
    }

    @Override
    public String getAccessToken() {
        return this.generatedAuthToken;
    }

    public void apply(RequestTemplate requestTemplate) {
        if (requestTemplate.url().contains("version")) {
            return;
        }
        if (requestTemplate.headers().containsKey("Authorization")) {
            return;
        }
        if (this.expirationTimeMillis == null || System.currentTimeMillis() >= this.expirationTimeMillis) {
            this.authToken();
        }
        if (this.getAccessToken() != null) {
            requestTemplate.header("Authorization", new String[]{"Bearer " + this.getAccessToken()});
        }
    }
}

