/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.APICollection;
import org.openmetadata.client.model.APICollectionList;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateAPICollection;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.VoteRequest;

public interface ApiCollectionsApi
extends ApiClient.Api {
    @RequestLine(value="POST /v1/apiCollections")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public APICollection createAPICollection(@Nullable CreateAPICollection var1);

    @RequestLine(value="POST /v1/apiCollections")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<APICollection> createAPICollectionWithHttpInfo(@Nullable CreateAPICollection var1);

    @RequestLine(value="PUT /v1/apiCollections")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public APICollection createOrUpdateAPICollection(@Nullable CreateAPICollection var1);

    @RequestLine(value="PUT /v1/apiCollections")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<APICollection> createOrUpdateAPICollectionWithHttpInfo(@Nullable CreateAPICollection var1);

    @RequestLine(value="DELETE /v1/apiCollections/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPICollection(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/apiCollections/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPICollectionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/apiCollections/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPICollection(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteAPICollectionQueryParams var2);

    @RequestLine(value="DELETE /v1/apiCollections/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPICollectionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteAPICollectionQueryParams var2);

    @RequestLine(value="DELETE /v1/apiCollections/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPICollectionAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/apiCollections/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPICollectionAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/apiCollections/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPICollectionAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteAPICollectionAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/apiCollections/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPICollectionAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteAPICollectionAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/apiCollections/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPICollectionByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/apiCollections/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPICollectionByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/apiCollections/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPICollectionByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteAPICollectionByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/apiCollections/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPICollectionByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteAPICollectionByFQNQueryParams var2);

    @RequestLine(value="GET /v1/apiCollections/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APICollection getAPICollectionByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/apiCollections/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APICollection> getAPICollectionByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/apiCollections/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APICollection getAPICollectionByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetAPICollectionByFQNQueryParams var2);

    @RequestLine(value="GET /v1/apiCollections/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APICollection> getAPICollectionByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetAPICollectionByFQNQueryParams var2);

    @RequestLine(value="GET /v1/apiCollections/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APICollection getAPICollectionByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/apiCollections/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APICollection> getAPICollectionByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/apiCollections/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APICollection getAPICollectionByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetAPICollectionByIDQueryParams var2);

    @RequestLine(value="GET /v1/apiCollections/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APICollection> getAPICollectionByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetAPICollectionByIDQueryParams var2);

    @RequestLine(value="GET /v1/apiCollections/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public APICollection getSpecificAPICollectionVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/apiCollections/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APICollection> getSpecificAPICollectionVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/apiCollections?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APICollectionList listAPICollections(@Param(value="fields") @Nullable String var1, @Param(value="service") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/apiCollections?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APICollectionList> listAPICollectionsWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="service") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/apiCollections?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APICollectionList listAPICollections(@QueryMap(encoded=true) ListAPICollectionsQueryParams var1);

    @RequestLine(value="GET /v1/apiCollections?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APICollectionList> listAPICollectionsWithHttpInfo(@QueryMap(encoded=true) ListAPICollectionsQueryParams var1);

    @RequestLine(value="GET /v1/apiCollections/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllAPICollectionVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/apiCollections/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllAPICollectionVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="PATCH /v1/apiCollections/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchAPICollection(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/apiCollections/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchAPICollectionWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/apiCollections/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchAPICollection1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/apiCollections/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchAPICollection1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/apiCollections/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public APICollection restore(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/apiCollections/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<APICollection> restoreWithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/apiCollections/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForAPICollection(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    @RequestLine(value="PUT /v1/apiCollections/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForAPICollectionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    public static class ListAPICollectionsQueryParams
    extends HashMap<String, Object> {
        public ListAPICollectionsQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListAPICollectionsQueryParams service(@Nullable String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListAPICollectionsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListAPICollectionsQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListAPICollectionsQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListAPICollectionsQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetAPICollectionByIDQueryParams
    extends HashMap<String, Object> {
        public GetAPICollectionByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetAPICollectionByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetAPICollectionByFQNQueryParams
    extends HashMap<String, Object> {
        public GetAPICollectionByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetAPICollectionByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteAPICollectionByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteAPICollectionByFQNQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteAPICollectionByFQNQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteAPICollectionAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteAPICollectionAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteAPICollectionAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteAPICollectionQueryParams
    extends HashMap<String, Object> {
        public DeleteAPICollectionQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteAPICollectionQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

