/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.APIEndpoint;
import org.openmetadata.client.model.APIEndpointList;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateAPIEndpoint;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.VoteRequest;

public interface ApiEndpointApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/apiEndpoints/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollower(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="PUT /v1/apiEndpoints/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="POST /v1/apiEndpoints")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public APIEndpoint createAPIEndpoint(@Nullable CreateAPIEndpoint var1);

    @RequestLine(value="POST /v1/apiEndpoints")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<APIEndpoint> createAPIEndpointWithHttpInfo(@Nullable CreateAPIEndpoint var1);

    @RequestLine(value="PUT /v1/apiEndpoints")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public APIEndpoint createOrUpdateAPIEndpoint(@Nullable CreateAPIEndpoint var1);

    @RequestLine(value="PUT /v1/apiEndpoints")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<APIEndpoint> createOrUpdateAPIEndpointWithHttpInfo(@Nullable CreateAPIEndpoint var1);

    @RequestLine(value="DELETE /v1/apiEndpoints/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPIEndpoint(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/apiEndpoints/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPIEndpointWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/apiEndpoints/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPIEndpoint(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteAPIEndpointQueryParams var2);

    @RequestLine(value="DELETE /v1/apiEndpoints/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPIEndpointWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteAPIEndpointQueryParams var2);

    @RequestLine(value="DELETE /v1/apiEndpoints/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPIEndpointAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/apiEndpoints/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPIEndpointAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/apiEndpoints/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPIEndpointAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteAPIEndpointAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/apiEndpoints/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPIEndpointAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteAPIEndpointAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/apiEndpoints/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPIEndpointByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/apiEndpoints/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPIEndpointByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/apiEndpoints/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPIEndpointByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteAPIEndpointByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/apiEndpoints/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPIEndpointByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteAPIEndpointByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/apiEndpoints/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/apiEndpoints/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollowerWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="GET /v1/apiEndpoints/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APIEndpoint getEndpointByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/apiEndpoints/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APIEndpoint> getEndpointByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/apiEndpoints/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APIEndpoint getEndpointByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetEndpointByFQNQueryParams var2);

    @RequestLine(value="GET /v1/apiEndpoints/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APIEndpoint> getEndpointByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetEndpointByFQNQueryParams var2);

    @RequestLine(value="GET /v1/apiEndpoints/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APIEndpoint getEndpointById(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/apiEndpoints/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APIEndpoint> getEndpointByIdWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/apiEndpoints/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APIEndpoint getEndpointById(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetEndpointByIdQueryParams var2);

    @RequestLine(value="GET /v1/apiEndpoints/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APIEndpoint> getEndpointByIdWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetEndpointByIdQueryParams var2);

    @RequestLine(value="GET /v1/apiEndpoints/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public APIEndpoint getSpecificEndpointVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/apiEndpoints/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APIEndpoint> getSpecificEndpointVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/apiEndpoints?fields={fields}&service={service}&apiCollection={apiCollection}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APIEndpointList listAPIEndpoints(@Param(value="fields") @Nullable String var1, @Param(value="service") @Nullable String var2, @Param(value="apiCollection") @Nullable String var3, @Param(value="limit") @Nullable Integer var4, @Param(value="before") @Nullable String var5, @Param(value="after") @Nullable String var6, @Param(value="include") @Nullable String var7);

    @RequestLine(value="GET /v1/apiEndpoints?fields={fields}&service={service}&apiCollection={apiCollection}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APIEndpointList> listAPIEndpointsWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="service") @Nullable String var2, @Param(value="apiCollection") @Nullable String var3, @Param(value="limit") @Nullable Integer var4, @Param(value="before") @Nullable String var5, @Param(value="after") @Nullable String var6, @Param(value="include") @Nullable String var7);

    @RequestLine(value="GET /v1/apiEndpoints?fields={fields}&service={service}&apiCollection={apiCollection}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public APIEndpointList listAPIEndpoints(@QueryMap(encoded=true) ListAPIEndpointsQueryParams var1);

    @RequestLine(value="GET /v1/apiEndpoints?fields={fields}&service={service}&apiCollection={apiCollection}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<APIEndpointList> listAPIEndpointsWithHttpInfo(@QueryMap(encoded=true) ListAPIEndpointsQueryParams var1);

    @RequestLine(value="GET /v1/apiEndpoints/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllAPIEndpointVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/apiEndpoints/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllAPIEndpointVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="PATCH /v1/apiEndpoints/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchAPIEndpoint(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/apiEndpoints/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchAPIEndpointWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/apiEndpoints/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchAPIEndpoint1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/apiEndpoints/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchAPIEndpoint1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/apiEndpoints/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public APIEndpoint restore1(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/apiEndpoints/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<APIEndpoint> restore1WithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/apiEndpoints/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForAPIEndpoint(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    @RequestLine(value="PUT /v1/apiEndpoints/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForAPIEndpointWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    public static class ListAPIEndpointsQueryParams
    extends HashMap<String, Object> {
        public ListAPIEndpointsQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListAPIEndpointsQueryParams service(@Nullable String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListAPIEndpointsQueryParams apiCollection(@Nullable String value) {
            this.put("apiCollection", EncodingUtils.encode(value));
            return this;
        }

        public ListAPIEndpointsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListAPIEndpointsQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListAPIEndpointsQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListAPIEndpointsQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetEndpointByIdQueryParams
    extends HashMap<String, Object> {
        public GetEndpointByIdQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetEndpointByIdQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetEndpointByFQNQueryParams
    extends HashMap<String, Object> {
        public GetEndpointByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetEndpointByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteAPIEndpointByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteAPIEndpointByFQNQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteAPIEndpointAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteAPIEndpointAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteAPIEndpointQueryParams
    extends HashMap<String, Object> {
        public DeleteAPIEndpointQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

