/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.App;
import org.openmetadata.client.model.AppExtension;
import org.openmetadata.client.model.AppList;
import org.openmetadata.client.model.AppMarketPlaceDefinition;
import org.openmetadata.client.model.AppMarketPlaceDefinitionList;
import org.openmetadata.client.model.AppRefList;
import org.openmetadata.client.model.AppRunList;
import org.openmetadata.client.model.AppRunRecord;
import org.openmetadata.client.model.CreateApp;
import org.openmetadata.client.model.CreateAppMarketPlaceDefinitionReq;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.Response;
import org.openmetadata.client.model.RestoreEntity;

public interface AppsApi
extends ApiClient.Api {
    @RequestLine(value="POST /v1/apps/configure/{name}")
    @Headers(value={"Accept: application/json"})
    public Response configureApplication(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="POST /v1/apps/configure/{name}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Response> configureApplicationWithHttpInfo(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="POST /v1/apps/marketplace")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public AppMarketPlaceDefinition createApplication(@Nullable CreateAppMarketPlaceDefinitionReq var1);

    @RequestLine(value="POST /v1/apps/marketplace")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<AppMarketPlaceDefinition> createApplicationWithHttpInfo(@Nullable CreateAppMarketPlaceDefinitionReq var1);

    @RequestLine(value="POST /v1/apps")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public App createApplication1(@Nullable CreateApp var1);

    @RequestLine(value="POST /v1/apps")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<App> createApplication1WithHttpInfo(@Nullable CreateApp var1);

    @RequestLine(value="PUT /v1/apps/marketplace")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public App createOrUpdateApp(@Nullable CreateAppMarketPlaceDefinitionReq var1);

    @RequestLine(value="PUT /v1/apps/marketplace")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<App> createOrUpdateAppWithHttpInfo(@Nullable CreateAppMarketPlaceDefinitionReq var1);

    @RequestLine(value="PUT /v1/apps")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public App createOrUpdateApp1(@Nullable CreateApp var1);

    @RequestLine(value="PUT /v1/apps")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<App> createOrUpdateApp1WithHttpInfo(@Nullable CreateApp var1);

    @RequestLine(value="DELETE /v1/apps/marketplace/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteApp(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/apps/marketplace/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAppWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/apps/marketplace/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteApp(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteAppQueryParams var2);

    @RequestLine(value="DELETE /v1/apps/marketplace/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAppWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteAppQueryParams var2);

    @RequestLine(value="DELETE /v1/apps/marketplace/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAppAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/apps/marketplace/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAppAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/apps/marketplace/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAppAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteAppAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/apps/marketplace/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAppAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteAppAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/apps/marketplace/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAppByName(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/apps/marketplace/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAppByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/apps/marketplace/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAppByName(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteAppByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/apps/marketplace/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAppByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteAppByNameQueryParams var2);

    @RequestLine(value="POST /v1/apps/deploy/{name}")
    @Headers(value={"Accept: application/json"})
    public void deployApplicationToQuartzOrIngestion(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="POST /v1/apps/deploy/{name}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deployApplicationToQuartzOrIngestionWithHttpInfo(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="GET /v1/apps/marketplace/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public AppMarketPlaceDefinition get(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/apps/marketplace/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AppMarketPlaceDefinition> getWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/apps/marketplace/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public AppMarketPlaceDefinition get(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetQueryParams var2);

    @RequestLine(value="GET /v1/apps/marketplace/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AppMarketPlaceDefinition> getWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetQueryParams var2);

    @RequestLine(value="GET /v1/apps/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public App get1(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/apps/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<App> get1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/apps/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public App get1(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) Get1QueryParams var2);

    @RequestLine(value="GET /v1/apps/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<App> get1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) Get1QueryParams var2);

    @RequestLine(value="GET /v1/apps/marketplace/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public AppMarketPlaceDefinition getAppByName(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/apps/marketplace/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AppMarketPlaceDefinition> getAppByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/apps/marketplace/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public AppMarketPlaceDefinition getAppByName(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetAppByNameQueryParams var2);

    @RequestLine(value="GET /v1/apps/marketplace/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AppMarketPlaceDefinition> getAppByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetAppByNameQueryParams var2);

    @RequestLine(value="GET /v1/apps/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public App getAppByName1(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/apps/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<App> getAppByName1WithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/apps/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public App getAppByName1(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetAppByName1QueryParams var2);

    @RequestLine(value="GET /v1/apps/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<App> getAppByName1WithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetAppByName1QueryParams var2);

    @RequestLine(value="GET /v1/apps/name/{name}/logs?after={after}")
    @Headers(value={"Accept: application/json"})
    public void getLastLogs(@Param(value="name") @Nonnull String var1, @Param(value="after") @Nullable String var2);

    @RequestLine(value="GET /v1/apps/name/{name}/logs?after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> getLastLogsWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="after") @Nullable String var2);

    @RequestLine(value="GET /v1/apps/name/{name}/logs?after={after}")
    @Headers(value={"Accept: application/json"})
    public void getLastLogs(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetLastLogsQueryParams var2);

    @RequestLine(value="GET /v1/apps/name/{name}/logs?after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> getLastLogsWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetLastLogsQueryParams var2);

    @RequestLine(value="GET /v1/apps/marketplace/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public App getSpecificAppVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/apps/marketplace/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<App> getSpecificAppVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/apps/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public App getSpecificAppVersion1(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/apps/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<App> getSpecificAppVersion1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/apps/name/{name}/runs/latest?after={after}")
    @Headers(value={"Accept: application/json"})
    public AppRunRecord latestAppRunRecord(@Param(value="name") @Nonnull String var1, @Param(value="after") @Nullable String var2);

    @RequestLine(value="GET /v1/apps/name/{name}/runs/latest?after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AppRunRecord> latestAppRunRecordWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="after") @Nullable String var2);

    @RequestLine(value="GET /v1/apps/name/{name}/runs/latest?after={after}")
    @Headers(value={"Accept: application/json"})
    public AppRunRecord latestAppRunRecord(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) LatestAppRunRecordQueryParams var2);

    @RequestLine(value="GET /v1/apps/name/{name}/runs/latest?after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AppRunRecord> latestAppRunRecordWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) LatestAppRunRecordQueryParams var2);

    @RequestLine(value="GET /v1/apps/marketplace/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllInstalledApplications(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/apps/marketplace/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllInstalledApplicationsWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/apps/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllInstalledApplications1(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/apps/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllInstalledApplications1WithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/apps/name/{name}/extension?limit={limit}&offset={offset}&startTs={startTs}&extensionType={extensionType}&byName={byName}")
    @Headers(value={"Accept: application/json"})
    public AppExtension listAppExtension(@Param(value="name") @Nonnull String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="offset") @Nullable Integer var3, @Param(value="startTs") @Nullable BigDecimal var4, @Param(value="extensionType") @Nullable String var5, @Param(value="byName") @Nullable Boolean var6);

    @RequestLine(value="GET /v1/apps/name/{name}/extension?limit={limit}&offset={offset}&startTs={startTs}&extensionType={extensionType}&byName={byName}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AppExtension> listAppExtensionWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="offset") @Nullable Integer var3, @Param(value="startTs") @Nullable BigDecimal var4, @Param(value="extensionType") @Nullable String var5, @Param(value="byName") @Nullable Boolean var6);

    @RequestLine(value="GET /v1/apps/name/{name}/extension?limit={limit}&offset={offset}&startTs={startTs}&extensionType={extensionType}&byName={byName}")
    @Headers(value={"Accept: application/json"})
    public AppExtension listAppExtension(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) ListAppExtensionQueryParams var2);

    @RequestLine(value="GET /v1/apps/name/{name}/extension?limit={limit}&offset={offset}&startTs={startTs}&extensionType={extensionType}&byName={byName}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AppExtension> listAppExtensionWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) ListAppExtensionQueryParams var2);

    @RequestLine(value="GET /v1/apps/name/{name}/status?limit={limit}&offset={offset}&startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public AppRunList listAppRunRecords(@Param(value="name") @Nonnull String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="offset") @Nullable Integer var3, @Param(value="startTs") @Nullable BigDecimal var4, @Param(value="endTs") @Nullable BigDecimal var5);

    @RequestLine(value="GET /v1/apps/name/{name}/status?limit={limit}&offset={offset}&startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AppRunList> listAppRunRecordsWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="offset") @Nullable Integer var3, @Param(value="startTs") @Nullable BigDecimal var4, @Param(value="endTs") @Nullable BigDecimal var5);

    @RequestLine(value="GET /v1/apps/name/{name}/status?limit={limit}&offset={offset}&startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public AppRunList listAppRunRecords(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) ListAppRunRecordsQueryParams var2);

    @RequestLine(value="GET /v1/apps/name/{name}/status?limit={limit}&offset={offset}&startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AppRunList> listAppRunRecordsWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) ListAppRunRecordsQueryParams var2);

    @RequestLine(value="GET /v1/apps/marketplace?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public AppMarketPlaceDefinitionList listApplications(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="before") @Nullable String var3, @Param(value="after") @Nullable String var4, @Param(value="include") @Nullable String var5);

    @RequestLine(value="GET /v1/apps/marketplace?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AppMarketPlaceDefinitionList> listApplicationsWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="before") @Nullable String var3, @Param(value="after") @Nullable String var4, @Param(value="include") @Nullable String var5);

    @RequestLine(value="GET /v1/apps/marketplace?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public AppMarketPlaceDefinitionList listApplications(@QueryMap(encoded=true) ListApplicationsQueryParams var1);

    @RequestLine(value="GET /v1/apps/marketplace?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AppMarketPlaceDefinitionList> listApplicationsWithHttpInfo(@QueryMap(encoded=true) ListApplicationsQueryParams var1);

    @RequestLine(value="GET /v1/apps?fields={fields}&limit={limit}&before={before}&after={after}&agentType={agentType}&include={include}")
    @Headers(value={"Accept: application/json"})
    public AppList listInstalledApplications(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="before") @Nullable String var3, @Param(value="after") @Nullable String var4, @Param(value="agentType") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/apps?fields={fields}&limit={limit}&before={before}&after={after}&agentType={agentType}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AppList> listInstalledApplicationsWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="before") @Nullable String var3, @Param(value="after") @Nullable String var4, @Param(value="agentType") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/apps?fields={fields}&limit={limit}&before={before}&after={after}&agentType={agentType}&include={include}")
    @Headers(value={"Accept: application/json"})
    public AppList listInstalledApplications(@QueryMap(encoded=true) ListInstalledApplicationsQueryParams var1);

    @RequestLine(value="GET /v1/apps?fields={fields}&limit={limit}&before={before}&after={after}&agentType={agentType}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AppList> listInstalledApplicationsWithHttpInfo(@QueryMap(encoded=true) ListInstalledApplicationsQueryParams var1);

    @RequestLine(value="GET /v1/apps/installed")
    @Headers(value={"Accept: application/json"})
    public AppRefList listInstalledAppsInformation();

    @RequestLine(value="GET /v1/apps/installed")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AppRefList> listInstalledAppsInformationWithHttpInfo();

    @RequestLine(value="PATCH /v1/apps/marketplace/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchApplication(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/apps/marketplace/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchApplicationWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/apps/marketplace/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchApplication1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/apps/marketplace/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchApplication1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/apps/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchApplication2(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/apps/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchApplication2WithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/apps/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchApplication3(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/apps/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchApplication3WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/apps/marketplace/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public AppMarketPlaceDefinition restore2(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/apps/marketplace/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<AppMarketPlaceDefinition> restore2WithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/apps/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public App restore3(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/apps/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<App> restore3WithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="POST /v1/apps/schedule/{name}")
    @Headers(value={"Accept: application/json"})
    public Response scheduleApplication(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="POST /v1/apps/schedule/{name}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Response> scheduleApplicationWithHttpInfo(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="POST /v1/apps/stop/{name}")
    @Headers(value={"Accept: application/json"})
    public void stopApplicationRun(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="POST /v1/apps/stop/{name}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> stopApplicationRunWithHttpInfo(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="POST /v1/apps/trigger/{name}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void triggerApplicationRun(@Param(value="name") @Nonnull String var1, @Nullable Map<String, Object> var2);

    @RequestLine(value="POST /v1/apps/trigger/{name}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> triggerApplicationRunWithHttpInfo(@Param(value="name") @Nonnull String var1, @Nullable Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/apps/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void uninstallAppByName(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/apps/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> uninstallAppByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/apps/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void uninstallAppByName(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) UninstallAppByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/apps/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> uninstallAppByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) UninstallAppByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/apps/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void uninstallAppByName1(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/apps/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> uninstallAppByName1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/apps/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void uninstallAppByName1(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) UninstallAppByName1QueryParams var2);

    @RequestLine(value="DELETE /v1/apps/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> uninstallAppByName1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) UninstallAppByName1QueryParams var2);

    @RequestLine(value="DELETE /v1/apps/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void uninstallAppByNameAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/apps/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> uninstallAppByNameAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/apps/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void uninstallAppByNameAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) UninstallAppByNameAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/apps/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> uninstallAppByNameAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) UninstallAppByNameAsyncQueryParams var2);

    public static class UninstallAppByNameAsyncQueryParams
    extends HashMap<String, Object> {
        public UninstallAppByNameAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class UninstallAppByName1QueryParams
    extends HashMap<String, Object> {
        public UninstallAppByName1QueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class UninstallAppByNameQueryParams
    extends HashMap<String, Object> {
        public UninstallAppByNameQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListInstalledApplicationsQueryParams
    extends HashMap<String, Object> {
        public ListInstalledApplicationsQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListInstalledApplicationsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListInstalledApplicationsQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListInstalledApplicationsQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListInstalledApplicationsQueryParams agentType(@Nullable String value) {
            this.put("agentType", EncodingUtils.encode(value));
            return this;
        }

        public ListInstalledApplicationsQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListApplicationsQueryParams
    extends HashMap<String, Object> {
        public ListApplicationsQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListApplicationsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListApplicationsQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListApplicationsQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListApplicationsQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListAppRunRecordsQueryParams
    extends HashMap<String, Object> {
        public ListAppRunRecordsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListAppRunRecordsQueryParams offset(@Nullable Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public ListAppRunRecordsQueryParams startTs(@Nullable BigDecimal value) {
            this.put("startTs", EncodingUtils.encode(value));
            return this;
        }

        public ListAppRunRecordsQueryParams endTs(@Nullable BigDecimal value) {
            this.put("endTs", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListAppExtensionQueryParams
    extends HashMap<String, Object> {
        public ListAppExtensionQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListAppExtensionQueryParams offset(@Nullable Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public ListAppExtensionQueryParams startTs(@Nullable BigDecimal value) {
            this.put("startTs", EncodingUtils.encode(value));
            return this;
        }

        public ListAppExtensionQueryParams extensionType(@Nullable String value) {
            this.put("extensionType", EncodingUtils.encode(value));
            return this;
        }

        public ListAppExtensionQueryParams byName(@Nullable Boolean value) {
            this.put("byName", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class LatestAppRunRecordQueryParams
    extends HashMap<String, Object> {
        public LatestAppRunRecordQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetLastLogsQueryParams
    extends HashMap<String, Object> {
        public GetLastLogsQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetAppByName1QueryParams
    extends HashMap<String, Object> {
        public GetAppByName1QueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetAppByName1QueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetAppByNameQueryParams
    extends HashMap<String, Object> {
        public GetAppByNameQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetAppByNameQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class Get1QueryParams
    extends HashMap<String, Object> {
        public Get1QueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public Get1QueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetQueryParams
    extends HashMap<String, Object> {
        public GetQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteAppByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteAppByNameQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteAppAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteAppAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteAppQueryParams
    extends HashMap<String, Object> {
        public DeleteAppQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

