/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.Bot;
import org.openmetadata.client.model.BotList;
import org.openmetadata.client.model.CreateBot;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;

public interface BotsApi
extends ApiClient.Api {
    @RequestLine(value="POST /v1/bots")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Bot createBot(@Nullable CreateBot var1);

    @RequestLine(value="POST /v1/bots")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Bot> createBotWithHttpInfo(@Nullable CreateBot var1);

    @RequestLine(value="PUT /v1/bots")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Bot createOrUpdateBot(@Nullable CreateBot var1);

    @RequestLine(value="PUT /v1/bots")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Bot> createOrUpdateBotWithHttpInfo(@Nullable CreateBot var1);

    @RequestLine(value="DELETE /v1/bots/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteBot(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/bots/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteBotWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/bots/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteBot(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteBotQueryParams var2);

    @RequestLine(value="DELETE /v1/bots/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteBotWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteBotQueryParams var2);

    @RequestLine(value="DELETE /v1/bots/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteBotAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/bots/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteBotAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/bots/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteBotAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteBotAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/bots/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteBotAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteBotAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/bots/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteBotByFQN(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/bots/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteBotByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/bots/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteBotByFQN(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteBotByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/bots/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteBotByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteBotByFQNQueryParams var2);

    @RequestLine(value="GET /v1/bots/name/{name}?include={include}")
    @Headers(value={"Accept: application/json"})
    public Bot getBotByFQN(@Param(value="name") @Nonnull String var1, @Param(value="include") @Nullable String var2);

    @RequestLine(value="GET /v1/bots/name/{name}?include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Bot> getBotByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="include") @Nullable String var2);

    @RequestLine(value="GET /v1/bots/name/{name}?include={include}")
    @Headers(value={"Accept: application/json"})
    public Bot getBotByFQN(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetBotByFQNQueryParams var2);

    @RequestLine(value="GET /v1/bots/name/{name}?include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Bot> getBotByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetBotByFQNQueryParams var2);

    @RequestLine(value="GET /v1/bots/{id}?include={include}")
    @Headers(value={"Accept: application/json"})
    public Bot getBotByID(@Param(value="id") @Nonnull UUID var1, @Param(value="include") @Nullable String var2);

    @RequestLine(value="GET /v1/bots/{id}?include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Bot> getBotByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="include") @Nullable String var2);

    @RequestLine(value="GET /v1/bots/{id}?include={include}")
    @Headers(value={"Accept: application/json"})
    public Bot getBotByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetBotByIDQueryParams var2);

    @RequestLine(value="GET /v1/bots/{id}?include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Bot> getBotByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetBotByIDQueryParams var2);

    @RequestLine(value="GET /v1/bots/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllBotVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/bots/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllBotVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/bots?limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public BotList listBots(@Param(value="limit") @Nullable Integer var1, @Param(value="before") @Nullable String var2, @Param(value="after") @Nullable String var3, @Param(value="include") @Nullable String var4);

    @RequestLine(value="GET /v1/bots?limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<BotList> listBotsWithHttpInfo(@Param(value="limit") @Nullable Integer var1, @Param(value="before") @Nullable String var2, @Param(value="after") @Nullable String var3, @Param(value="include") @Nullable String var4);

    @RequestLine(value="GET /v1/bots?limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public BotList listBots(@QueryMap(encoded=true) ListBotsQueryParams var1);

    @RequestLine(value="GET /v1/bots?limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<BotList> listBotsWithHttpInfo(@QueryMap(encoded=true) ListBotsQueryParams var1);

    @RequestLine(value="GET /v1/bots/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Bot listSpecificBotVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/bots/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Bot> listSpecificBotVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="PATCH /v1/bots/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchBot(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/bots/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchBotWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/bots/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchBot1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/bots/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchBot1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/bots/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Bot restore4(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/bots/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Bot> restore4WithHttpInfo(@Nullable RestoreEntity var1);

    public static class ListBotsQueryParams
    extends HashMap<String, Object> {
        public ListBotsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListBotsQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListBotsQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListBotsQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetBotByIDQueryParams
    extends HashMap<String, Object> {
        public GetBotByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetBotByFQNQueryParams
    extends HashMap<String, Object> {
        public GetBotByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteBotByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteBotByFQNQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteBotAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteBotAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteBotQueryParams
    extends HashMap<String, Object> {
        public DeleteBotQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

