/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.AddTagToAssetsRequest;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.BulkOperationResult;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.Classification;
import org.openmetadata.client.model.ClassificationList;
import org.openmetadata.client.model.CreateClassification;
import org.openmetadata.client.model.CreateTag;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.RecognizerFeedback;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.Tag;
import org.openmetadata.client.model.TagList;

public interface ClassificationsApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/tags/{id}/assets/add")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public BulkOperationResult bulkAddTagToAssets(@Param(value="id") @Nonnull UUID var1, @Nullable AddTagToAssetsRequest var2);

    @RequestLine(value="PUT /v1/tags/{id}/assets/add")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<BulkOperationResult> bulkAddTagToAssetsWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable AddTagToAssetsRequest var2);

    @RequestLine(value="PUT /v1/tags/{id}/assets/remove")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent bulkRemoveTagFromAssets(@Param(value="id") @Nonnull UUID var1, @Nullable AddTagToAssetsRequest var2);

    @RequestLine(value="PUT /v1/tags/{id}/assets/remove")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> bulkRemoveTagFromAssetsWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable AddTagToAssetsRequest var2);

    @RequestLine(value="POST /v1/classifications")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Classification createClassification(@Nullable CreateClassification var1);

    @RequestLine(value="POST /v1/classifications")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Classification> createClassificationWithHttpInfo(@Nullable CreateClassification var1);

    @RequestLine(value="PUT /v1/classifications")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void createOrUpdateClassification(@Nullable CreateClassification var1);

    @RequestLine(value="PUT /v1/classifications")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> createOrUpdateClassificationWithHttpInfo(@Nullable CreateClassification var1);

    @RequestLine(value="PUT /v1/tags")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Tag createOrUpdateTag(@Nullable CreateTag var1);

    @RequestLine(value="PUT /v1/tags")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Tag> createOrUpdateTagWithHttpInfo(@Nullable CreateTag var1);

    @RequestLine(value="POST /v1/tags")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Tag createTag(@Nullable CreateTag var1);

    @RequestLine(value="POST /v1/tags")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Tag> createTagWithHttpInfo(@Nullable CreateTag var1);

    @RequestLine(value="DELETE /v1/classifications/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteClassification(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/classifications/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteClassificationWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/classifications/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteClassification(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteClassificationQueryParams var2);

    @RequestLine(value="DELETE /v1/classifications/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteClassificationWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteClassificationQueryParams var2);

    @RequestLine(value="DELETE /v1/classifications/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteClassificationAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/classifications/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteClassificationAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/classifications/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteClassificationAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteClassificationAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/classifications/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteClassificationAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteClassificationAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/classifications/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteClassificationByName(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/classifications/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteClassificationByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/classifications/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteClassificationByName(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteClassificationByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/classifications/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteClassificationByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteClassificationByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/tags/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTag(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/tags/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTagWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/tags/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTag(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteTagQueryParams var2);

    @RequestLine(value="DELETE /v1/tags/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTagWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteTagQueryParams var2);

    @RequestLine(value="DELETE /v1/tags/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTagAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/tags/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTagAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/tags/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTagAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteTagAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/tags/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTagAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteTagAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/tags/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTagByName(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/tags/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTagByNameWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/tags/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTagByName(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteTagByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/tags/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTagByNameWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteTagByNameQueryParams var2);

    @RequestLine(value="GET /v1/tags/assets/counts")
    @Headers(value={"Accept: application/json"})
    public void getAllTagsWithAssetsCount();

    @RequestLine(value="GET /v1/tags/assets/counts")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> getAllTagsWithAssetsCountWithHttpInfo();

    @RequestLine(value="GET /v1/classifications/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Classification getClassificationByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/classifications/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Classification> getClassificationByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/classifications/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Classification getClassificationByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetClassificationByIDQueryParams var2);

    @RequestLine(value="GET /v1/classifications/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Classification> getClassificationByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetClassificationByIDQueryParams var2);

    @RequestLine(value="GET /v1/classifications/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Classification getClassificationByName(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/classifications/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Classification> getClassificationByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/classifications/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Classification getClassificationByName(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetClassificationByNameQueryParams var2);

    @RequestLine(value="GET /v1/classifications/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Classification> getClassificationByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetClassificationByNameQueryParams var2);

    @RequestLine(value="GET /v1/tags/feedback/pending")
    @Headers(value={"Accept: application/json"})
    public void getPendingFeedback();

    @RequestLine(value="GET /v1/tags/feedback/pending")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> getPendingFeedbackWithHttpInfo();

    @RequestLine(value="GET /v1/tags/feedback/{id}")
    @Headers(value={"Accept: application/json"})
    public RecognizerFeedback getRecognizerFeedback(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/tags/feedback/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<RecognizerFeedback> getRecognizerFeedbackWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/classifications/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Classification getSpecificClassificationVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/classifications/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Classification> getSpecificClassificationVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/tags/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Tag getSpecificTagVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/tags/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Tag> getSpecificTagVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/tags/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Tag getTagByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/tags/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Tag> getTagByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/tags/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Tag getTagByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetTagByFQNQueryParams var2);

    @RequestLine(value="GET /v1/tags/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Tag> getTagByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetTagByFQNQueryParams var2);

    @RequestLine(value="GET /v1/tags/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Tag getTagByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/tags/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Tag> getTagByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/tags/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Tag getTagByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetTagByIDQueryParams var2);

    @RequestLine(value="GET /v1/tags/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Tag> getTagByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetTagByIDQueryParams var2);

    @RequestLine(value="GET /v1/tags/name/{fqn}/feedback")
    @Headers(value={"Accept: application/json"})
    public void getTagFeedback(@Param(value="fqn") @Nonnull String var1);

    @RequestLine(value="GET /v1/tags/name/{fqn}/feedback")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> getTagFeedbackWithHttpInfo(@Param(value="fqn") @Nonnull String var1);

    @RequestLine(value="GET /v1/classifications/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllClassificationVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/classifications/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllClassificationVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/tags/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllTagVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/tags/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllTagVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/classifications?fields={fields}&disabled={disabled}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ClassificationList listClassifications(@Param(value="fields") @Nullable String var1, @Param(value="disabled") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/classifications?fields={fields}&disabled={disabled}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ClassificationList> listClassificationsWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="disabled") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/classifications?fields={fields}&disabled={disabled}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ClassificationList listClassifications(@QueryMap(encoded=true) ListClassificationsQueryParams var1);

    @RequestLine(value="GET /v1/classifications?fields={fields}&disabled={disabled}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ClassificationList> listClassificationsWithHttpInfo(@QueryMap(encoded=true) ListClassificationsQueryParams var1);

    @RequestLine(value="GET /v1/tags/{id}/assets?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public EntityReference listTagAssets(@Param(value="id") @Nonnull UUID var1, @Param(value="limit") @Nullable Integer var2, @Param(value="offset") @Nullable Integer var3);

    @RequestLine(value="GET /v1/tags/{id}/assets?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityReference> listTagAssetsWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="limit") @Nullable Integer var2, @Param(value="offset") @Nullable Integer var3);

    @RequestLine(value="GET /v1/tags/{id}/assets?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public EntityReference listTagAssets(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) ListTagAssetsQueryParams var2);

    @RequestLine(value="GET /v1/tags/{id}/assets?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityReference> listTagAssetsWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) ListTagAssetsQueryParams var2);

    @RequestLine(value="GET /v1/tags/name/{fqn}/assets?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public EntityReference listTagAssetsByName(@Param(value="fqn") @Nonnull String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="offset") @Nullable Integer var3);

    @RequestLine(value="GET /v1/tags/name/{fqn}/assets?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityReference> listTagAssetsByNameWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="offset") @Nullable Integer var3);

    @RequestLine(value="GET /v1/tags/name/{fqn}/assets?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public EntityReference listTagAssetsByName(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) ListTagAssetsByNameQueryParams var2);

    @RequestLine(value="GET /v1/tags/name/{fqn}/assets?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityReference> listTagAssetsByNameWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) ListTagAssetsByNameQueryParams var2);

    @RequestLine(value="GET /v1/tags?parent={parent}&fields={fields}&disabled={disabled}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TagList listTags(@Param(value="parent") @Nullable String var1, @Param(value="fields") @Nullable String var2, @Param(value="disabled") @Nullable String var3, @Param(value="limit") @Nullable Integer var4, @Param(value="before") @Nullable String var5, @Param(value="after") @Nullable String var6, @Param(value="include") @Nullable String var7);

    @RequestLine(value="GET /v1/tags?parent={parent}&fields={fields}&disabled={disabled}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TagList> listTagsWithHttpInfo(@Param(value="parent") @Nullable String var1, @Param(value="fields") @Nullable String var2, @Param(value="disabled") @Nullable String var3, @Param(value="limit") @Nullable Integer var4, @Param(value="before") @Nullable String var5, @Param(value="after") @Nullable String var6, @Param(value="include") @Nullable String var7);

    @RequestLine(value="GET /v1/tags?parent={parent}&fields={fields}&disabled={disabled}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TagList listTags(@QueryMap(encoded=true) ListTagsQueryParams var1);

    @RequestLine(value="GET /v1/tags?parent={parent}&fields={fields}&disabled={disabled}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TagList> listTagsWithHttpInfo(@QueryMap(encoded=true) ListTagsQueryParams var1);

    @RequestLine(value="PATCH /v1/classifications/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchClassification(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/classifications/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchClassificationWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/classifications/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchClassification1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/classifications/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchClassification1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/tags/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchTag(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/tags/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchTagWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/tags/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchTag1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/tags/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchTag1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/classifications/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Classification restoreClassification(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/classifications/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Classification> restoreClassificationWithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/tags/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Tag restoreTag(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/tags/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Tag> restoreTagWithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="POST /v1/tags/name/{fqn}/feedback")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public RecognizerFeedback submitRecognizerFeedback(@Param(value="fqn") @Nonnull String var1, @Nullable RecognizerFeedback var2);

    @RequestLine(value="POST /v1/tags/name/{fqn}/feedback")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<RecognizerFeedback> submitRecognizerFeedbackWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable RecognizerFeedback var2);

    public static class ListTagsQueryParams
    extends HashMap<String, Object> {
        public ListTagsQueryParams parent(@Nullable String value) {
            this.put("parent", EncodingUtils.encode(value));
            return this;
        }

        public ListTagsQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListTagsQueryParams disabled(@Nullable String value) {
            this.put("disabled", EncodingUtils.encode(value));
            return this;
        }

        public ListTagsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListTagsQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListTagsQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListTagsQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListTagAssetsByNameQueryParams
    extends HashMap<String, Object> {
        public ListTagAssetsByNameQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListTagAssetsByNameQueryParams offset(@Nullable Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListTagAssetsQueryParams
    extends HashMap<String, Object> {
        public ListTagAssetsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListTagAssetsQueryParams offset(@Nullable Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListClassificationsQueryParams
    extends HashMap<String, Object> {
        public ListClassificationsQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListClassificationsQueryParams disabled(@Nullable String value) {
            this.put("disabled", EncodingUtils.encode(value));
            return this;
        }

        public ListClassificationsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListClassificationsQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListClassificationsQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListClassificationsQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTagByIDQueryParams
    extends HashMap<String, Object> {
        public GetTagByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTagByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTagByFQNQueryParams
    extends HashMap<String, Object> {
        public GetTagByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTagByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetClassificationByNameQueryParams
    extends HashMap<String, Object> {
        public GetClassificationByNameQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetClassificationByNameQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetClassificationByIDQueryParams
    extends HashMap<String, Object> {
        public GetClassificationByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetClassificationByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTagByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteTagByNameQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTagAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteTagAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteTagAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTagQueryParams
    extends HashMap<String, Object> {
        public DeleteTagQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteTagQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteClassificationByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteClassificationByNameQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteClassificationAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteClassificationAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteClassificationAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteClassificationQueryParams
    extends HashMap<String, Object> {
        public DeleteClassificationQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteClassificationQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

