/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateDashboardService;
import org.openmetadata.client.model.DashboardService;
import org.openmetadata.client.model.DashboardServiceList;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.TestConnectionResult;

public interface DashboardServicesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/services/dashboardServices/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollowerToDashboardService(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/services/dashboardServices/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerToDashboardServiceWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/services/dashboardServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DashboardService addTestConnectionResult1(@Param(value="id") @Nonnull UUID var1, @Nullable TestConnectionResult var2);

    @RequestLine(value="PUT /v1/services/dashboardServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DashboardService> addTestConnectionResult1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable TestConnectionResult var2);

    @RequestLine(value="POST /v1/services/dashboardServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DashboardService createDashboardService(@Nullable CreateDashboardService var1);

    @RequestLine(value="POST /v1/services/dashboardServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DashboardService> createDashboardServiceWithHttpInfo(@Nullable CreateDashboardService var1);

    @RequestLine(value="PUT /v1/services/dashboardServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DashboardService createOrUpdateDashboardService(@Nullable CreateDashboardService var1);

    @RequestLine(value="PUT /v1/services/dashboardServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DashboardService> createOrUpdateDashboardServiceWithHttpInfo(@Nullable CreateDashboardService var1);

    @RequestLine(value="DELETE /v1/services/dashboardServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDashboardService(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/dashboardServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDashboardServiceWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/dashboardServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDashboardService(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDashboardServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/dashboardServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDashboardServiceWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDashboardServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/dashboardServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDashboardServiceAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/dashboardServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDashboardServiceAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/dashboardServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDashboardServiceAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDashboardServiceAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/services/dashboardServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDashboardServiceAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDashboardServiceAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/services/dashboardServices/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDashboardServiceByName(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/dashboardServices/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDashboardServiceByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/dashboardServices/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDashboardServiceByName(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteDashboardServiceByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/services/dashboardServices/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDashboardServiceByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteDashboardServiceByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/services/dashboardServices/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower11(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/services/dashboardServices/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower11WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="GET /v1/services/dashboardServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardService getDashboardServiceByFQN(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/dashboardServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardService> getDashboardServiceByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/dashboardServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardService getDashboardServiceByFQN(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetDashboardServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/dashboardServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardService> getDashboardServiceByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetDashboardServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/dashboardServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardService getDashboardServiceByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/dashboardServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardService> getDashboardServiceByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/dashboardServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardService getDashboardServiceByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetDashboardServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/dashboardServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardService> getDashboardServiceByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetDashboardServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/dashboardServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public DashboardService getSpecificDashboardServiceVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/services/dashboardServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardService> getSpecificDashboardServiceVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/services/dashboardServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllDashboardServiceVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/services/dashboardServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllDashboardServiceVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/services/dashboardServices?name={name}&fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardServiceList listDashboardsService(@Param(value="name") @Nullable String var1, @Param(value="fields") @Nullable String var2, @Param(value="domain") @Nullable String var3, @Param(value="limit") @Nullable Integer var4, @Param(value="before") @Nullable String var5, @Param(value="after") @Nullable String var6, @Param(value="include") @Nullable String var7);

    @RequestLine(value="GET /v1/services/dashboardServices?name={name}&fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardServiceList> listDashboardsServiceWithHttpInfo(@Param(value="name") @Nullable String var1, @Param(value="fields") @Nullable String var2, @Param(value="domain") @Nullable String var3, @Param(value="limit") @Nullable Integer var4, @Param(value="before") @Nullable String var5, @Param(value="after") @Nullable String var6, @Param(value="include") @Nullable String var7);

    @RequestLine(value="GET /v1/services/dashboardServices?name={name}&fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardServiceList listDashboardsService(@QueryMap(encoded=true) ListDashboardsServiceQueryParams var1);

    @RequestLine(value="GET /v1/services/dashboardServices?name={name}&fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardServiceList> listDashboardsServiceWithHttpInfo(@QueryMap(encoded=true) ListDashboardsServiceQueryParams var1);

    @RequestLine(value="PATCH /v1/services/dashboardServices/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDashboardService(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/dashboardServices/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchDashboardServiceWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/dashboardServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDashboardService1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/dashboardServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchDashboardService1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/services/dashboardServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DashboardService restore27(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/services/dashboardServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DashboardService> restore27WithHttpInfo(@Nullable RestoreEntity var1);

    public static class ListDashboardsServiceQueryParams
    extends HashMap<String, Object> {
        public ListDashboardsServiceQueryParams name(@Nullable String value) {
            this.put("name", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardsServiceQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardsServiceQueryParams domain(@Nullable String value) {
            this.put("domain", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardsServiceQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardsServiceQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardsServiceQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardsServiceQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDashboardServiceByIDQueryParams
    extends HashMap<String, Object> {
        public GetDashboardServiceByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDashboardServiceByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDashboardServiceByFQNQueryParams
    extends HashMap<String, Object> {
        public GetDashboardServiceByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDashboardServiceByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDashboardServiceByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteDashboardServiceByNameQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDashboardServiceByNameQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDashboardServiceAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteDashboardServiceAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDashboardServiceAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDashboardServiceQueryParams
    extends HashMap<String, Object> {
        public DeleteDashboardServiceQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDashboardServiceQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

