/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateDashboard;
import org.openmetadata.client.model.Dashboard;
import org.openmetadata.client.model.DashboardList;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.VoteRequest;

public interface DashboardsApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/dashboards/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void addFollowerToDashboard(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="PUT /v1/dashboards/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> addFollowerToDashboardWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="POST /v1/dashboards")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Dashboard createDashboard(@Nullable CreateDashboard var1);

    @RequestLine(value="POST /v1/dashboards")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Dashboard> createDashboardWithHttpInfo(@Nullable CreateDashboard var1);

    @RequestLine(value="PUT /v1/dashboards")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Dashboard createOrUpdateDashboard(@Nullable CreateDashboard var1);

    @RequestLine(value="PUT /v1/dashboards")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Dashboard> createOrUpdateDashboardWithHttpInfo(@Nullable CreateDashboard var1);

    @RequestLine(value="DELETE /v1/dashboards/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDashboard(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/dashboards/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDashboardWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/dashboards/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDashboard(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDashboardQueryParams var2);

    @RequestLine(value="DELETE /v1/dashboards/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDashboardWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDashboardQueryParams var2);

    @RequestLine(value="DELETE /v1/dashboards/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDashboardAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/dashboards/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDashboardAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/dashboards/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDashboardAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDashboardAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/dashboards/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDashboardAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDashboardAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/dashboards/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDashboardByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/dashboards/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDashboardByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/dashboards/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDashboardByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteDashboardByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/dashboards/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDashboardByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteDashboardByFQNQueryParams var2);

    @RequestLine(value="GET /v1/dashboards/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Dashboard getDashboardByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/dashboards/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Dashboard> getDashboardByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/dashboards/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Dashboard getDashboardByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetDashboardByFQNQueryParams var2);

    @RequestLine(value="GET /v1/dashboards/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Dashboard> getDashboardByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetDashboardByFQNQueryParams var2);

    @RequestLine(value="GET /v1/dashboards/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Dashboard getDashboardByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/dashboards/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Dashboard> getDashboardByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/dashboards/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Dashboard getDashboardByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetDashboardByIDQueryParams var2);

    @RequestLine(value="GET /v1/dashboards/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Dashboard> getDashboardByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetDashboardByIDQueryParams var2);

    @RequestLine(value="GET /v1/dashboards/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Dashboard getSpecificDashboardVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/dashboards/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Dashboard> getSpecificDashboardVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/dashboards/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllDashboardVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/dashboards/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllDashboardVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/dashboards?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardList listDashboards(@Param(value="fields") @Nullable String var1, @Param(value="service") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/dashboards?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardList> listDashboardsWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="service") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/dashboards?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardList listDashboards(@QueryMap(encoded=true) ListDashboardsQueryParams var1);

    @RequestLine(value="GET /v1/dashboards?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardList> listDashboardsWithHttpInfo(@QueryMap(encoded=true) ListDashboardsQueryParams var1);

    @RequestLine(value="PATCH /v1/dashboards/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDashboard(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/dashboards/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchDashboardWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/dashboards/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDashboard1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/dashboards/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchDashboard1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="DELETE /v1/dashboards/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public void removeFollowerFromDashboard(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull UUID var2);

    @RequestLine(value="DELETE /v1/dashboards/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> removeFollowerFromDashboardWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull UUID var2);

    @RequestLine(value="PUT /v1/dashboards/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Dashboard restore6(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/dashboards/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Dashboard> restore6WithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/dashboards/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForEntity1(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    @RequestLine(value="PUT /v1/dashboards/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForEntity1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    public static class ListDashboardsQueryParams
    extends HashMap<String, Object> {
        public ListDashboardsQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardsQueryParams service(@Nullable String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardsQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardsQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardsQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDashboardByIDQueryParams
    extends HashMap<String, Object> {
        public GetDashboardByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDashboardByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDashboardByFQNQueryParams
    extends HashMap<String, Object> {
        public GetDashboardByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDashboardByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDashboardByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteDashboardByFQNQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDashboardByFQNQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDashboardAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteDashboardAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDashboardQueryParams
    extends HashMap<String, Object> {
        public DeleteDashboardQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

