/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.DataContract;
import org.openmetadata.client.model.DataContractList;
import org.openmetadata.client.model.DataContractResult;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.ResultList;

public interface DataContractsApi
extends ApiClient.Api {
    @RequestLine(value="POST /v1/dataContracts")
    @Headers(value={"Content-Type: application/yaml", "Accept: application/json"})
    public DataContract createDataContractFromYaml(@Nullable String var1);

    @RequestLine(value="POST /v1/dataContracts")
    @Headers(value={"Content-Type: application/yaml", "Accept: application/json"})
    public ApiResponse<DataContract> createDataContractFromYamlWithHttpInfo(@Nullable String var1);

    @RequestLine(value="PUT /v1/dataContracts")
    @Headers(value={"Content-Type: application/yaml", "Accept: application/json"})
    public DataContract createOrUpdateDataContractFromYaml(@Nullable String var1);

    @RequestLine(value="PUT /v1/dataContracts")
    @Headers(value={"Content-Type: application/yaml", "Accept: application/json"})
    public ApiResponse<DataContract> createOrUpdateDataContractFromYamlWithHttpInfo(@Nullable String var1);

    @RequestLine(value="PUT /v1/dataContracts/{id}/results")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DataContractResult createOrUpdateDataContractResult(@Param(value="id") @Nonnull UUID var1, @Nullable DataContractResult var2);

    @RequestLine(value="PUT /v1/dataContracts/{id}/results")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DataContractResult> createOrUpdateDataContractResultWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable DataContractResult var2);

    @RequestLine(value="DELETE /v1/dataContracts/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDataContract(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/dataContracts/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDataContractWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/dataContracts/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDataContract(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDataContractQueryParams var2);

    @RequestLine(value="DELETE /v1/dataContracts/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDataContractWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDataContractQueryParams var2);

    @RequestLine(value="DELETE /v1/dataContracts/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDataContractAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/dataContracts/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDataContractAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/dataContracts/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDataContractAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDataContractAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/dataContracts/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDataContractAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDataContractAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/dataContracts/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDataContractByName(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/dataContracts/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDataContractByNameWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/dataContracts/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDataContractByName(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteDataContractByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/dataContracts/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDataContractByNameWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteDataContractByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/dataContracts/{id}/results/{timestamp}")
    @Headers(value={"Accept: application/json"})
    public void deleteDataContractResult(@Param(value="id") @Nonnull UUID var1, @Param(value="timestamp") @Nonnull BigDecimal var2);

    @RequestLine(value="DELETE /v1/dataContracts/{id}/results/{timestamp}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDataContractResultWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="timestamp") @Nonnull BigDecimal var2);

    @RequestLine(value="DELETE /v1/dataContracts/{id}/results/before/{timestamp}")
    @Headers(value={"Accept: application/json"})
    public void deleteDataContractResultsBefore(@Param(value="id") @Nonnull UUID var1, @Param(value="timestamp") @Nonnull BigDecimal var2);

    @RequestLine(value="DELETE /v1/dataContracts/{id}/results/before/{timestamp}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDataContractResultsBeforeWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="timestamp") @Nonnull BigDecimal var2);

    @RequestLine(value="GET /v1/dataContracts/entity?entityId={entityId}&entityType={entityType}&fields={fields}")
    @Headers(value={"Accept: application/json"})
    public DataContract getDataContractByEntityId(@Param(value="entityId") @Nullable String var1, @Param(value="entityType") @Nullable String var2, @Param(value="fields") @Nullable String var3);

    @RequestLine(value="GET /v1/dataContracts/entity?entityId={entityId}&entityType={entityType}&fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataContract> getDataContractByEntityIdWithHttpInfo(@Param(value="entityId") @Nullable String var1, @Param(value="entityType") @Nullable String var2, @Param(value="fields") @Nullable String var3);

    @RequestLine(value="GET /v1/dataContracts/entity?entityId={entityId}&entityType={entityType}&fields={fields}")
    @Headers(value={"Accept: application/json"})
    public DataContract getDataContractByEntityId(@QueryMap(encoded=true) GetDataContractByEntityIdQueryParams var1);

    @RequestLine(value="GET /v1/dataContracts/entity?entityId={entityId}&entityType={entityType}&fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataContract> getDataContractByEntityIdWithHttpInfo(@QueryMap(encoded=true) GetDataContractByEntityIdQueryParams var1);

    @RequestLine(value="GET /v1/dataContracts/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DataContract getDataContractByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/dataContracts/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataContract> getDataContractByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/dataContracts/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DataContract getDataContractByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetDataContractByFQNQueryParams var2);

    @RequestLine(value="GET /v1/dataContracts/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataContract> getDataContractByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetDataContractByFQNQueryParams var2);

    @RequestLine(value="GET /v1/dataContracts/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DataContract getDataContractByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/dataContracts/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataContract> getDataContractByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/dataContracts/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DataContract getDataContractByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetDataContractByIDQueryParams var2);

    @RequestLine(value="GET /v1/dataContracts/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataContract> getDataContractByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetDataContractByIDQueryParams var2);

    @RequestLine(value="GET /v1/dataContracts/{id}/results/{resultId}")
    @Headers(value={"Accept: application/json"})
    public DataContractResult getDataContractResult(@Param(value="id") @Nonnull UUID var1, @Param(value="resultId") @Nonnull UUID var2);

    @RequestLine(value="GET /v1/dataContracts/{id}/results/{resultId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataContractResult> getDataContractResultWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="resultId") @Nonnull UUID var2);

    @RequestLine(value="GET /v1/dataContracts/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public DataContract getDataContractVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/dataContracts/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataContract> getDataContractVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/dataContracts/{id}/results/latest")
    @Headers(value={"Accept: application/json"})
    public DataContractResult getLatestDataContractResult(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/dataContracts/{id}/results/latest")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataContractResult> getLatestDataContractResultWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/dataContracts/{id}/results?limit={limit}&startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ResultList listDataContractResults(@Param(value="id") @Nonnull UUID var1, @Param(value="limit") @Nullable Integer var2, @Param(value="startTs") @Nullable BigDecimal var3, @Param(value="endTs") @Nullable BigDecimal var4);

    @RequestLine(value="GET /v1/dataContracts/{id}/results?limit={limit}&startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ResultList> listDataContractResultsWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="limit") @Nullable Integer var2, @Param(value="startTs") @Nullable BigDecimal var3, @Param(value="endTs") @Nullable BigDecimal var4);

    @RequestLine(value="GET /v1/dataContracts/{id}/results?limit={limit}&startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ResultList listDataContractResults(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) ListDataContractResultsQueryParams var2);

    @RequestLine(value="GET /v1/dataContracts/{id}/results?limit={limit}&startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ResultList> listDataContractResultsWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) ListDataContractResultsQueryParams var2);

    @RequestLine(value="GET /v1/dataContracts/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listDataContractVersions(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/dataContracts/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listDataContractVersionsWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/dataContracts?fields={fields}&limit={limit}&before={before}&after={after}&include={include}&status={status}&entity={entity}")
    @Headers(value={"Accept: application/json"})
    public DataContractList listDataContracts(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Long var2, @Param(value="before") @Nullable String var3, @Param(value="after") @Nullable String var4, @Param(value="include") @Nullable String var5, @Param(value="status") @Nullable String var6, @Param(value="entity") @Nullable UUID var7);

    @RequestLine(value="GET /v1/dataContracts?fields={fields}&limit={limit}&before={before}&after={after}&include={include}&status={status}&entity={entity}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataContractList> listDataContractsWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Long var2, @Param(value="before") @Nullable String var3, @Param(value="after") @Nullable String var4, @Param(value="include") @Nullable String var5, @Param(value="status") @Nullable String var6, @Param(value="entity") @Nullable UUID var7);

    @RequestLine(value="GET /v1/dataContracts?fields={fields}&limit={limit}&before={before}&after={after}&include={include}&status={status}&entity={entity}")
    @Headers(value={"Accept: application/json"})
    public DataContractList listDataContracts(@QueryMap(encoded=true) ListDataContractsQueryParams var1);

    @RequestLine(value="GET /v1/dataContracts?fields={fields}&limit={limit}&before={before}&after={after}&include={include}&status={status}&entity={entity}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataContractList> listDataContractsWithHttpInfo(@QueryMap(encoded=true) ListDataContractsQueryParams var1);

    @RequestLine(value="PATCH /v1/dataContracts/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDataContract(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/dataContracts/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchDataContractWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/dataContracts/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DataContract restore7(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/dataContracts/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DataContract> restore7WithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="POST /v1/dataContracts/{id}/validate")
    @Headers(value={"Accept: application/json"})
    public DataContractResult validateDataContract(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="POST /v1/dataContracts/{id}/validate")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataContractResult> validateDataContractWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    public static class ListDataContractsQueryParams
    extends HashMap<String, Object> {
        public ListDataContractsQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListDataContractsQueryParams limit(@Nullable Long value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListDataContractsQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListDataContractsQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListDataContractsQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }

        public ListDataContractsQueryParams status(@Nullable String value) {
            this.put("status", EncodingUtils.encode(value));
            return this;
        }

        public ListDataContractsQueryParams entity(@Nullable UUID value) {
            this.put("entity", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListDataContractResultsQueryParams
    extends HashMap<String, Object> {
        public ListDataContractResultsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListDataContractResultsQueryParams startTs(@Nullable BigDecimal value) {
            this.put("startTs", EncodingUtils.encode(value));
            return this;
        }

        public ListDataContractResultsQueryParams endTs(@Nullable BigDecimal value) {
            this.put("endTs", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDataContractByIDQueryParams
    extends HashMap<String, Object> {
        public GetDataContractByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDataContractByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDataContractByFQNQueryParams
    extends HashMap<String, Object> {
        public GetDataContractByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDataContractByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDataContractByEntityIdQueryParams
    extends HashMap<String, Object> {
        public GetDataContractByEntityIdQueryParams entityId(@Nullable String value) {
            this.put("entityId", EncodingUtils.encode(value));
            return this;
        }

        public GetDataContractByEntityIdQueryParams entityType(@Nullable String value) {
            this.put("entityType", EncodingUtils.encode(value));
            return this;
        }

        public GetDataContractByEntityIdQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDataContractByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteDataContractByNameQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDataContractByNameQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDataContractAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteDataContractAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDataContractAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDataContractQueryParams
    extends HashMap<String, Object> {
        public DeleteDataContractQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDataContractQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }
}

