/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.LoginRequest;

public interface DefaultApi
extends ApiClient.Api {
    @RequestLine(value="POST /api/v1/example/entities/{type}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void createEntity(@Param(value="type") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="POST /api/v1/example/entities/{type}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> createEntityWithHttpInfo(@Param(value="type") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="DELETE /api/v1/example/entities/{type}/{id}")
    @Headers(value={"Accept: application/json"})
    public void deleteEntity(@Param(value="type") @Nonnull String var1, @Param(value="id") @Nonnull String var2);

    @RequestLine(value="DELETE /api/v1/example/entities/{type}/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteEntityWithHttpInfo(@Param(value="type") @Nonnull String var1, @Param(value="id") @Nonnull String var2);

    @RequestLine(value="GET /")
    @Headers(value={"Accept: text/html"})
    public void getIndex();

    @RequestLine(value="GET /")
    @Headers(value={"Accept: text/html"})
    public ApiResponse<Void> getIndexWithHttpInfo();

    @RequestLine(value="GET /api/v1/example/status")
    @Headers(value={"Accept: application/json"})
    public void getStatus();

    @RequestLine(value="GET /api/v1/example/status")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> getStatusWithHttpInfo();

    @RequestLine(value="POST /api/v1/example/auth/login")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void login(@Nullable LoginRequest var1);

    @RequestLine(value="POST /api/v1/example/auth/login")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> loginWithHttpInfo(@Nullable LoginRequest var1);

    @RequestLine(value="GET /api/v1/example/search?query={query}")
    @Headers(value={"Accept: application/json"})
    public void search(@Param(value="query") @Nullable String var1);

    @RequestLine(value="GET /api/v1/example/search?query={query}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> searchWithHttpInfo(@Param(value="query") @Nullable String var1);

    @RequestLine(value="GET /api/v1/example/search?query={query}")
    @Headers(value={"Accept: application/json"})
    public void search(@QueryMap(encoded=true) SearchQueryParams var1);

    @RequestLine(value="GET /api/v1/example/search?query={query}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> searchWithHttpInfo(@QueryMap(encoded=true) SearchQueryParams var1);

    @RequestLine(value="PUT /api/v1/example/entities/{type}/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void updateEntity(@Param(value="type") @Nonnull String var1, @Param(value="id") @Nonnull String var2, @Nullable Object var3);

    @RequestLine(value="PUT /api/v1/example/entities/{type}/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> updateEntityWithHttpInfo(@Param(value="type") @Nonnull String var1, @Param(value="id") @Nonnull String var2, @Nullable Object var3);

    public static class SearchQueryParams
    extends HashMap<String, Object> {
        public SearchQueryParams query(@Nullable String value) {
            this.put("query", EncodingUtils.encode(value));
            return this;
        }
    }
}

