/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.io.File;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateFile;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.FileList;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.VoteRequest;

public interface FilesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/drives/files/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollowerToFile(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="PUT /v1/drives/files/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerToFileWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="POST /v1/drives/files")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public File createFile(@Nullable CreateFile var1);

    @RequestLine(value="POST /v1/drives/files")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<File> createFileWithHttpInfo(@Nullable CreateFile var1);

    @RequestLine(value="PUT /v1/drives/files")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public File createOrUpdateFile(@Nullable CreateFile var1);

    @RequestLine(value="PUT /v1/drives/files")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<File> createOrUpdateFileWithHttpInfo(@Nullable CreateFile var1);

    @RequestLine(value="DELETE /v1/drives/files/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteFile(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/drives/files/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteFileWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/drives/files/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteFile(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteFileQueryParams var2);

    @RequestLine(value="DELETE /v1/drives/files/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteFileWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteFileQueryParams var2);

    @RequestLine(value="DELETE /v1/drives/files/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteFileAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/drives/files/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteFileAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/drives/files/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteFileAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteFileAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/drives/files/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteFileAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteFileAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/drives/files/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteFileByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/drives/files/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteFileByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/drives/files/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteFileByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteFileByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/drives/files/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteFileByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteFileByFQNQueryParams var2);

    @RequestLine(value="GET /v1/drives/files/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public File getFileByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/drives/files/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<File> getFileByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/drives/files/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public File getFileByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetFileByFQNQueryParams var2);

    @RequestLine(value="GET /v1/drives/files/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<File> getFileByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetFileByFQNQueryParams var2);

    @RequestLine(value="GET /v1/drives/files/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public File getFileByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/drives/files/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<File> getFileByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/drives/files/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public File getFileByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetFileByIDQueryParams var2);

    @RequestLine(value="GET /v1/drives/files/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<File> getFileByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetFileByIDQueryParams var2);

    @RequestLine(value="GET /v1/drives/files/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public File getSpecificFileVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/drives/files/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<File> getSpecificFileVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/drives/files/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllFileVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/drives/files/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllFileVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/drives/files?fields={fields}&service={service}&directory={directory}&fileType={fileType}&root={root}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public FileList listFiles(@Param(value="fields") @Nullable String var1, @Param(value="service") @Nullable String var2, @Param(value="directory") @Nullable String var3, @Param(value="fileType") @Nullable String var4, @Param(value="root") @Nullable Boolean var5, @Param(value="limit") @Nullable Integer var6, @Param(value="before") @Nullable String var7, @Param(value="after") @Nullable String var8, @Param(value="include") @Nullable String var9);

    @RequestLine(value="GET /v1/drives/files?fields={fields}&service={service}&directory={directory}&fileType={fileType}&root={root}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<FileList> listFilesWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="service") @Nullable String var2, @Param(value="directory") @Nullable String var3, @Param(value="fileType") @Nullable String var4, @Param(value="root") @Nullable Boolean var5, @Param(value="limit") @Nullable Integer var6, @Param(value="before") @Nullable String var7, @Param(value="after") @Nullable String var8, @Param(value="include") @Nullable String var9);

    @RequestLine(value="GET /v1/drives/files?fields={fields}&service={service}&directory={directory}&fileType={fileType}&root={root}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public FileList listFiles(@QueryMap(encoded=true) ListFilesQueryParams var1);

    @RequestLine(value="GET /v1/drives/files?fields={fields}&service={service}&directory={directory}&fileType={fileType}&root={root}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<FileList> listFilesWithHttpInfo(@QueryMap(encoded=true) ListFilesQueryParams var1);

    @RequestLine(value="PATCH /v1/drives/files/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchFile(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/drives/files/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchFileWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/drives/files/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchFile1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/drives/files/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchFile1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="DELETE /v1/drives/files/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent removeFollowerFromFile(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull UUID var2);

    @RequestLine(value="DELETE /v1/drives/files/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> removeFollowerFromFileWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull UUID var2);

    @RequestLine(value="PUT /v1/drives/files/{id}/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public File restoreFile(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/drives/files/{id}/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<File> restoreFileWithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/drives/files/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public File restoreFileById(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/drives/files/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<File> restoreFileByIdWithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/drives/files/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForFile(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    @RequestLine(value="PUT /v1/drives/files/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForFileWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    public static class ListFilesQueryParams
    extends HashMap<String, Object> {
        public ListFilesQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListFilesQueryParams service(@Nullable String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListFilesQueryParams directory(@Nullable String value) {
            this.put("directory", EncodingUtils.encode(value));
            return this;
        }

        public ListFilesQueryParams fileType(@Nullable String value) {
            this.put("fileType", EncodingUtils.encode(value));
            return this;
        }

        public ListFilesQueryParams root(@Nullable Boolean value) {
            this.put("root", EncodingUtils.encode(value));
            return this;
        }

        public ListFilesQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListFilesQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListFilesQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListFilesQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetFileByIDQueryParams
    extends HashMap<String, Object> {
        public GetFileByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetFileByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetFileByFQNQueryParams
    extends HashMap<String, Object> {
        public GetFileByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetFileByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteFileByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteFileByFQNQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteFileAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteFileAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteFileAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteFileQueryParams
    extends HashMap<String, Object> {
        public DeleteFileQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

