/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.AddGlossaryToAssetsRequest;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.BulkOperationResult;
import org.openmetadata.client.model.CSVExportResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateGlossary;
import org.openmetadata.client.model.CreateGlossaryTerm;
import org.openmetadata.client.model.CsvImportResult;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.Glossary;
import org.openmetadata.client.model.GlossaryList;
import org.openmetadata.client.model.GlossaryTerm;
import org.openmetadata.client.model.GlossaryTermList;
import org.openmetadata.client.model.MoveGlossaryTermRequest;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.ValidateGlossaryTagsRequest;
import org.openmetadata.client.model.VoteRequest;

public interface GlossariesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/glossaryTerms/{id}/assets/add")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public BulkOperationResult bulkAddGlossaryTermToAssets(@Param(value="id") @Nonnull UUID var1, @Nullable AddGlossaryToAssetsRequest var2);

    @RequestLine(value="PUT /v1/glossaryTerms/{id}/assets/add")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<BulkOperationResult> bulkAddGlossaryTermToAssetsWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable AddGlossaryToAssetsRequest var2);

    @RequestLine(value="PUT /v1/glossaryTerms/{id}/assets/remove")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent bulkRemoveGlossaryTermFromAssets(@Param(value="id") @Nonnull UUID var1, @Nullable AddGlossaryToAssetsRequest var2);

    @RequestLine(value="PUT /v1/glossaryTerms/{id}/assets/remove")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> bulkRemoveGlossaryTermFromAssetsWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable AddGlossaryToAssetsRequest var2);

    @RequestLine(value="POST /v1/glossaries")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Glossary createGlossary(@Nullable CreateGlossary var1);

    @RequestLine(value="POST /v1/glossaries")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Glossary> createGlossaryWithHttpInfo(@Nullable CreateGlossary var1);

    @RequestLine(value="POST /v1/glossaryTerms")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public GlossaryTerm createGlossaryTerm(@Nullable CreateGlossaryTerm var1);

    @RequestLine(value="POST /v1/glossaryTerms")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<GlossaryTerm> createGlossaryTermWithHttpInfo(@Nullable CreateGlossaryTerm var1);

    @RequestLine(value="POST /v1/glossaryTerms/createMany")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public GlossaryTerm createManyGlossaryTerm(@Nullable List<CreateGlossaryTerm> var1);

    @RequestLine(value="POST /v1/glossaryTerms/createMany")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<GlossaryTerm> createManyGlossaryTermWithHttpInfo(@Nullable List<CreateGlossaryTerm> var1);

    @RequestLine(value="PUT /v1/glossaries")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Glossary createOrUpdateGlossary(@Nullable CreateGlossary var1);

    @RequestLine(value="PUT /v1/glossaries")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Glossary> createOrUpdateGlossaryWithHttpInfo(@Nullable CreateGlossary var1);

    @RequestLine(value="PUT /v1/glossaryTerms")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public GlossaryTerm createOrUpdateGlossaryTerm(@Nullable CreateGlossaryTerm var1);

    @RequestLine(value="PUT /v1/glossaryTerms")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<GlossaryTerm> createOrUpdateGlossaryTermWithHttpInfo(@Nullable CreateGlossaryTerm var1);

    @RequestLine(value="DELETE /v1/glossaryTerms/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void delete(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/glossaryTerms/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/glossaryTerms/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void delete(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteQueryParams var2);

    @RequestLine(value="DELETE /v1/glossaryTerms/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteQueryParams var2);

    @RequestLine(value="DELETE /v1/glossaryTerms/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteByIdAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/glossaryTerms/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteByIdAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/glossaryTerms/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteByIdAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteByIdAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/glossaryTerms/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteByIdAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteByIdAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/glossaries/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteGlossary(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/glossaries/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteGlossaryWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/glossaries/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteGlossary(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteGlossaryQueryParams var2);

    @RequestLine(value="DELETE /v1/glossaries/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteGlossaryWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteGlossaryQueryParams var2);

    @RequestLine(value="DELETE /v1/glossaries/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteGlossaryAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/glossaries/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteGlossaryAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/glossaries/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteGlossaryAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteGlossaryAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/glossaries/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteGlossaryAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteGlossaryAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/glossaries/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteGlossaryByName(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/glossaries/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteGlossaryByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/glossaries/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteGlossaryByName(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteGlossaryByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/glossaries/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteGlossaryByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteGlossaryByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/glossaryTerms/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteGlossaryTermByName(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/glossaryTerms/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteGlossaryTermByNameWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/glossaryTerms/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteGlossaryTermByName(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteGlossaryTermByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/glossaryTerms/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteGlossaryTermByNameWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteGlossaryTermByNameQueryParams var2);

    @RequestLine(value="GET /v1/glossaries/name/{name}/export")
    @Headers(value={"Accept: application/json"})
    public String exportGlossary(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="GET /v1/glossaries/name/{name}/export")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<String> exportGlossaryWithHttpInfo(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="GET /v1/glossaries/name/{name}/exportAsync")
    @Headers(value={"Accept: application/json"})
    public CSVExportResponse exportGlossary1(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="GET /v1/glossaries/name/{name}/exportAsync")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<CSVExportResponse> exportGlossary1WithHttpInfo(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="GET /v1/glossaryTerms/assets/counts")
    @Headers(value={"Accept: application/json"})
    public void getAllGlossaryTermsWithAssetsCount();

    @RequestLine(value="GET /v1/glossaryTerms/assets/counts")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> getAllGlossaryTermsWithAssetsCountWithHttpInfo();

    @RequestLine(value="GET /v1/glossaries/documentation/csv")
    @Headers(value={"Accept: application/json"})
    public String getCsvDocumentation();

    @RequestLine(value="GET /v1/glossaries/documentation/csv")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<String> getCsvDocumentationWithHttpInfo();

    @RequestLine(value="GET /v1/glossaries/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Glossary getGlossaryByFQN(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/glossaries/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Glossary> getGlossaryByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/glossaries/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Glossary getGlossaryByFQN(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetGlossaryByFQNQueryParams var2);

    @RequestLine(value="GET /v1/glossaries/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Glossary> getGlossaryByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetGlossaryByFQNQueryParams var2);

    @RequestLine(value="GET /v1/glossaries/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Glossary getGlossaryByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/glossaries/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Glossary> getGlossaryByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/glossaries/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Glossary getGlossaryByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetGlossaryByIDQueryParams var2);

    @RequestLine(value="GET /v1/glossaries/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Glossary> getGlossaryByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetGlossaryByIDQueryParams var2);

    @RequestLine(value="GET /v1/glossaryTerms/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public GlossaryTerm getGlossaryTermByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/glossaryTerms/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<GlossaryTerm> getGlossaryTermByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/glossaryTerms/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public GlossaryTerm getGlossaryTermByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetGlossaryTermByFQNQueryParams var2);

    @RequestLine(value="GET /v1/glossaryTerms/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<GlossaryTerm> getGlossaryTermByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetGlossaryTermByFQNQueryParams var2);

    @RequestLine(value="GET /v1/glossaryTerms/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public GlossaryTerm getGlossaryTermByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/glossaryTerms/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<GlossaryTerm> getGlossaryTermByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/glossaryTerms/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public GlossaryTerm getGlossaryTermByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetGlossaryTermByIDQueryParams var2);

    @RequestLine(value="GET /v1/glossaryTerms/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<GlossaryTerm> getGlossaryTermByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetGlossaryTermByIDQueryParams var2);

    @RequestLine(value="GET /v1/glossaryTerms/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public GlossaryTerm getSpecificGlossaryTermVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/glossaryTerms/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<GlossaryTerm> getSpecificGlossaryTermVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/glossaries/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Glossary getSpecificGlossaryVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/glossaries/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Glossary> getSpecificGlossaryVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="PUT /v1/glossaries/name/{name}/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public CsvImportResult importGlossary(@Param(value="name") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Nullable String var3);

    @RequestLine(value="PUT /v1/glossaries/name/{name}/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importGlossaryWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Nullable String var3);

    @RequestLine(value="PUT /v1/glossaries/name/{name}/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public CsvImportResult importGlossary(@Param(value="name") @Nonnull String var1, @Nullable String var2, @QueryMap(encoded=true) ImportGlossaryQueryParams var3);

    @RequestLine(value="PUT /v1/glossaries/name/{name}/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importGlossaryWithHttpInfo(@Param(value="name") @Nonnull String var1, @Nullable String var2, @QueryMap(encoded=true) ImportGlossaryQueryParams var3);

    @RequestLine(value="PUT /v1/glossaries/name/{name}/importAsync?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public CsvImportResult importGlossaryAsync(@Param(value="name") @Nonnull String var1, @Nonnull String var2, @Param(value="dryRun") @Nullable Boolean var3);

    @RequestLine(value="PUT /v1/glossaries/name/{name}/importAsync?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importGlossaryAsyncWithHttpInfo(@Param(value="name") @Nonnull String var1, @Nonnull String var2, @Param(value="dryRun") @Nullable Boolean var3);

    @RequestLine(value="PUT /v1/glossaries/name/{name}/importAsync?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public CsvImportResult importGlossaryAsync(@Param(value="name") @Nonnull String var1, @Nonnull String var2, @QueryMap(encoded=true) ImportGlossaryAsyncQueryParams var3);

    @RequestLine(value="PUT /v1/glossaries/name/{name}/importAsync?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importGlossaryAsyncWithHttpInfo(@Param(value="name") @Nonnull String var1, @Nonnull String var2, @QueryMap(encoded=true) ImportGlossaryAsyncQueryParams var3);

    @RequestLine(value="GET /v1/glossaryTerms/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllGlossaryTermVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/glossaryTerms/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllGlossaryTermVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/glossaries/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllGlossaryVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/glossaries/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllGlossaryVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/glossaries?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public GlossaryList listGlossaries(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="before") @Nullable String var3, @Param(value="after") @Nullable String var4, @Param(value="include") @Nullable String var5);

    @RequestLine(value="GET /v1/glossaries?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<GlossaryList> listGlossariesWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="before") @Nullable String var3, @Param(value="after") @Nullable String var4, @Param(value="include") @Nullable String var5);

    @RequestLine(value="GET /v1/glossaries?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public GlossaryList listGlossaries(@QueryMap(encoded=true) ListGlossariesQueryParams var1);

    @RequestLine(value="GET /v1/glossaries?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<GlossaryList> listGlossariesWithHttpInfo(@QueryMap(encoded=true) ListGlossariesQueryParams var1);

    @RequestLine(value="GET /v1/glossaryTerms?glossary={glossary}&parent={parent}&fields={fields}&limit={limit}&before={before}&after={after}&include={include}&directChildrenOf={directChildrenOf}")
    @Headers(value={"Accept: application/json"})
    public GlossaryTermList listGlossaryTerm(@Param(value="glossary") @Nullable String var1, @Param(value="parent") @Nullable String var2, @Param(value="fields") @Nullable String var3, @Param(value="limit") @Nullable Integer var4, @Param(value="before") @Nullable String var5, @Param(value="after") @Nullable String var6, @Param(value="include") @Nullable String var7, @Param(value="directChildrenOf") @Nullable String var8);

    @RequestLine(value="GET /v1/glossaryTerms?glossary={glossary}&parent={parent}&fields={fields}&limit={limit}&before={before}&after={after}&include={include}&directChildrenOf={directChildrenOf}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<GlossaryTermList> listGlossaryTermWithHttpInfo(@Param(value="glossary") @Nullable String var1, @Param(value="parent") @Nullable String var2, @Param(value="fields") @Nullable String var3, @Param(value="limit") @Nullable Integer var4, @Param(value="before") @Nullable String var5, @Param(value="after") @Nullable String var6, @Param(value="include") @Nullable String var7, @Param(value="directChildrenOf") @Nullable String var8);

    @RequestLine(value="GET /v1/glossaryTerms?glossary={glossary}&parent={parent}&fields={fields}&limit={limit}&before={before}&after={after}&include={include}&directChildrenOf={directChildrenOf}")
    @Headers(value={"Accept: application/json"})
    public GlossaryTermList listGlossaryTerm(@QueryMap(encoded=true) ListGlossaryTermQueryParams var1);

    @RequestLine(value="GET /v1/glossaryTerms?glossary={glossary}&parent={parent}&fields={fields}&limit={limit}&before={before}&after={after}&include={include}&directChildrenOf={directChildrenOf}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<GlossaryTermList> listGlossaryTermWithHttpInfo(@QueryMap(encoded=true) ListGlossaryTermQueryParams var1);

    @RequestLine(value="GET /v1/glossaryTerms/{id}/assets?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public EntityReference listGlossaryTermAssets(@Param(value="id") @Nonnull UUID var1, @Param(value="limit") @Nullable Integer var2, @Param(value="offset") @Nullable Integer var3);

    @RequestLine(value="GET /v1/glossaryTerms/{id}/assets?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityReference> listGlossaryTermAssetsWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="limit") @Nullable Integer var2, @Param(value="offset") @Nullable Integer var3);

    @RequestLine(value="GET /v1/glossaryTerms/{id}/assets?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public EntityReference listGlossaryTermAssets(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) ListGlossaryTermAssetsQueryParams var2);

    @RequestLine(value="GET /v1/glossaryTerms/{id}/assets?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityReference> listGlossaryTermAssetsWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) ListGlossaryTermAssetsQueryParams var2);

    @RequestLine(value="GET /v1/glossaryTerms/name/{fqn}/assets?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public EntityReference listGlossaryTermAssetsByName(@Param(value="fqn") @Nonnull String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="offset") @Nullable Integer var3);

    @RequestLine(value="GET /v1/glossaryTerms/name/{fqn}/assets?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityReference> listGlossaryTermAssetsByNameWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="offset") @Nullable Integer var3);

    @RequestLine(value="GET /v1/glossaryTerms/name/{fqn}/assets?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public EntityReference listGlossaryTermAssetsByName(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) ListGlossaryTermAssetsByNameQueryParams var2);

    @RequestLine(value="GET /v1/glossaryTerms/name/{fqn}/assets?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityReference> listGlossaryTermAssetsByNameWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) ListGlossaryTermAssetsByNameQueryParams var2);

    @RequestLine(value="PUT /v1/glossaryTerms/{id}/moveAsync")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public GlossaryTerm moveGlossaryTerm(@Param(value="id") @Nonnull UUID var1, @Nonnull MoveGlossaryTermRequest var2);

    @RequestLine(value="PUT /v1/glossaryTerms/{id}/moveAsync")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<GlossaryTerm> moveGlossaryTermWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nonnull MoveGlossaryTermRequest var2);

    @RequestLine(value="PATCH /v1/glossaries/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchGlossary(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/glossaries/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchGlossaryWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/glossaries/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchGlossary1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/glossaries/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchGlossary1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/glossaryTerms/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchGlossaryTerm(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/glossaryTerms/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchGlossaryTermWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/glossaryTerms/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchGlossaryTerm1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/glossaryTerms/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchGlossaryTerm1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/glossaries/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Glossary restore17(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/glossaries/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Glossary> restore17WithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/glossaryTerms/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public GlossaryTerm restore18(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/glossaryTerms/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<GlossaryTerm> restore18WithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="GET /v1/glossaryTerms/search?q={q}&glossary={glossary}&glossaryFqn={glossaryFqn}&parent={parent}&parentFqn={parentFqn}&limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public GlossaryTermList searchGlossaryTerms(@Param(value="q") @Nullable String var1, @Param(value="glossary") @Nullable UUID var2, @Param(value="glossaryFqn") @Nullable String var3, @Param(value="parent") @Nullable UUID var4, @Param(value="parentFqn") @Nullable String var5, @Param(value="limit") @Nullable Integer var6, @Param(value="offset") @Nullable Integer var7, @Param(value="fields") @Nullable String var8, @Param(value="include") @Nullable String var9);

    @RequestLine(value="GET /v1/glossaryTerms/search?q={q}&glossary={glossary}&glossaryFqn={glossaryFqn}&parent={parent}&parentFqn={parentFqn}&limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<GlossaryTermList> searchGlossaryTermsWithHttpInfo(@Param(value="q") @Nullable String var1, @Param(value="glossary") @Nullable UUID var2, @Param(value="glossaryFqn") @Nullable String var3, @Param(value="parent") @Nullable UUID var4, @Param(value="parentFqn") @Nullable String var5, @Param(value="limit") @Nullable Integer var6, @Param(value="offset") @Nullable Integer var7, @Param(value="fields") @Nullable String var8, @Param(value="include") @Nullable String var9);

    @RequestLine(value="GET /v1/glossaryTerms/search?q={q}&glossary={glossary}&glossaryFqn={glossaryFqn}&parent={parent}&parentFqn={parentFqn}&limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public GlossaryTermList searchGlossaryTerms(@QueryMap(encoded=true) SearchGlossaryTermsQueryParams var1);

    @RequestLine(value="GET /v1/glossaryTerms/search?q={q}&glossary={glossary}&glossaryFqn={glossaryFqn}&parent={parent}&parentFqn={parentFqn}&limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<GlossaryTermList> searchGlossaryTermsWithHttpInfo(@QueryMap(encoded=true) SearchGlossaryTermsQueryParams var1);

    @RequestLine(value="PUT /v1/glossaries/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForEntity7(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    @RequestLine(value="PUT /v1/glossaries/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForEntity7WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    @RequestLine(value="PUT /v1/glossaryTerms/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForEntity8(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    @RequestLine(value="PUT /v1/glossaryTerms/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForEntity8WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    @RequestLine(value="PUT /v1/glossaryTerms/{id}/tags/validate")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public BulkOperationResult validateGlossaryTermTagsAddition(@Param(value="id") @Nonnull UUID var1, @Nullable ValidateGlossaryTagsRequest var2);

    @RequestLine(value="PUT /v1/glossaryTerms/{id}/tags/validate")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<BulkOperationResult> validateGlossaryTermTagsAdditionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable ValidateGlossaryTagsRequest var2);

    public static class SearchGlossaryTermsQueryParams
    extends HashMap<String, Object> {
        public SearchGlossaryTermsQueryParams q(@Nullable String value) {
            this.put("q", EncodingUtils.encode(value));
            return this;
        }

        public SearchGlossaryTermsQueryParams glossary(@Nullable UUID value) {
            this.put("glossary", EncodingUtils.encode(value));
            return this;
        }

        public SearchGlossaryTermsQueryParams glossaryFqn(@Nullable String value) {
            this.put("glossaryFqn", EncodingUtils.encode(value));
            return this;
        }

        public SearchGlossaryTermsQueryParams parent(@Nullable UUID value) {
            this.put("parent", EncodingUtils.encode(value));
            return this;
        }

        public SearchGlossaryTermsQueryParams parentFqn(@Nullable String value) {
            this.put("parentFqn", EncodingUtils.encode(value));
            return this;
        }

        public SearchGlossaryTermsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public SearchGlossaryTermsQueryParams offset(@Nullable Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public SearchGlossaryTermsQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public SearchGlossaryTermsQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListGlossaryTermAssetsByNameQueryParams
    extends HashMap<String, Object> {
        public ListGlossaryTermAssetsByNameQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListGlossaryTermAssetsByNameQueryParams offset(@Nullable Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListGlossaryTermAssetsQueryParams
    extends HashMap<String, Object> {
        public ListGlossaryTermAssetsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListGlossaryTermAssetsQueryParams offset(@Nullable Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListGlossaryTermQueryParams
    extends HashMap<String, Object> {
        public ListGlossaryTermQueryParams glossary(@Nullable String value) {
            this.put("glossary", EncodingUtils.encode(value));
            return this;
        }

        public ListGlossaryTermQueryParams parent(@Nullable String value) {
            this.put("parent", EncodingUtils.encode(value));
            return this;
        }

        public ListGlossaryTermQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListGlossaryTermQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListGlossaryTermQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListGlossaryTermQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListGlossaryTermQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }

        public ListGlossaryTermQueryParams directChildrenOf(@Nullable String value) {
            this.put("directChildrenOf", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListGlossariesQueryParams
    extends HashMap<String, Object> {
        public ListGlossariesQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListGlossariesQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListGlossariesQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListGlossariesQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListGlossariesQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ImportGlossaryAsyncQueryParams
    extends HashMap<String, Object> {
        public ImportGlossaryAsyncQueryParams dryRun(@Nullable Boolean value) {
            this.put("dryRun", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ImportGlossaryQueryParams
    extends HashMap<String, Object> {
        public ImportGlossaryQueryParams dryRun(@Nullable Boolean value) {
            this.put("dryRun", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetGlossaryTermByIDQueryParams
    extends HashMap<String, Object> {
        public GetGlossaryTermByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetGlossaryTermByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetGlossaryTermByFQNQueryParams
    extends HashMap<String, Object> {
        public GetGlossaryTermByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetGlossaryTermByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetGlossaryByIDQueryParams
    extends HashMap<String, Object> {
        public GetGlossaryByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetGlossaryByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetGlossaryByFQNQueryParams
    extends HashMap<String, Object> {
        public GetGlossaryByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetGlossaryByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteGlossaryTermByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteGlossaryTermByNameQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteGlossaryTermByNameQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteGlossaryByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteGlossaryByNameQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteGlossaryByNameQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteGlossaryAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteGlossaryAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteGlossaryAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteGlossaryQueryParams
    extends HashMap<String, Object> {
        public DeleteGlossaryQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteGlossaryQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteByIdAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteByIdAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteByIdAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteQueryParams
    extends HashMap<String, Object> {
        public DeleteQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

