/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateIngestionPipeline;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.IngestionPipeline;
import org.openmetadata.client.model.PipelineServiceClientResponse;
import org.openmetadata.client.model.PipelineStatus;
import org.openmetadata.client.model.RestoreEntity;

public interface IngestionPipelinesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/services/ingestionPipelines/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollowerToIngestionPipeline(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/services/ingestionPipelines/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerToIngestionPipelineWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/services/ingestionPipelines/{fqn}/pipelineStatus")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public IngestionPipeline addPipelineStatus(@Param(value="fqn") @Nonnull String var1, @Nullable PipelineStatus var2);

    @RequestLine(value="PUT /v1/services/ingestionPipelines/{fqn}/pipelineStatus")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<IngestionPipeline> addPipelineStatusWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable PipelineStatus var2);

    @RequestLine(value="POST /v1/services/ingestionPipelines/bulk/deploy")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public PipelineServiceClientResponse bulkDeployIngestion(@Nullable List<UUID> var1);

    @RequestLine(value="POST /v1/services/ingestionPipelines/bulk/deploy")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<PipelineServiceClientResponse> bulkDeployIngestionWithHttpInfo(@Nullable List<UUID> var1);

    @RequestLine(value="GET /v1/services/ingestionPipelines/ip")
    @Headers(value={"Accept: application/json"})
    public void checkAirflowHostIp();

    @RequestLine(value="GET /v1/services/ingestionPipelines/ip")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> checkAirflowHostIpWithHttpInfo();

    @RequestLine(value="GET /v1/services/ingestionPipelines/status")
    @Headers(value={"Accept: application/json"})
    public void checkRestAirflowStatus();

    @RequestLine(value="GET /v1/services/ingestionPipelines/status")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> checkRestAirflowStatusWithHttpInfo();

    @RequestLine(value="POST /v1/services/ingestionPipelines/logs/{fqn}/{runId}/close")
    @Headers(value={"Accept: application/json"})
    public void closePipelineLogStream(@Param(value="fqn") @Nonnull String var1, @Param(value="runId") @Nonnull String var2);

    @RequestLine(value="POST /v1/services/ingestionPipelines/logs/{fqn}/{runId}/close")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> closePipelineLogStreamWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="runId") @Nonnull String var2);

    @RequestLine(value="POST /v1/services/ingestionPipelines")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public IngestionPipeline createIngestionPipeline(@Nullable CreateIngestionPipeline var1);

    @RequestLine(value="POST /v1/services/ingestionPipelines")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<IngestionPipeline> createIngestionPipelineWithHttpInfo(@Nullable CreateIngestionPipeline var1);

    @RequestLine(value="PUT /v1/services/ingestionPipelines")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public IngestionPipeline createOrUpdateIngestionPipeline(@Nullable CreateIngestionPipeline var1);

    @RequestLine(value="PUT /v1/services/ingestionPipelines")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<IngestionPipeline> createOrUpdateIngestionPipelineWithHttpInfo(@Nullable CreateIngestionPipeline var1);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower13(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower13WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteIngestionPipeline(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteIngestionPipelineWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteIngestionPipeline(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteIngestionPipelineQueryParams var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteIngestionPipelineWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteIngestionPipelineQueryParams var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteIngestionPipelineAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteIngestionPipelineAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteIngestionPipelineAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteIngestionPipelineAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteIngestionPipelineAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteIngestionPipelineAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteIngestionPipelineByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteIngestionPipelineByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteIngestionPipelineByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteIngestionPipelineByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteIngestionPipelineByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteIngestionPipelineByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/{id}/pipelineStatus")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline deletePipelineStatus(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/{id}/pipelineStatus")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<IngestionPipeline> deletePipelineStatusWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/{id}/pipelineStatus/{runId}")
    @Headers(value={"Accept: application/json"})
    public void deletePipelineStatusByRunId(@Param(value="id") @Nonnull UUID var1, @Param(value="runId") @Nonnull UUID var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/{id}/pipelineStatus/{runId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePipelineStatusByRunIdWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="runId") @Nonnull UUID var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/{id}/pipelineStatus")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline deletePipelineStatus_1(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/{id}/pipelineStatus")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<IngestionPipeline> deletePipelineStatus_1WithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="POST /v1/services/ingestionPipelines/deploy/{id}")
    @Headers(value={"Accept: application/json"})
    public PipelineServiceClientResponse deployIngestion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="POST /v1/services/ingestionPipelines/deploy/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PipelineServiceClientResponse> deployIngestionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/services/ingestionPipelines/logs/{id}/last/download")
    @Headers(value={"Accept: application/octet-stream"})
    public void downloadLastIngestionLogs(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/services/ingestionPipelines/logs/{id}/last/download")
    @Headers(value={"Accept: application/octet-stream"})
    public ApiResponse<Void> downloadLastIngestionLogsWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline getIngestionPipelineByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<IngestionPipeline> getIngestionPipelineByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline getIngestionPipelineByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetIngestionPipelineByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<IngestionPipeline> getIngestionPipelineByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetIngestionPipelineByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/logs/{id}/last?after={after}&limit={limit}")
    @Headers(value={"Accept: application/json"})
    public void getLastIngestionLogs(@Param(value="id") @Nonnull UUID var1, @Param(value="after") @Nullable String var2, @Param(value="limit") @Nullable Long var3);

    @RequestLine(value="GET /v1/services/ingestionPipelines/logs/{id}/last?after={after}&limit={limit}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> getLastIngestionLogsWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="after") @Nullable String var2, @Param(value="limit") @Nullable Long var3);

    @RequestLine(value="GET /v1/services/ingestionPipelines/logs/{id}/last?after={after}&limit={limit}")
    @Headers(value={"Accept: application/json"})
    public void getLastIngestionLogs(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetLastIngestionLogsQueryParams var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/logs/{id}/last?after={after}&limit={limit}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> getLastIngestionLogsWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetLastIngestionLogsQueryParams var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/logs/{fqn}/{runId}?after={after}&limit={limit}")
    @Headers(value={"Accept: application/json"})
    public void getPipelineLogs(@Param(value="fqn") @Nonnull String var1, @Param(value="runId") @Nonnull String var2, @Param(value="after") @Nullable String var3, @Param(value="limit") @Nullable Long var4);

    @RequestLine(value="GET /v1/services/ingestionPipelines/logs/{fqn}/{runId}?after={after}&limit={limit}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> getPipelineLogsWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="runId") @Nonnull String var2, @Param(value="after") @Nullable String var3, @Param(value="limit") @Nullable Long var4);

    @RequestLine(value="GET /v1/services/ingestionPipelines/logs/{fqn}/{runId}?after={after}&limit={limit}")
    @Headers(value={"Accept: application/json"})
    public void getPipelineLogs(@Param(value="fqn") @Nonnull String var1, @Param(value="runId") @Nonnull String var2, @QueryMap(encoded=true) GetPipelineLogsQueryParams var3);

    @RequestLine(value="GET /v1/services/ingestionPipelines/logs/{fqn}/{runId}?after={after}&limit={limit}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> getPipelineLogsWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="runId") @Nonnull String var2, @QueryMap(encoded=true) GetPipelineLogsQueryParams var3);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{fqn}/pipelineStatus/{id}")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline getPipelineStatus(@Param(value="fqn") @Nonnull String var1, @Param(value="id") @Nonnull String var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{fqn}/pipelineStatus/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<IngestionPipeline> getPipelineStatusWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="id") @Nonnull String var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline getSpecificIngestionPipelineByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/ingestionPipelines/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<IngestionPipeline> getSpecificIngestionPipelineByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/ingestionPipelines/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline getSpecificIngestionPipelineByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetSpecificIngestionPipelineByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<IngestionPipeline> getSpecificIngestionPipelineByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetSpecificIngestionPipelineByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline getSpecificIngestionPipelineVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<IngestionPipeline> getSpecificIngestionPipelineVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="POST /v1/services/ingestionPipelines/kill/{id}")
    @Headers(value={"Accept: application/json"})
    public PipelineServiceClientResponse killIngestionPipelineRuns(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="POST /v1/services/ingestionPipelines/kill/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PipelineServiceClientResponse> killIngestionPipelineRunsWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllIngestionPipelineVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllIngestionPipelineVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/services/ingestionPipelines?fields={fields}&service={service}&testSuite={testSuite}&pipelineType={pipelineType}&serviceType={serviceType}&applicationType={applicationType}&limit={limit}&before={before}&after={after}&include={include}&provider={provider}")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline listIngestionPipelines(@Param(value="fields") @Nullable String var1, @Param(value="service") @Nullable String var2, @Param(value="testSuite") @Nullable String var3, @Param(value="pipelineType") @Nullable String var4, @Param(value="serviceType") @Nullable String var5, @Param(value="applicationType") @Nullable String var6, @Param(value="limit") @Nullable Integer var7, @Param(value="before") @Nullable String var8, @Param(value="after") @Nullable String var9, @Param(value="include") @Nullable String var10, @Param(value="provider") @Nullable String var11);

    @RequestLine(value="GET /v1/services/ingestionPipelines?fields={fields}&service={service}&testSuite={testSuite}&pipelineType={pipelineType}&serviceType={serviceType}&applicationType={applicationType}&limit={limit}&before={before}&after={after}&include={include}&provider={provider}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<IngestionPipeline> listIngestionPipelinesWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="service") @Nullable String var2, @Param(value="testSuite") @Nullable String var3, @Param(value="pipelineType") @Nullable String var4, @Param(value="serviceType") @Nullable String var5, @Param(value="applicationType") @Nullable String var6, @Param(value="limit") @Nullable Integer var7, @Param(value="before") @Nullable String var8, @Param(value="after") @Nullable String var9, @Param(value="include") @Nullable String var10, @Param(value="provider") @Nullable String var11);

    @RequestLine(value="GET /v1/services/ingestionPipelines?fields={fields}&service={service}&testSuite={testSuite}&pipelineType={pipelineType}&serviceType={serviceType}&applicationType={applicationType}&limit={limit}&before={before}&after={after}&include={include}&provider={provider}")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline listIngestionPipelines(@QueryMap(encoded=true) ListIngestionPipelinesQueryParams var1);

    @RequestLine(value="GET /v1/services/ingestionPipelines?fields={fields}&service={service}&testSuite={testSuite}&pipelineType={pipelineType}&serviceType={serviceType}&applicationType={applicationType}&limit={limit}&before={before}&after={after}&include={include}&provider={provider}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<IngestionPipeline> listIngestionPipelinesWithHttpInfo(@QueryMap(encoded=true) ListIngestionPipelinesQueryParams var1);

    @RequestLine(value="GET /v1/services/ingestionPipelines/logs/{fqn}?limit={limit}")
    @Headers(value={"Accept: application/json"})
    public void listPipelineRuns(@Param(value="fqn") @Nonnull String var1, @Param(value="limit") @Nullable Long var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/logs/{fqn}?limit={limit}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> listPipelineRunsWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="limit") @Nullable Long var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/logs/{fqn}?limit={limit}")
    @Headers(value={"Accept: application/json"})
    public void listPipelineRuns(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) ListPipelineRunsQueryParams var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/logs/{fqn}?limit={limit}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> listPipelineRunsWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) ListPipelineRunsQueryParams var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{fqn}/pipelineStatus?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline listPipelineStatuses1(@Param(value="fqn") @Nonnull String var1, @Param(value="startTs") @Nullable BigDecimal var2, @Param(value="endTs") @Nullable BigDecimal var3);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{fqn}/pipelineStatus?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<IngestionPipeline> listPipelineStatuses1WithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="startTs") @Nullable BigDecimal var2, @Param(value="endTs") @Nullable BigDecimal var3);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{fqn}/pipelineStatus?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline listPipelineStatuses1(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) ListPipelineStatuses1QueryParams var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{fqn}/pipelineStatus?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<IngestionPipeline> listPipelineStatuses1WithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) ListPipelineStatuses1QueryParams var2);

    @RequestLine(value="PATCH /v1/services/ingestionPipelines/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchIngestionPipeline(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/ingestionPipelines/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchIngestionPipelineWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/ingestionPipelines/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchIngestionPipeline1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/ingestionPipelines/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchIngestionPipeline1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/services/ingestionPipelines/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public IngestionPipeline restore30(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/services/ingestionPipelines/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<IngestionPipeline> restore30WithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="GET /v1/services/ingestionPipelines/logs/{fqn}/stream/{runId}")
    @Headers(value={"Accept: text/event-stream"})
    public void streamPipelineLogs(@Param(value="fqn") @Nonnull String var1, @Param(value="runId") @Nonnull String var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/logs/{fqn}/stream/{runId}")
    @Headers(value={"Accept: text/event-stream"})
    public ApiResponse<Void> streamPipelineLogsWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="runId") @Nonnull String var2);

    @RequestLine(value="POST /v1/services/ingestionPipelines/toggleIngestion/{id}")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline toggleIngestionPipelineEnabled(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="POST /v1/services/ingestionPipelines/toggleIngestion/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<IngestionPipeline> toggleIngestionPipelineEnabledWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="POST /v1/services/ingestionPipelines/trigger/{id}")
    @Headers(value={"Accept: application/json"})
    public PipelineServiceClientResponse triggerIngestionPipelineRun(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="POST /v1/services/ingestionPipelines/trigger/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PipelineServiceClientResponse> triggerIngestionPipelineRunWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="POST /v1/services/ingestionPipelines/logs/{fqn}/{runId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void writePipelineLogs(@Param(value="fqn") @Nonnull String var1, @Param(value="runId") @Nonnull String var2, @Nullable Object var3);

    @RequestLine(value="POST /v1/services/ingestionPipelines/logs/{fqn}/{runId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> writePipelineLogsWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="runId") @Nonnull String var2, @Nullable Object var3);

    public static class ListPipelineStatuses1QueryParams
    extends HashMap<String, Object> {
        public ListPipelineStatuses1QueryParams startTs(@Nullable BigDecimal value) {
            this.put("startTs", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelineStatuses1QueryParams endTs(@Nullable BigDecimal value) {
            this.put("endTs", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListPipelineRunsQueryParams
    extends HashMap<String, Object> {
        public ListPipelineRunsQueryParams limit(@Nullable Long value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListIngestionPipelinesQueryParams
    extends HashMap<String, Object> {
        public ListIngestionPipelinesQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListIngestionPipelinesQueryParams service(@Nullable String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListIngestionPipelinesQueryParams testSuite(@Nullable String value) {
            this.put("testSuite", EncodingUtils.encode(value));
            return this;
        }

        public ListIngestionPipelinesQueryParams pipelineType(@Nullable String value) {
            this.put("pipelineType", EncodingUtils.encode(value));
            return this;
        }

        public ListIngestionPipelinesQueryParams serviceType(@Nullable String value) {
            this.put("serviceType", EncodingUtils.encode(value));
            return this;
        }

        public ListIngestionPipelinesQueryParams applicationType(@Nullable String value) {
            this.put("applicationType", EncodingUtils.encode(value));
            return this;
        }

        public ListIngestionPipelinesQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListIngestionPipelinesQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListIngestionPipelinesQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListIngestionPipelinesQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }

        public ListIngestionPipelinesQueryParams provider(@Nullable String value) {
            this.put("provider", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetSpecificIngestionPipelineByFQNQueryParams
    extends HashMap<String, Object> {
        public GetSpecificIngestionPipelineByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetSpecificIngestionPipelineByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetPipelineLogsQueryParams
    extends HashMap<String, Object> {
        public GetPipelineLogsQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public GetPipelineLogsQueryParams limit(@Nullable Long value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetLastIngestionLogsQueryParams
    extends HashMap<String, Object> {
        public GetLastIngestionLogsQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public GetLastIngestionLogsQueryParams limit(@Nullable Long value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetIngestionPipelineByIDQueryParams
    extends HashMap<String, Object> {
        public GetIngestionPipelineByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetIngestionPipelineByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteIngestionPipelineByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteIngestionPipelineByFQNQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteIngestionPipelineAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteIngestionPipelineAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteIngestionPipelineQueryParams
    extends HashMap<String, Object> {
        public DeleteIngestionPipelineQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

