/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateMessagingService;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.MessagingService;
import org.openmetadata.client.model.MessagingServiceList;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.TestConnectionResult;

public interface MessagingServicesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/services/messagingServices/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollowerToDatabaseService1(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/services/messagingServices/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerToDatabaseService1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/services/messagingServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public MessagingService addTestConnectionResult4(@Param(value="id") @Nonnull UUID var1, @Nullable TestConnectionResult var2);

    @RequestLine(value="PUT /v1/services/messagingServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<MessagingService> addTestConnectionResult4WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable TestConnectionResult var2);

    @RequestLine(value="POST /v1/services/messagingServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public MessagingService createMessagingService(@Nullable CreateMessagingService var1);

    @RequestLine(value="POST /v1/services/messagingServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<MessagingService> createMessagingServiceWithHttpInfo(@Nullable CreateMessagingService var1);

    @RequestLine(value="PUT /v1/services/messagingServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public MessagingService createOrUpdateMessagingService(@Nullable CreateMessagingService var1);

    @RequestLine(value="PUT /v1/services/messagingServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<MessagingService> createOrUpdateMessagingServiceWithHttpInfo(@Nullable CreateMessagingService var1);

    @RequestLine(value="DELETE /v1/services/messagingServices/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower14(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/services/messagingServices/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower14WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/services/messagingServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMessagingService(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/messagingServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMessagingServiceWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/messagingServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMessagingService(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteMessagingServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/messagingServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMessagingServiceWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteMessagingServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/messagingServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMessagingServiceAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/messagingServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMessagingServiceAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/messagingServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMessagingServiceAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteMessagingServiceAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/services/messagingServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMessagingServiceAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteMessagingServiceAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/services/messagingServices/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteMessagingServiceByName(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/messagingServices/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMessagingServiceByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/messagingServices/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteMessagingServiceByName(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteMessagingServiceByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/services/messagingServices/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMessagingServiceByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteMessagingServiceByNameQueryParams var2);

    @RequestLine(value="GET /v1/services/messagingServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MessagingService getMessagingServiceByFQN(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/messagingServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MessagingService> getMessagingServiceByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/messagingServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MessagingService getMessagingServiceByFQN(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetMessagingServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/messagingServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MessagingService> getMessagingServiceByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetMessagingServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/messagingServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MessagingService getMessagingServiceByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/messagingServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MessagingService> getMessagingServiceByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/messagingServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MessagingService getMessagingServiceByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetMessagingServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/messagingServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MessagingService> getMessagingServiceByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetMessagingServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/messagingServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public MessagingService getSpecificMessagingServiceVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/services/messagingServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MessagingService> getSpecificMessagingServiceVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/services/messagingServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllMessagingServiceVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/services/messagingServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllMessagingServiceVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/services/messagingServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MessagingServiceList listMessagingService(@Param(value="fields") @Nullable String var1, @Param(value="domain") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/services/messagingServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MessagingServiceList> listMessagingServiceWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="domain") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/services/messagingServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MessagingServiceList listMessagingService(@QueryMap(encoded=true) ListMessagingServiceQueryParams var1);

    @RequestLine(value="GET /v1/services/messagingServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MessagingServiceList> listMessagingServiceWithHttpInfo(@QueryMap(encoded=true) ListMessagingServiceQueryParams var1);

    @RequestLine(value="PATCH /v1/services/messagingServices/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchMessagingService(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/messagingServices/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchMessagingServiceWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/messagingServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchMessagingService1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/messagingServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchMessagingService1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/services/messagingServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public MessagingService restore31(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/services/messagingServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<MessagingService> restore31WithHttpInfo(@Nullable RestoreEntity var1);

    public static class ListMessagingServiceQueryParams
    extends HashMap<String, Object> {
        public ListMessagingServiceQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListMessagingServiceQueryParams domain(@Nullable String value) {
            this.put("domain", EncodingUtils.encode(value));
            return this;
        }

        public ListMessagingServiceQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListMessagingServiceQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListMessagingServiceQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListMessagingServiceQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetMessagingServiceByIDQueryParams
    extends HashMap<String, Object> {
        public GetMessagingServiceByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetMessagingServiceByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetMessagingServiceByFQNQueryParams
    extends HashMap<String, Object> {
        public GetMessagingServiceByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetMessagingServiceByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteMessagingServiceByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteMessagingServiceByNameQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteMessagingServiceByNameQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteMessagingServiceAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteMessagingServiceAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteMessagingServiceAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteMessagingServiceQueryParams
    extends HashMap<String, Object> {
        public DeleteMessagingServiceQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteMessagingServiceQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

