/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateMlModel;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.MlModel;
import org.openmetadata.client.model.MlModelList;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.VoteRequest;

public interface MlModelsApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/mlmodels/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollower3(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="PUT /v1/mlmodels/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollower3WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="POST /v1/mlmodels")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public MlModel createMlModel(@Nullable CreateMlModel var1);

    @RequestLine(value="POST /v1/mlmodels")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<MlModel> createMlModelWithHttpInfo(@Nullable CreateMlModel var1);

    @RequestLine(value="PUT /v1/mlmodels")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public MlModel createOrUpdateMlModel(@Nullable CreateMlModel var1);

    @RequestLine(value="PUT /v1/mlmodels")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<MlModel> createOrUpdateMlModelWithHttpInfo(@Nullable CreateMlModel var1);

    @RequestLine(value="DELETE /v1/mlmodels/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower6(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull UUID var2);

    @RequestLine(value="DELETE /v1/mlmodels/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower6WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull UUID var2);

    @RequestLine(value="DELETE /v1/mlmodels/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMlModel(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/mlmodels/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMlModelWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/mlmodels/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMlModel(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteMlModelQueryParams var2);

    @RequestLine(value="DELETE /v1/mlmodels/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMlModelWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteMlModelQueryParams var2);

    @RequestLine(value="DELETE /v1/mlmodels/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMlModelAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/mlmodels/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMlModelAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/mlmodels/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMlModelAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteMlModelAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/mlmodels/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMlModelAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteMlModelAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/mlmodels/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteMlModelByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/mlmodels/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMlModelByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/mlmodels/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteMlModelByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteMlModelByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/mlmodels/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMlModelByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteMlModelByFQNQueryParams var2);

    @RequestLine(value="GET /v1/mlmodels/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MlModel getMlModelByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/mlmodels/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MlModel> getMlModelByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/mlmodels/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MlModel getMlModelByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetMlModelByFQNQueryParams var2);

    @RequestLine(value="GET /v1/mlmodels/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MlModel> getMlModelByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetMlModelByFQNQueryParams var2);

    @RequestLine(value="GET /v1/mlmodels/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MlModel getMlModelByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/mlmodels/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MlModel> getMlModelByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/mlmodels/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MlModel getMlModelByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetMlModelByIDQueryParams var2);

    @RequestLine(value="GET /v1/mlmodels/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MlModel> getMlModelByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetMlModelByIDQueryParams var2);

    @RequestLine(value="GET /v1/mlmodels/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public MlModel getSpecificMlModelVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/mlmodels/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MlModel> getSpecificMlModelVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/mlmodels/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllMlModelVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/mlmodels/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllMlModelVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/mlmodels?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MlModelList listMlModels(@Param(value="fields") @Nullable String var1, @Param(value="service") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/mlmodels?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MlModelList> listMlModelsWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="service") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/mlmodels?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MlModelList listMlModels(@QueryMap(encoded=true) ListMlModelsQueryParams var1);

    @RequestLine(value="GET /v1/mlmodels?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MlModelList> listMlModelsWithHttpInfo(@QueryMap(encoded=true) ListMlModelsQueryParams var1);

    @RequestLine(value="PATCH /v1/mlmodels/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchMlModel(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/mlmodels/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchMlModelWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/mlmodels/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchMlModel1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/mlmodels/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchMlModel1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/mlmodels/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public MlModel restore21(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/mlmodels/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<MlModel> restore21WithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/mlmodels/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForEntity9(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    @RequestLine(value="PUT /v1/mlmodels/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForEntity9WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    public static class ListMlModelsQueryParams
    extends HashMap<String, Object> {
        public ListMlModelsQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListMlModelsQueryParams service(@Nullable String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListMlModelsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListMlModelsQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListMlModelsQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListMlModelsQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetMlModelByIDQueryParams
    extends HashMap<String, Object> {
        public GetMlModelByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetMlModelByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetMlModelByFQNQueryParams
    extends HashMap<String, Object> {
        public GetMlModelByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetMlModelByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteMlModelByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteMlModelByFQNQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteMlModelByFQNQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteMlModelAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteMlModelAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteMlModelQueryParams
    extends HashMap<String, Object> {
        public DeleteMlModelQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

