/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CreateNotificationTemplate;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.NotificationTemplate;
import org.openmetadata.client.model.NotificationTemplateList;
import org.openmetadata.client.model.NotificationTemplateValidationRequest;
import org.openmetadata.client.model.NotificationTemplateValidationResponse;
import org.openmetadata.client.model.RestoreEntity;

public interface NotificationTemplatesApi
extends ApiClient.Api {
    @RequestLine(value="POST /v1/notificationTemplates")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public NotificationTemplate createNotificationTemplate(@Nullable CreateNotificationTemplate var1);

    @RequestLine(value="POST /v1/notificationTemplates")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<NotificationTemplate> createNotificationTemplateWithHttpInfo(@Nullable CreateNotificationTemplate var1);

    @RequestLine(value="PUT /v1/notificationTemplates")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public NotificationTemplate createOrUpdateNotificationTemplate(@Nullable CreateNotificationTemplate var1);

    @RequestLine(value="PUT /v1/notificationTemplates")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<NotificationTemplate> createOrUpdateNotificationTemplateWithHttpInfo(@Nullable CreateNotificationTemplate var1);

    @RequestLine(value="DELETE /v1/notificationTemplates/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteNotificationTemplate(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/notificationTemplates/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteNotificationTemplateWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/notificationTemplates/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteNotificationTemplate(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteNotificationTemplateQueryParams var2);

    @RequestLine(value="DELETE /v1/notificationTemplates/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteNotificationTemplateWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteNotificationTemplateQueryParams var2);

    @RequestLine(value="DELETE /v1/notificationTemplates/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteNotificationTemplateAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/notificationTemplates/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteNotificationTemplateAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/notificationTemplates/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteNotificationTemplateAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteNotificationTemplateAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/notificationTemplates/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteNotificationTemplateAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteNotificationTemplateAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/notificationTemplates/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteNotificationTemplateByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/notificationTemplates/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteNotificationTemplateByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/notificationTemplates/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteNotificationTemplateByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteNotificationTemplateByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/notificationTemplates/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteNotificationTemplateByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteNotificationTemplateByFQNQueryParams var2);

    @RequestLine(value="GET /v1/notificationTemplates/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public NotificationTemplate getNotificationTemplateByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/notificationTemplates/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<NotificationTemplate> getNotificationTemplateByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/notificationTemplates/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public NotificationTemplate getNotificationTemplateByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetNotificationTemplateByFQNQueryParams var2);

    @RequestLine(value="GET /v1/notificationTemplates/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<NotificationTemplate> getNotificationTemplateByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetNotificationTemplateByFQNQueryParams var2);

    @RequestLine(value="GET /v1/notificationTemplates/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public NotificationTemplate getNotificationTemplateById(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/notificationTemplates/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<NotificationTemplate> getNotificationTemplateByIdWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/notificationTemplates/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public NotificationTemplate getNotificationTemplateById(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetNotificationTemplateByIdQueryParams var2);

    @RequestLine(value="GET /v1/notificationTemplates/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<NotificationTemplate> getNotificationTemplateByIdWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetNotificationTemplateByIdQueryParams var2);

    @RequestLine(value="GET /v1/notificationTemplates/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public NotificationTemplate getSpecificNotificationTemplateVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/notificationTemplates/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<NotificationTemplate> getSpecificNotificationTemplateVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/notificationTemplates/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllNotificationTemplateVersions(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/notificationTemplates/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllNotificationTemplateVersionsWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/notificationTemplates?fields={fields}&provider={provider}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public NotificationTemplateList listNotificationTemplates(@Param(value="fields") @Nullable String var1, @Param(value="provider") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/notificationTemplates?fields={fields}&provider={provider}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<NotificationTemplateList> listNotificationTemplatesWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="provider") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/notificationTemplates?fields={fields}&provider={provider}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public NotificationTemplateList listNotificationTemplates(@QueryMap(encoded=true) ListNotificationTemplatesQueryParams var1);

    @RequestLine(value="GET /v1/notificationTemplates?fields={fields}&provider={provider}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<NotificationTemplateList> listNotificationTemplatesWithHttpInfo(@QueryMap(encoded=true) ListNotificationTemplatesQueryParams var1);

    @RequestLine(value="PATCH /v1/notificationTemplates/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public NotificationTemplate patchNotificationTemplate(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/notificationTemplates/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<NotificationTemplate> patchNotificationTemplateWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/notificationTemplates/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public NotificationTemplate patchNotificationTemplateByFQN(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/notificationTemplates/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<NotificationTemplate> patchNotificationTemplateByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/notificationTemplates/name/{fqn}/reset")
    @Headers(value={"Accept: application/json"})
    public void resetNotificationTemplateByFQN(@Param(value="fqn") @Nonnull String var1);

    @RequestLine(value="PUT /v1/notificationTemplates/name/{fqn}/reset")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> resetNotificationTemplateByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1);

    @RequestLine(value="PUT /v1/notificationTemplates/{id}/reset")
    @Headers(value={"Accept: application/json"})
    public void resetNotificationTemplateById(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="PUT /v1/notificationTemplates/{id}/reset")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> resetNotificationTemplateByIdWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="PUT /v1/notificationTemplates/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void restore16(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/notificationTemplates/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> restore16WithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="POST /v1/notificationTemplates/validate")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public NotificationTemplateValidationResponse validateNotificationTemplate(@Nullable NotificationTemplateValidationRequest var1);

    @RequestLine(value="POST /v1/notificationTemplates/validate")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<NotificationTemplateValidationResponse> validateNotificationTemplateWithHttpInfo(@Nullable NotificationTemplateValidationRequest var1);

    public static class ListNotificationTemplatesQueryParams
    extends HashMap<String, Object> {
        public ListNotificationTemplatesQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListNotificationTemplatesQueryParams provider(@Nullable String value) {
            this.put("provider", EncodingUtils.encode(value));
            return this;
        }

        public ListNotificationTemplatesQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListNotificationTemplatesQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListNotificationTemplatesQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListNotificationTemplatesQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetNotificationTemplateByIdQueryParams
    extends HashMap<String, Object> {
        public GetNotificationTemplateByIdQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetNotificationTemplateByIdQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetNotificationTemplateByFQNQueryParams
    extends HashMap<String, Object> {
        public GetNotificationTemplateByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetNotificationTemplateByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteNotificationTemplateByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteNotificationTemplateByFQNQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteNotificationTemplateByFQNQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteNotificationTemplateAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteNotificationTemplateAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteNotificationTemplateAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteNotificationTemplateQueryParams
    extends HashMap<String, Object> {
        public DeleteNotificationTemplateQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteNotificationTemplateQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

