/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.PermissionDebugInfo;
import org.openmetadata.client.model.PermissionEvaluationDebugInfo;
import org.openmetadata.client.model.ResourcePermissionList;

public interface PermissionsApi
extends ApiClient.Api {
    @RequestLine(value="GET /v1/permissions/debug/me")
    @Headers(value={"Accept: application/json"})
    public PermissionDebugInfo debugMyPermissions();

    @RequestLine(value="GET /v1/permissions/debug/me")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PermissionDebugInfo> debugMyPermissionsWithHttpInfo();

    @RequestLine(value="GET /v1/permissions/debug/evaluate?user={user}&resource={resource}&resourceId={resourceId}&operation={operation}")
    @Headers(value={"Accept: application/json"})
    public PermissionEvaluationDebugInfo debugPermissionEvaluation(@Param(value="user") @Nonnull String var1, @Param(value="resource") @Nonnull String var2, @Param(value="operation") @Nonnull String var3, @Param(value="resourceId") @Nullable String var4);

    @RequestLine(value="GET /v1/permissions/debug/evaluate?user={user}&resource={resource}&resourceId={resourceId}&operation={operation}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PermissionEvaluationDebugInfo> debugPermissionEvaluationWithHttpInfo(@Param(value="user") @Nonnull String var1, @Param(value="resource") @Nonnull String var2, @Param(value="operation") @Nonnull String var3, @Param(value="resourceId") @Nullable String var4);

    @RequestLine(value="GET /v1/permissions/debug/evaluate?user={user}&resource={resource}&resourceId={resourceId}&operation={operation}")
    @Headers(value={"Accept: application/json"})
    public PermissionEvaluationDebugInfo debugPermissionEvaluation(@QueryMap(encoded=true) DebugPermissionEvaluationQueryParams var1);

    @RequestLine(value="GET /v1/permissions/debug/evaluate?user={user}&resource={resource}&resourceId={resourceId}&operation={operation}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PermissionEvaluationDebugInfo> debugPermissionEvaluationWithHttpInfo(@QueryMap(encoded=true) DebugPermissionEvaluationQueryParams var1);

    @RequestLine(value="GET /v1/permissions/debug/user/{username}")
    @Headers(value={"Accept: application/json"})
    public PermissionDebugInfo debugUserPermissions(@Param(value="username") @Nonnull String var1);

    @RequestLine(value="GET /v1/permissions/debug/user/{username}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PermissionDebugInfo> debugUserPermissionsWithHttpInfo(@Param(value="username") @Nonnull String var1);

    @RequestLine(value="GET /v1/permissions/view/{entityType}")
    @Headers(value={"Accept: application/json"})
    public ResourcePermissionList getEntityTypeFieldPermissions(@Param(value="entityType") @Nonnull String var1);

    @RequestLine(value="GET /v1/permissions/view/{entityType}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ResourcePermissionList> getEntityTypeFieldPermissionsWithHttpInfo(@Param(value="entityType") @Nonnull String var1);

    @RequestLine(value="GET /v1/permissions/policies?ids={ids}")
    @Headers(value={"Accept: application/json"})
    public ResourcePermissionList getPermissionsForPolicies(@Param(value="ids") @Nullable List<UUID> var1);

    @RequestLine(value="GET /v1/permissions/policies?ids={ids}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ResourcePermissionList> getPermissionsForPoliciesWithHttpInfo(@Param(value="ids") @Nullable List<UUID> var1);

    @RequestLine(value="GET /v1/permissions/policies?ids={ids}")
    @Headers(value={"Accept: application/json"})
    public ResourcePermissionList getPermissionsForPolicies(@QueryMap(encoded=true) GetPermissionsForPoliciesQueryParams var1);

    @RequestLine(value="GET /v1/permissions/policies?ids={ids}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ResourcePermissionList> getPermissionsForPoliciesWithHttpInfo(@QueryMap(encoded=true) GetPermissionsForPoliciesQueryParams var1);

    @RequestLine(value="GET /v1/permissions/{resource}/{id}?user={user}")
    @Headers(value={"Accept: application/json"})
    public ResourcePermissionList getResourcePermission(@Param(value="resource") @Nonnull String var1, @Param(value="id") @Nonnull UUID var2, @Param(value="user") @Nullable String var3);

    @RequestLine(value="GET /v1/permissions/{resource}/{id}?user={user}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ResourcePermissionList> getResourcePermissionWithHttpInfo(@Param(value="resource") @Nonnull String var1, @Param(value="id") @Nonnull UUID var2, @Param(value="user") @Nullable String var3);

    @RequestLine(value="GET /v1/permissions/{resource}/{id}?user={user}")
    @Headers(value={"Accept: application/json"})
    public ResourcePermissionList getResourcePermission(@Param(value="resource") @Nonnull String var1, @Param(value="id") @Nonnull UUID var2, @QueryMap(encoded=true) GetResourcePermissionQueryParams var3);

    @RequestLine(value="GET /v1/permissions/{resource}/{id}?user={user}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ResourcePermissionList> getResourcePermissionWithHttpInfo(@Param(value="resource") @Nonnull String var1, @Param(value="id") @Nonnull UUID var2, @QueryMap(encoded=true) GetResourcePermissionQueryParams var3);

    @RequestLine(value="GET /v1/permissions/{resource}/name/{name}?user={user}")
    @Headers(value={"Accept: application/json"})
    public ResourcePermissionList getResourcePermissionByName(@Param(value="resource") @Nonnull String var1, @Param(value="name") @Nonnull String var2, @Param(value="user") @Nullable String var3);

    @RequestLine(value="GET /v1/permissions/{resource}/name/{name}?user={user}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ResourcePermissionList> getResourcePermissionByNameWithHttpInfo(@Param(value="resource") @Nonnull String var1, @Param(value="name") @Nonnull String var2, @Param(value="user") @Nullable String var3);

    @RequestLine(value="GET /v1/permissions/{resource}/name/{name}?user={user}")
    @Headers(value={"Accept: application/json"})
    public ResourcePermissionList getResourcePermissionByName(@Param(value="resource") @Nonnull String var1, @Param(value="name") @Nonnull String var2, @QueryMap(encoded=true) GetResourcePermissionByNameQueryParams var3);

    @RequestLine(value="GET /v1/permissions/{resource}/name/{name}?user={user}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ResourcePermissionList> getResourcePermissionByNameWithHttpInfo(@Param(value="resource") @Nonnull String var1, @Param(value="name") @Nonnull String var2, @QueryMap(encoded=true) GetResourcePermissionByNameQueryParams var3);

    @RequestLine(value="GET /v1/permissions?user={user}")
    @Headers(value={"Accept: application/json"})
    public ResourcePermissionList getResourcePermissions(@Param(value="user") @Nullable String var1);

    @RequestLine(value="GET /v1/permissions?user={user}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ResourcePermissionList> getResourcePermissionsWithHttpInfo(@Param(value="user") @Nullable String var1);

    @RequestLine(value="GET /v1/permissions?user={user}")
    @Headers(value={"Accept: application/json"})
    public ResourcePermissionList getResourcePermissions(@QueryMap(encoded=true) GetResourcePermissionsQueryParams var1);

    @RequestLine(value="GET /v1/permissions?user={user}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ResourcePermissionList> getResourcePermissionsWithHttpInfo(@QueryMap(encoded=true) GetResourcePermissionsQueryParams var1);

    @RequestLine(value="GET /v1/permissions/{resource}?user={user}")
    @Headers(value={"Accept: application/json"})
    public ResourcePermissionList getResourceTypePermission(@Param(value="resource") @Nonnull String var1, @Param(value="user") @Nullable String var2);

    @RequestLine(value="GET /v1/permissions/{resource}?user={user}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ResourcePermissionList> getResourceTypePermissionWithHttpInfo(@Param(value="resource") @Nonnull String var1, @Param(value="user") @Nullable String var2);

    @RequestLine(value="GET /v1/permissions/{resource}?user={user}")
    @Headers(value={"Accept: application/json"})
    public ResourcePermissionList getResourceTypePermission(@Param(value="resource") @Nonnull String var1, @QueryMap(encoded=true) GetResourceTypePermissionQueryParams var2);

    @RequestLine(value="GET /v1/permissions/{resource}?user={user}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ResourcePermissionList> getResourceTypePermissionWithHttpInfo(@Param(value="resource") @Nonnull String var1, @QueryMap(encoded=true) GetResourceTypePermissionQueryParams var2);

    public static class GetResourceTypePermissionQueryParams
    extends HashMap<String, Object> {
        public GetResourceTypePermissionQueryParams user(@Nullable String value) {
            this.put("user", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetResourcePermissionsQueryParams
    extends HashMap<String, Object> {
        public GetResourcePermissionsQueryParams user(@Nullable String value) {
            this.put("user", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetResourcePermissionByNameQueryParams
    extends HashMap<String, Object> {
        public GetResourcePermissionByNameQueryParams user(@Nullable String value) {
            this.put("user", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetResourcePermissionQueryParams
    extends HashMap<String, Object> {
        public GetResourcePermissionQueryParams user(@Nullable String value) {
            this.put("user", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetPermissionsForPoliciesQueryParams
    extends HashMap<String, Object> {
        public GetPermissionsForPoliciesQueryParams ids(@Nullable List<UUID> value) {
            this.put("ids", EncodingUtils.encodeCollection(value, "multi"));
            return this;
        }
    }

    public static class DebugPermissionEvaluationQueryParams
    extends HashMap<String, Object> {
        public DebugPermissionEvaluationQueryParams user(@Nonnull String value) {
            this.put("user", EncodingUtils.encode(value));
            return this;
        }

        public DebugPermissionEvaluationQueryParams resource(@Nonnull String value) {
            this.put("resource", EncodingUtils.encode(value));
            return this;
        }

        public DebugPermissionEvaluationQueryParams resourceId(@Nullable String value) {
            this.put("resourceId", EncodingUtils.encode(value));
            return this;
        }

        public DebugPermissionEvaluationQueryParams operation(@Nonnull String value) {
            this.put("operation", EncodingUtils.encode(value));
            return this;
        }
    }
}

