/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreatePipeline;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.Pipeline;
import org.openmetadata.client.model.PipelineList;
import org.openmetadata.client.model.PipelineStatus;
import org.openmetadata.client.model.PipelineStatusList;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.VoteRequest;

public interface PipelinesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/pipelines/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollower4(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/pipelines/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollower4WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/pipelines/{fqn}/status")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Pipeline addStatusData(@Param(value="fqn") @Nonnull String var1, @Nullable PipelineStatus var2);

    @RequestLine(value="PUT /v1/pipelines/{fqn}/status")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Pipeline> addStatusDataWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable PipelineStatus var2);

    @RequestLine(value="PUT /v1/pipelines")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Pipeline createOrUpdatePipeline(@Nullable CreatePipeline var1);

    @RequestLine(value="PUT /v1/pipelines")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Pipeline> createOrUpdatePipelineWithHttpInfo(@Nullable CreatePipeline var1);

    @RequestLine(value="POST /v1/pipelines")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Pipeline createPipeline(@Nullable CreatePipeline var1);

    @RequestLine(value="POST /v1/pipelines")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Pipeline> createPipelineWithHttpInfo(@Nullable CreatePipeline var1);

    @RequestLine(value="DELETE /v1/pipelines/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower7(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull UUID var2);

    @RequestLine(value="DELETE /v1/pipelines/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower7WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull UUID var2);

    @RequestLine(value="DELETE /v1/pipelines/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deletePipeline(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/pipelines/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePipelineWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/pipelines/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deletePipeline(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeletePipelineQueryParams var2);

    @RequestLine(value="DELETE /v1/pipelines/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePipelineWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeletePipelineQueryParams var2);

    @RequestLine(value="DELETE /v1/pipelines/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deletePipelineAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/pipelines/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePipelineAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/pipelines/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deletePipelineAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeletePipelineAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/pipelines/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePipelineAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeletePipelineAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/pipelines/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deletePipelineByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/pipelines/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePipelineByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/pipelines/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deletePipelineByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeletePipelineByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/pipelines/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePipelineByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeletePipelineByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/pipelines/{fqn}/status/{timestamp}")
    @Headers(value={"Accept: application/json"})
    public Pipeline deletePipelineStatus(@Param(value="fqn") @Nonnull String var1, @Param(value="timestamp") @Nonnull Long var2);

    @RequestLine(value="DELETE /v1/pipelines/{fqn}/status/{timestamp}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Pipeline> deletePipelineStatusWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="timestamp") @Nonnull Long var2);

    @RequestLine(value="GET /v1/pipelines/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Pipeline getPipelineByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/pipelines/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Pipeline> getPipelineByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/pipelines/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Pipeline getPipelineByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetPipelineByFQNQueryParams var2);

    @RequestLine(value="GET /v1/pipelines/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Pipeline> getPipelineByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetPipelineByFQNQueryParams var2);

    @RequestLine(value="GET /v1/pipelines/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Pipeline getPipelineWithID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/pipelines/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Pipeline> getPipelineWithIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/pipelines/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Pipeline getPipelineWithID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetPipelineWithIDQueryParams var2);

    @RequestLine(value="GET /v1/pipelines/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Pipeline> getPipelineWithIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetPipelineWithIDQueryParams var2);

    @RequestLine(value="GET /v1/pipelines/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Pipeline getSpecificPipelineVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/pipelines/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Pipeline> getSpecificPipelineVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/pipelines/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllPipelineVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/pipelines/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllPipelineVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/pipelines/{fqn}/status?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public PipelineStatusList listPipelineStatuses(@Param(value="fqn") @Nonnull String var1, @Param(value="startTs") @Nonnull BigDecimal var2, @Param(value="endTs") @Nonnull BigDecimal var3);

    @RequestLine(value="GET /v1/pipelines/{fqn}/status?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PipelineStatusList> listPipelineStatusesWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="startTs") @Nonnull BigDecimal var2, @Param(value="endTs") @Nonnull BigDecimal var3);

    @RequestLine(value="GET /v1/pipelines/{fqn}/status?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public PipelineStatusList listPipelineStatuses(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) ListPipelineStatusesQueryParams var2);

    @RequestLine(value="GET /v1/pipelines/{fqn}/status?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PipelineStatusList> listPipelineStatusesWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) ListPipelineStatusesQueryParams var2);

    @RequestLine(value="GET /v1/pipelines?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public PipelineList listPipelines(@Param(value="fields") @Nullable String var1, @Param(value="service") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/pipelines?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PipelineList> listPipelinesWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="service") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/pipelines?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public PipelineList listPipelines(@QueryMap(encoded=true) ListPipelinesQueryParams var1);

    @RequestLine(value="GET /v1/pipelines?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PipelineList> listPipelinesWithHttpInfo(@QueryMap(encoded=true) ListPipelinesQueryParams var1);

    @RequestLine(value="PATCH /v1/pipelines/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchPipeline(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/pipelines/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchPipelineWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/pipelines/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchPipeline1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/pipelines/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchPipeline1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/pipelines/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Pipeline restore22(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/pipelines/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Pipeline> restore22WithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/pipelines/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForEntity10(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    @RequestLine(value="PUT /v1/pipelines/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForEntity10WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    public static class ListPipelinesQueryParams
    extends HashMap<String, Object> {
        public ListPipelinesQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelinesQueryParams service(@Nullable String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelinesQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelinesQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelinesQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelinesQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListPipelineStatusesQueryParams
    extends HashMap<String, Object> {
        public ListPipelineStatusesQueryParams startTs(@Nonnull BigDecimal value) {
            this.put("startTs", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelineStatusesQueryParams endTs(@Nonnull BigDecimal value) {
            this.put("endTs", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetPipelineWithIDQueryParams
    extends HashMap<String, Object> {
        public GetPipelineWithIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetPipelineWithIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetPipelineByFQNQueryParams
    extends HashMap<String, Object> {
        public GetPipelineByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetPipelineByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeletePipelineByFQNQueryParams
    extends HashMap<String, Object> {
        public DeletePipelineByFQNQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeletePipelineByFQNQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeletePipelineAsyncQueryParams
    extends HashMap<String, Object> {
        public DeletePipelineAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeletePipelineAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeletePipelineQueryParams
    extends HashMap<String, Object> {
        public DeletePipelineQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeletePipelineQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }
}

