/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateQuery;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.Query;
import org.openmetadata.client.model.QueryList;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.VoteRequest;

public interface QueriesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/queries/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollower5(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="PUT /v1/queries/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollower5WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="PUT /v1/queries/{id}/usage")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Query addQueryUsage(@Param(value="id") @Nonnull UUID var1, @Nullable List<EntityReference> var2);

    @RequestLine(value="PUT /v1/queries/{id}/usage")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Query> addQueryUsageWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable List<EntityReference> var2);

    @RequestLine(value="PUT /v1/queries/{id}/usedBy")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Query addQueryUsedBy(@Param(value="id") @Nonnull UUID var1, @Nullable List<String> var2);

    @RequestLine(value="PUT /v1/queries/{id}/usedBy")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Query> addQueryUsedByWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable List<String> var2);

    @RequestLine(value="PUT /v1/queries/{id}/users")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Query addQueryUsers(@Param(value="id") @Nonnull UUID var1, @Nullable List<String> var2);

    @RequestLine(value="PUT /v1/queries/{id}/users")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Query> addQueryUsersWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable List<String> var2);

    @RequestLine(value="PUT /v1/queries")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Query createOrUpdateQuery(@Nullable CreateQuery var1);

    @RequestLine(value="PUT /v1/queries")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Query> createOrUpdateQueryWithHttpInfo(@Nullable CreateQuery var1);

    @RequestLine(value="POST /v1/queries")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public QueryList createQuery(@Nullable CreateQuery var1);

    @RequestLine(value="POST /v1/queries")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<QueryList> createQueryWithHttpInfo(@Nullable CreateQuery var1);

    @RequestLine(value="DELETE /v1/queries/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower8(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull UUID var2);

    @RequestLine(value="DELETE /v1/queries/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower8WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull UUID var2);

    @RequestLine(value="DELETE /v1/queries/{id}")
    @Headers(value={"Accept: application/json"})
    public void deleteQuery(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/queries/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteQueryWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/queries/async/{id}")
    @Headers(value={"Accept: application/json"})
    public void deleteQueryAsync(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/queries/async/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteQueryAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/queries/name/{fqn}")
    @Headers(value={"Accept: application/json"})
    public void deleteQueryByFQN(@Param(value="fqn") @Nonnull String var1);

    @RequestLine(value="DELETE /v1/queries/name/{fqn}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteQueryByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1);

    @RequestLine(value="GET /v1/queries/{id}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public Query getQueryById(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="GET /v1/queries/{id}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Query> getQueryByIdWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="GET /v1/queries/{id}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public Query getQueryById(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetQueryByIdQueryParams var2);

    @RequestLine(value="GET /v1/queries/{id}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Query> getQueryByIdWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetQueryByIdQueryParams var2);

    @RequestLine(value="GET /v1/queries/name/{fqn}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public Query getQueryFqn(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="GET /v1/queries/name/{fqn}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Query> getQueryFqnWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="GET /v1/queries/name/{fqn}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public Query getQueryFqn(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetQueryFqnQueryParams var2);

    @RequestLine(value="GET /v1/queries/name/{fqn}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Query> getQueryFqnWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetQueryFqnQueryParams var2);

    @RequestLine(value="GET /v1/queries/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Query getSpecificQueryVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/queries/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Query> getSpecificQueryVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/queries/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllQueryVersion(@Param(value="id") @Nonnull String var1);

    @RequestLine(value="GET /v1/queries/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllQueryVersionWithHttpInfo(@Param(value="id") @Nonnull String var1);

    @RequestLine(value="GET /v1/queries?fields={fields}&entityId={entityId}&service={service}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public QueryList listQueries(@Param(value="fields") @Nullable String var1, @Param(value="entityId") @Nullable UUID var2, @Param(value="service") @Nullable String var3, @Param(value="limit") @Nullable Integer var4, @Param(value="before") @Nullable String var5, @Param(value="after") @Nullable String var6);

    @RequestLine(value="GET /v1/queries?fields={fields}&entityId={entityId}&service={service}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<QueryList> listQueriesWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="entityId") @Nullable UUID var2, @Param(value="service") @Nullable String var3, @Param(value="limit") @Nullable Integer var4, @Param(value="before") @Nullable String var5, @Param(value="after") @Nullable String var6);

    @RequestLine(value="GET /v1/queries?fields={fields}&entityId={entityId}&service={service}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public QueryList listQueries(@QueryMap(encoded=true) ListQueriesQueryParams var1);

    @RequestLine(value="GET /v1/queries?fields={fields}&entityId={entityId}&service={service}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<QueryList> listQueriesWithHttpInfo(@QueryMap(encoded=true) ListQueriesQueryParams var1);

    @RequestLine(value="PATCH /v1/queries/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchQuery(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/queries/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchQueryWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/queries/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchQuery1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/queries/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchQuery1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="DELETE /v1/queries/{id}/usage")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Query removeQueryUsedIn(@Param(value="id") @Nonnull UUID var1, @Nullable List<EntityReference> var2);

    @RequestLine(value="DELETE /v1/queries/{id}/usage")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Query> removeQueryUsedInWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable List<EntityReference> var2);

    @RequestLine(value="PUT /v1/queries/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Query restore24(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/queries/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Query> restore24WithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/queries/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForEntity11(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    @RequestLine(value="PUT /v1/queries/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForEntity11WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    public static class ListQueriesQueryParams
    extends HashMap<String, Object> {
        public ListQueriesQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListQueriesQueryParams entityId(@Nullable UUID value) {
            this.put("entityId", EncodingUtils.encode(value));
            return this;
        }

        public ListQueriesQueryParams service(@Nullable String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListQueriesQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListQueriesQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListQueriesQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetQueryFqnQueryParams
    extends HashMap<String, Object> {
        public GetQueryFqnQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetQueryByIdQueryParams
    extends HashMap<String, Object> {
        public GetQueryByIdQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }
}

