/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.SparqlQuery;

public interface RdfApi
extends ApiClient.Api {
    @RequestLine(value="GET /v1/rdf/graph/explore?entityId={entityId}&entityType={entityType}&depth={depth}")
    @Headers(value={"Accept: application/json"})
    public void exploreEntityGraph(@Param(value="entityId") @Nonnull UUID var1, @Param(value="entityType") @Nonnull String var2, @Param(value="depth") @Nullable Integer var3);

    @RequestLine(value="GET /v1/rdf/graph/explore?entityId={entityId}&entityType={entityType}&depth={depth}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> exploreEntityGraphWithHttpInfo(@Param(value="entityId") @Nonnull UUID var1, @Param(value="entityType") @Nonnull String var2, @Param(value="depth") @Nullable Integer var3);

    @RequestLine(value="GET /v1/rdf/graph/explore?entityId={entityId}&entityType={entityType}&depth={depth}")
    @Headers(value={"Accept: application/json"})
    public void exploreEntityGraph(@QueryMap(encoded=true) ExploreEntityGraphQueryParams var1);

    @RequestLine(value="GET /v1/rdf/graph/explore?entityId={entityId}&entityType={entityType}&depth={depth}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> exploreEntityGraphWithHttpInfo(@QueryMap(encoded=true) ExploreEntityGraphQueryParams var1);

    @RequestLine(value="GET /v1/rdf/search/similar/{entityType}/{id}?limit={limit}")
    @Headers(value={"Accept: application/json"})
    public void findSimilarEntities(@Param(value="entityType") @Nonnull String var1, @Param(value="id") @Nonnull UUID var2, @Param(value="limit") @Nullable Integer var3);

    @RequestLine(value="GET /v1/rdf/search/similar/{entityType}/{id}?limit={limit}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> findSimilarEntitiesWithHttpInfo(@Param(value="entityType") @Nonnull String var1, @Param(value="id") @Nonnull UUID var2, @Param(value="limit") @Nullable Integer var3);

    @RequestLine(value="GET /v1/rdf/search/similar/{entityType}/{id}?limit={limit}")
    @Headers(value={"Accept: application/json"})
    public void findSimilarEntities(@Param(value="entityType") @Nonnull String var1, @Param(value="id") @Nonnull UUID var2, @QueryMap(encoded=true) FindSimilarEntitiesQueryParams var3);

    @RequestLine(value="GET /v1/rdf/search/similar/{entityType}/{id}?limit={limit}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> findSimilarEntitiesWithHttpInfo(@Param(value="entityType") @Nonnull String var1, @Param(value="id") @Nonnull UUID var2, @QueryMap(encoded=true) FindSimilarEntitiesQueryParams var3);

    @RequestLine(value="GET /v1/rdf/entity/{entityType}/{id}?format={format}")
    @Headers(value={"Accept: application/ld+json,application/n-triples,application/rdf+xml,text/turtle"})
    public void getEntityAsRdf(@Param(value="entityType") @Nonnull String var1, @Param(value="id") @Nonnull UUID var2, @Param(value="format") @Nullable String var3);

    @RequestLine(value="GET /v1/rdf/entity/{entityType}/{id}?format={format}")
    @Headers(value={"Accept: application/ld+json,application/n-triples,application/rdf+xml,text/turtle"})
    public ApiResponse<Void> getEntityAsRdfWithHttpInfo(@Param(value="entityType") @Nonnull String var1, @Param(value="id") @Nonnull UUID var2, @Param(value="format") @Nullable String var3);

    @RequestLine(value="GET /v1/rdf/entity/{entityType}/{id}?format={format}")
    @Headers(value={"Accept: application/ld+json,application/n-triples,application/rdf+xml,text/turtle"})
    public void getEntityAsRdf(@Param(value="entityType") @Nonnull String var1, @Param(value="id") @Nonnull UUID var2, @QueryMap(encoded=true) GetEntityAsRdfQueryParams var3);

    @RequestLine(value="GET /v1/rdf/entity/{entityType}/{id}?format={format}")
    @Headers(value={"Accept: application/ld+json,application/n-triples,application/rdf+xml,text/turtle"})
    public ApiResponse<Void> getEntityAsRdfWithHttpInfo(@Param(value="entityType") @Nonnull String var1, @Param(value="id") @Nonnull UUID var2, @QueryMap(encoded=true) GetEntityAsRdfQueryParams var3);

    @RequestLine(value="GET /v1/rdf/inference/lineage/{entityId}?entityType={entityType}&direction={direction}")
    @Headers(value={"Accept: application/json"})
    public void getFullLineage(@Param(value="entityId") @Nonnull UUID var1, @Param(value="entityType") @Nonnull String var2, @Param(value="direction") @Nullable String var3);

    @RequestLine(value="GET /v1/rdf/inference/lineage/{entityId}?entityType={entityType}&direction={direction}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> getFullLineageWithHttpInfo(@Param(value="entityId") @Nonnull UUID var1, @Param(value="entityType") @Nonnull String var2, @Param(value="direction") @Nullable String var3);

    @RequestLine(value="GET /v1/rdf/inference/lineage/{entityId}?entityType={entityType}&direction={direction}")
    @Headers(value={"Accept: application/json"})
    public void getFullLineage(@Param(value="entityId") @Nonnull UUID var1, @QueryMap(encoded=true) GetFullLineageQueryParams var2);

    @RequestLine(value="GET /v1/rdf/inference/lineage/{entityId}?entityType={entityType}&direction={direction}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> getFullLineageWithHttpInfo(@Param(value="entityId") @Nonnull UUID var1, @QueryMap(encoded=true) GetFullLineageQueryParams var2);

    @RequestLine(value="GET /v1/rdf/status")
    @Headers(value={"Accept: application/json"})
    public void getRdfStatus();

    @RequestLine(value="GET /v1/rdf/status")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> getRdfStatusWithHttpInfo();

    @RequestLine(value="GET /v1/rdf/search/recommendations/{userId}?type={type}&limit={limit}")
    @Headers(value={"Accept: application/json"})
    public void getRecommendations(@Param(value="userId") @Nonnull UUID var1, @Param(value="type") @Nullable String var2, @Param(value="limit") @Nullable Integer var3);

    @RequestLine(value="GET /v1/rdf/search/recommendations/{userId}?type={type}&limit={limit}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> getRecommendationsWithHttpInfo(@Param(value="userId") @Nonnull UUID var1, @Param(value="type") @Nullable String var2, @Param(value="limit") @Nullable Integer var3);

    @RequestLine(value="GET /v1/rdf/search/recommendations/{userId}?type={type}&limit={limit}")
    @Headers(value={"Accept: application/json"})
    public void getRecommendations(@Param(value="userId") @Nonnull UUID var1, @QueryMap(encoded=true) GetRecommendationsQueryParams var2);

    @RequestLine(value="GET /v1/rdf/search/recommendations/{userId}?type={type}&limit={limit}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> getRecommendationsWithHttpInfo(@Param(value="userId") @Nonnull UUID var1, @QueryMap(encoded=true) GetRecommendationsQueryParams var2);

    @RequestLine(value="GET /v1/rdf/sparql?query={query}&format={format}&inference={inference}")
    @Headers(value={"Accept: application/json"})
    public void querySparqlGet(@Param(value="query") @Nonnull String var1, @Param(value="format") @Nullable String var2, @Param(value="inference") @Nullable String var3);

    @RequestLine(value="GET /v1/rdf/sparql?query={query}&format={format}&inference={inference}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> querySparqlGetWithHttpInfo(@Param(value="query") @Nonnull String var1, @Param(value="format") @Nullable String var2, @Param(value="inference") @Nullable String var3);

    @RequestLine(value="GET /v1/rdf/sparql?query={query}&format={format}&inference={inference}")
    @Headers(value={"Accept: application/json"})
    public void querySparqlGet(@QueryMap(encoded=true) QuerySparqlGetQueryParams var1);

    @RequestLine(value="GET /v1/rdf/sparql?query={query}&format={format}&inference={inference}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> querySparqlGetWithHttpInfo(@QueryMap(encoded=true) QuerySparqlGetQueryParams var1);

    @RequestLine(value="POST /v1/rdf/sparql")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void querySparqlPost(@Nullable SparqlQuery var1);

    @RequestLine(value="POST /v1/rdf/sparql")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> querySparqlPostWithHttpInfo(@Nullable SparqlQuery var1);

    @RequestLine(value="GET /v1/rdf/search/semantic?q={q}&type={type}&limit={limit}")
    @Headers(value={"Accept: application/json"})
    public void semanticSearch(@Param(value="q") @Nonnull String var1, @Param(value="type") @Nullable String var2, @Param(value="limit") @Nullable Integer var3);

    @RequestLine(value="GET /v1/rdf/search/semantic?q={q}&type={type}&limit={limit}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> semanticSearchWithHttpInfo(@Param(value="q") @Nonnull String var1, @Param(value="type") @Nullable String var2, @Param(value="limit") @Nullable Integer var3);

    @RequestLine(value="GET /v1/rdf/search/semantic?q={q}&type={type}&limit={limit}")
    @Headers(value={"Accept: application/json"})
    public void semanticSearch(@QueryMap(encoded=true) SemanticSearchQueryParams var1);

    @RequestLine(value="GET /v1/rdf/search/semantic?q={q}&type={type}&limit={limit}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> semanticSearchWithHttpInfo(@QueryMap(encoded=true) SemanticSearchQueryParams var1);

    @RequestLine(value="POST /v1/rdf/sparql/update")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void updateSparql(@Nonnull SparqlQuery var1);

    @RequestLine(value="POST /v1/rdf/sparql/update")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> updateSparqlWithHttpInfo(@Nonnull SparqlQuery var1);

    public static class SemanticSearchQueryParams
    extends HashMap<String, Object> {
        public SemanticSearchQueryParams q(@Nonnull String value) {
            this.put("q", EncodingUtils.encode(value));
            return this;
        }

        public SemanticSearchQueryParams type(@Nullable String value) {
            this.put("type", EncodingUtils.encode(value));
            return this;
        }

        public SemanticSearchQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class QuerySparqlGetQueryParams
    extends HashMap<String, Object> {
        public QuerySparqlGetQueryParams query(@Nonnull String value) {
            this.put("query", EncodingUtils.encode(value));
            return this;
        }

        public QuerySparqlGetQueryParams format(@Nullable String value) {
            this.put("format", EncodingUtils.encode(value));
            return this;
        }

        public QuerySparqlGetQueryParams inference(@Nullable String value) {
            this.put("inference", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetRecommendationsQueryParams
    extends HashMap<String, Object> {
        public GetRecommendationsQueryParams type(@Nullable String value) {
            this.put("type", EncodingUtils.encode(value));
            return this;
        }

        public GetRecommendationsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetFullLineageQueryParams
    extends HashMap<String, Object> {
        public GetFullLineageQueryParams entityType(@Nonnull String value) {
            this.put("entityType", EncodingUtils.encode(value));
            return this;
        }

        public GetFullLineageQueryParams direction(@Nullable String value) {
            this.put("direction", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetEntityAsRdfQueryParams
    extends HashMap<String, Object> {
        public GetEntityAsRdfQueryParams format(@Nullable String value) {
            this.put("format", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class FindSimilarEntitiesQueryParams
    extends HashMap<String, Object> {
        public FindSimilarEntitiesQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ExploreEntityGraphQueryParams
    extends HashMap<String, Object> {
        public ExploreEntityGraphQueryParams entityId(@Nonnull UUID value) {
            this.put("entityId", EncodingUtils.encode(value));
            return this;
        }

        public ExploreEntityGraphQueryParams entityType(@Nonnull String value) {
            this.put("entityType", EncodingUtils.encode(value));
            return this;
        }

        public ExploreEntityGraphQueryParams depth(@Nullable Integer value) {
            this.put("depth", EncodingUtils.encode(value));
            return this;
        }
    }
}

