/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CreateRole;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.Role;
import org.openmetadata.client.model.RoleList;

public interface RolesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/roles")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Role createOrUpdateRole(@Nullable CreateRole var1);

    @RequestLine(value="PUT /v1/roles")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Role> createOrUpdateRoleWithHttpInfo(@Nullable CreateRole var1);

    @RequestLine(value="POST /v1/roles")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Role createRole(@Nullable CreateRole var1);

    @RequestLine(value="POST /v1/roles")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Role> createRoleWithHttpInfo(@Nullable CreateRole var1);

    @RequestLine(value="DELETE /v1/roles/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteRole(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/roles/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteRoleWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/roles/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteRole(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteRoleQueryParams var2);

    @RequestLine(value="DELETE /v1/roles/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteRoleWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteRoleQueryParams var2);

    @RequestLine(value="DELETE /v1/roles/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteRoleAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/roles/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteRoleAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/roles/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteRoleAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteRoleAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/roles/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteRoleAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteRoleAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/roles/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteRoleByName(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/roles/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteRoleByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/roles/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteRoleByName(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteRoleByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/roles/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteRoleByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteRoleByNameQueryParams var2);

    @RequestLine(value="GET /v1/roles/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Role getRoleByFQN(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/roles/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Role> getRoleByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/roles/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Role getRoleByFQN(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetRoleByFQNQueryParams var2);

    @RequestLine(value="GET /v1/roles/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Role> getRoleByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetRoleByFQNQueryParams var2);

    @RequestLine(value="GET /v1/roles/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Role getRoleByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/roles/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Role> getRoleByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/roles/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Role getRoleByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetRoleByIDQueryParams var2);

    @RequestLine(value="GET /v1/roles/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Role> getRoleByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetRoleByIDQueryParams var2);

    @RequestLine(value="GET /v1/roles/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Role getSpecificRoleVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/roles/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Role> getSpecificRoleVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/roles/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllRoleVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/roles/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllRoleVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/roles?default={_default}&fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public RoleList listRoles(@Param(value="_default") @Nullable Boolean var1, @Param(value="fields") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/roles?default={_default}&fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<RoleList> listRolesWithHttpInfo(@Param(value="_default") @Nullable Boolean var1, @Param(value="fields") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/roles?default={_default}&fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public RoleList listRoles(@QueryMap(encoded=true) ListRolesQueryParams var1);

    @RequestLine(value="GET /v1/roles?default={_default}&fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<RoleList> listRolesWithHttpInfo(@QueryMap(encoded=true) ListRolesQueryParams var1);

    @RequestLine(value="PATCH /v1/roles/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchRole(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/roles/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchRoleWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/roles/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchRole1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/roles/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchRole1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/roles/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Role restore39(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/roles/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Role> restore39WithHttpInfo(@Nullable RestoreEntity var1);

    public static class ListRolesQueryParams
    extends HashMap<String, Object> {
        public ListRolesQueryParams _default(@Nullable Boolean value) {
            this.put("default", EncodingUtils.encode(value));
            return this;
        }

        public ListRolesQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListRolesQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListRolesQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListRolesQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListRolesQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetRoleByIDQueryParams
    extends HashMap<String, Object> {
        public GetRoleByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetRoleByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetRoleByFQNQueryParams
    extends HashMap<String, Object> {
        public GetRoleByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetRoleByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteRoleByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteRoleByNameQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteRoleAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteRoleAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteRoleQueryParams
    extends HashMap<String, Object> {
        public DeleteRoleQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

