/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.AggregationRequest;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.PreviewSearchRequest;
import org.openmetadata.client.model.SearchResponse;
import org.openmetadata.client.model.Suggest;

public interface SearchApi
extends ApiClient.Api {
    @RequestLine(value="POST /v1/search/aggregate")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public SearchResponse aggregateSearchRequest(@Nullable AggregationRequest var1);

    @RequestLine(value="POST /v1/search/aggregate")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public ApiResponse<SearchResponse> aggregateSearchRequestWithHttpInfo(@Nullable AggregationRequest var1);

    @RequestLine(value="GET /v1/search/aggregate?index={index}&field={field}&value={value}&sourceFields={sourceFields}&q={q}&size={size}&deleted={deleted}")
    @Headers(value={"Accept: application/json"})
    public Suggest getAggregateFields(@Param(value="q") @Nonnull String var1, @Param(value="index") @Nullable String var2, @Param(value="field") @Nullable String var3, @Param(value="value") @Nullable String var4, @Param(value="sourceFields") @Nullable String var5, @Param(value="size") @Nullable Integer var6, @Param(value="deleted") @Nullable Boolean var7);

    @RequestLine(value="GET /v1/search/aggregate?index={index}&field={field}&value={value}&sourceFields={sourceFields}&q={q}&size={size}&deleted={deleted}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Suggest> getAggregateFieldsWithHttpInfo(@Param(value="q") @Nonnull String var1, @Param(value="index") @Nullable String var2, @Param(value="field") @Nullable String var3, @Param(value="value") @Nullable String var4, @Param(value="sourceFields") @Nullable String var5, @Param(value="size") @Nullable Integer var6, @Param(value="deleted") @Nullable Boolean var7);

    @RequestLine(value="GET /v1/search/aggregate?index={index}&field={field}&value={value}&sourceFields={sourceFields}&q={q}&size={size}&deleted={deleted}")
    @Headers(value={"Accept: application/json"})
    public Suggest getAggregateFields(@QueryMap(encoded=true) GetAggregateFieldsQueryParams var1);

    @RequestLine(value="GET /v1/search/aggregate?index={index}&field={field}&value={value}&sourceFields={sourceFields}&q={q}&size={size}&deleted={deleted}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Suggest> getAggregateFieldsWithHttpInfo(@QueryMap(encoded=true) GetAggregateFieldsQueryParams var1);

    @RequestLine(value="GET /v1/search/entityTypeCounts?q={q}&index={index}&deleted={deleted}&query_filter={queryFilter}&post_filter={postFilter}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse getEntityTypeCounts(@Param(value="q") @Nonnull String var1, @Param(value="index") @Nullable String var2, @Param(value="deleted") @Nullable Boolean var3, @Param(value="queryFilter") @Nullable String var4, @Param(value="postFilter") @Nullable String var5);

    @RequestLine(value="GET /v1/search/entityTypeCounts?q={q}&index={index}&deleted={deleted}&query_filter={queryFilter}&post_filter={postFilter}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> getEntityTypeCountsWithHttpInfo(@Param(value="q") @Nonnull String var1, @Param(value="index") @Nullable String var2, @Param(value="deleted") @Nullable Boolean var3, @Param(value="queryFilter") @Nullable String var4, @Param(value="postFilter") @Nullable String var5);

    @RequestLine(value="GET /v1/search/entityTypeCounts?q={q}&index={index}&deleted={deleted}&query_filter={queryFilter}&post_filter={postFilter}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse getEntityTypeCounts(@QueryMap(encoded=true) GetEntityTypeCountsQueryParams var1);

    @RequestLine(value="GET /v1/search/entityTypeCounts?q={q}&index={index}&deleted={deleted}&query_filter={queryFilter}&post_filter={postFilter}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> getEntityTypeCountsWithHttpInfo(@QueryMap(encoded=true) GetEntityTypeCountsQueryParams var1);

    @RequestLine(value="POST /v1/search/preview")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public SearchResponse previewSearch(@Nonnull PreviewSearchRequest var1);

    @RequestLine(value="POST /v1/search/preview")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<SearchResponse> previewSearchWithHttpInfo(@Nonnull PreviewSearchRequest var1);

    @RequestLine(value="POST /v1/search/reindexEntities?recreate={recreate}&timeoutMinutes={timeoutMinutes}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public SearchResponse reindexOnlySelectedEntities(@Param(value="recreate") @Nullable Boolean var1, @Param(value="timeoutMinutes") @Nullable Integer var2, @Nullable List<EntityReference> var3);

    @RequestLine(value="POST /v1/search/reindexEntities?recreate={recreate}&timeoutMinutes={timeoutMinutes}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public ApiResponse<SearchResponse> reindexOnlySelectedEntitiesWithHttpInfo(@Param(value="recreate") @Nullable Boolean var1, @Param(value="timeoutMinutes") @Nullable Integer var2, @Nullable List<EntityReference> var3);

    @RequestLine(value="POST /v1/search/reindexEntities?recreate={recreate}&timeoutMinutes={timeoutMinutes}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public SearchResponse reindexOnlySelectedEntities(@Nullable List<EntityReference> var1, @QueryMap(encoded=true) ReindexOnlySelectedEntitiesQueryParams var2);

    @RequestLine(value="POST /v1/search/reindexEntities?recreate={recreate}&timeoutMinutes={timeoutMinutes}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public ApiResponse<SearchResponse> reindexOnlySelectedEntitiesWithHttpInfo(@Nullable List<EntityReference> var1, @QueryMap(encoded=true) ReindexOnlySelectedEntitiesQueryParams var2);

    @RequestLine(value="GET /v1/search/nlq/query?q={q}&index={index}&deleted={deleted}&from={from}&size={size}&search_after={searchAfter}&sort_field={sortField}&sort_order={sortOrder}&track_total_hits={trackTotalHits}&query_filter={queryFilter}&post_filter={postFilter}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}&exclude_source_fields={excludeSourceFields}&getHierarchy={getHierarchy}&explain={explain}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchEntitiesWithNLQ(@Param(value="q") @Nullable String var1, @Param(value="index") @Nullable String var2, @Param(value="deleted") @Nullable Boolean var3, @Param(value="from") @Nullable Integer var4, @Param(value="size") @Nullable Integer var5, @Param(value="searchAfter") @Nullable String var6, @Param(value="sortField") @Nullable String var7, @Param(value="sortOrder") @Nullable String var8, @Param(value="trackTotalHits") @Nullable Boolean var9, @Param(value="queryFilter") @Nullable String var10, @Param(value="postFilter") @Nullable String var11, @Param(value="fetchSource") @Nullable Boolean var12, @Param(value="includeSourceFields") @Nullable List<String> var13, @Param(value="excludeSourceFields") @Nullable List<String> var14, @Param(value="getHierarchy") @Nullable Boolean var15, @Param(value="explain") @Nullable Boolean var16);

    @RequestLine(value="GET /v1/search/nlq/query?q={q}&index={index}&deleted={deleted}&from={from}&size={size}&search_after={searchAfter}&sort_field={sortField}&sort_order={sortOrder}&track_total_hits={trackTotalHits}&query_filter={queryFilter}&post_filter={postFilter}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}&exclude_source_fields={excludeSourceFields}&getHierarchy={getHierarchy}&explain={explain}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchEntitiesWithNLQWithHttpInfo(@Param(value="q") @Nullable String var1, @Param(value="index") @Nullable String var2, @Param(value="deleted") @Nullable Boolean var3, @Param(value="from") @Nullable Integer var4, @Param(value="size") @Nullable Integer var5, @Param(value="searchAfter") @Nullable String var6, @Param(value="sortField") @Nullable String var7, @Param(value="sortOrder") @Nullable String var8, @Param(value="trackTotalHits") @Nullable Boolean var9, @Param(value="queryFilter") @Nullable String var10, @Param(value="postFilter") @Nullable String var11, @Param(value="fetchSource") @Nullable Boolean var12, @Param(value="includeSourceFields") @Nullable List<String> var13, @Param(value="excludeSourceFields") @Nullable List<String> var14, @Param(value="getHierarchy") @Nullable Boolean var15, @Param(value="explain") @Nullable Boolean var16);

    @RequestLine(value="GET /v1/search/nlq/query?q={q}&index={index}&deleted={deleted}&from={from}&size={size}&search_after={searchAfter}&sort_field={sortField}&sort_order={sortOrder}&track_total_hits={trackTotalHits}&query_filter={queryFilter}&post_filter={postFilter}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}&exclude_source_fields={excludeSourceFields}&getHierarchy={getHierarchy}&explain={explain}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchEntitiesWithNLQ(@QueryMap(encoded=true) SearchEntitiesWithNLQQueryParams var1);

    @RequestLine(value="GET /v1/search/nlq/query?q={q}&index={index}&deleted={deleted}&from={from}&size={size}&search_after={searchAfter}&sort_field={sortField}&sort_order={sortOrder}&track_total_hits={trackTotalHits}&query_filter={queryFilter}&post_filter={postFilter}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}&exclude_source_fields={excludeSourceFields}&getHierarchy={getHierarchy}&explain={explain}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchEntitiesWithNLQWithHttpInfo(@QueryMap(encoded=true) SearchEntitiesWithNLQQueryParams var1);

    @RequestLine(value="GET /v1/search/query?q={q}&index={index}&deleted={deleted}&from={from}&size={size}&search_after={searchAfter}&sort_field={sortField}&sort_order={sortOrder}&track_total_hits={trackTotalHits}&query_filter={queryFilter}&post_filter={postFilter}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}&exclude_source_fields={excludeSourceFields}&getHierarchy={getHierarchy}&explain={explain}&semanticSearch={semanticSearch}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchEntitiesWithQuery(@Param(value="q") @Nonnull String var1, @Param(value="index") @Nullable String var2, @Param(value="deleted") @Nullable Boolean var3, @Param(value="from") @Nullable Integer var4, @Param(value="size") @Nullable Integer var5, @Param(value="searchAfter") @Nullable String var6, @Param(value="sortField") @Nullable String var7, @Param(value="sortOrder") @Nullable String var8, @Param(value="trackTotalHits") @Nullable Boolean var9, @Param(value="queryFilter") @Nullable String var10, @Param(value="postFilter") @Nullable String var11, @Param(value="fetchSource") @Nullable Boolean var12, @Param(value="includeSourceFields") @Nullable List<String> var13, @Param(value="excludeSourceFields") @Nullable List<String> var14, @Param(value="getHierarchy") @Nullable Boolean var15, @Param(value="explain") @Nullable Boolean var16, @Param(value="semanticSearch") @Nullable Boolean var17);

    @RequestLine(value="GET /v1/search/query?q={q}&index={index}&deleted={deleted}&from={from}&size={size}&search_after={searchAfter}&sort_field={sortField}&sort_order={sortOrder}&track_total_hits={trackTotalHits}&query_filter={queryFilter}&post_filter={postFilter}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}&exclude_source_fields={excludeSourceFields}&getHierarchy={getHierarchy}&explain={explain}&semanticSearch={semanticSearch}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchEntitiesWithQueryWithHttpInfo(@Param(value="q") @Nonnull String var1, @Param(value="index") @Nullable String var2, @Param(value="deleted") @Nullable Boolean var3, @Param(value="from") @Nullable Integer var4, @Param(value="size") @Nullable Integer var5, @Param(value="searchAfter") @Nullable String var6, @Param(value="sortField") @Nullable String var7, @Param(value="sortOrder") @Nullable String var8, @Param(value="trackTotalHits") @Nullable Boolean var9, @Param(value="queryFilter") @Nullable String var10, @Param(value="postFilter") @Nullable String var11, @Param(value="fetchSource") @Nullable Boolean var12, @Param(value="includeSourceFields") @Nullable List<String> var13, @Param(value="excludeSourceFields") @Nullable List<String> var14, @Param(value="getHierarchy") @Nullable Boolean var15, @Param(value="explain") @Nullable Boolean var16, @Param(value="semanticSearch") @Nullable Boolean var17);

    @RequestLine(value="GET /v1/search/query?q={q}&index={index}&deleted={deleted}&from={from}&size={size}&search_after={searchAfter}&sort_field={sortField}&sort_order={sortOrder}&track_total_hits={trackTotalHits}&query_filter={queryFilter}&post_filter={postFilter}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}&exclude_source_fields={excludeSourceFields}&getHierarchy={getHierarchy}&explain={explain}&semanticSearch={semanticSearch}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchEntitiesWithQuery(@QueryMap(encoded=true) SearchEntitiesWithQueryQueryParams var1);

    @RequestLine(value="GET /v1/search/query?q={q}&index={index}&deleted={deleted}&from={from}&size={size}&search_after={searchAfter}&sort_field={sortField}&sort_order={sortOrder}&track_total_hits={trackTotalHits}&query_filter={queryFilter}&post_filter={postFilter}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}&exclude_source_fields={excludeSourceFields}&getHierarchy={getHierarchy}&explain={explain}&semanticSearch={semanticSearch}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchEntitiesWithQueryWithHttpInfo(@QueryMap(encoded=true) SearchEntitiesWithQueryQueryParams var1);

    @RequestLine(value="GET /v1/search/sourceUrl?sourceUrl={sourceUrl}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchEntitiesWithSourceUrl(@Param(value="sourceUrl") @Nullable String var1);

    @RequestLine(value="GET /v1/search/sourceUrl?sourceUrl={sourceUrl}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchEntitiesWithSourceUrlWithHttpInfo(@Param(value="sourceUrl") @Nullable String var1);

    @RequestLine(value="GET /v1/search/sourceUrl?sourceUrl={sourceUrl}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchEntitiesWithSourceUrl(@QueryMap(encoded=true) SearchEntitiesWithSourceUrlQueryParams var1);

    @RequestLine(value="GET /v1/search/sourceUrl?sourceUrl={sourceUrl}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchEntitiesWithSourceUrlWithHttpInfo(@QueryMap(encoded=true) SearchEntitiesWithSourceUrlQueryParams var1);

    @RequestLine(value="GET /v1/search/fieldQuery?fieldName={fieldName}&fieldValue={fieldValue}&index={index}&deleted={deleted}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchEntitiesWithSpecificFieldAndValue(@Param(value="fieldName") @Nullable String var1, @Param(value="fieldValue") @Nullable String var2, @Param(value="index") @Nullable String var3, @Param(value="deleted") @Nullable Boolean var4);

    @RequestLine(value="GET /v1/search/fieldQuery?fieldName={fieldName}&fieldValue={fieldValue}&index={index}&deleted={deleted}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchEntitiesWithSpecificFieldAndValueWithHttpInfo(@Param(value="fieldName") @Nullable String var1, @Param(value="fieldValue") @Nullable String var2, @Param(value="index") @Nullable String var3, @Param(value="deleted") @Nullable Boolean var4);

    @RequestLine(value="GET /v1/search/fieldQuery?fieldName={fieldName}&fieldValue={fieldValue}&index={index}&deleted={deleted}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchEntitiesWithSpecificFieldAndValue(@QueryMap(encoded=true) SearchEntitiesWithSpecificFieldAndValueQueryParams var1);

    @RequestLine(value="GET /v1/search/fieldQuery?fieldName={fieldName}&fieldValue={fieldValue}&index={index}&deleted={deleted}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchEntitiesWithSpecificFieldAndValueWithHttpInfo(@QueryMap(encoded=true) SearchEntitiesWithSpecificFieldAndValueQueryParams var1);

    @RequestLine(value="GET /v1/search/get/{index}/doc/{id}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchEntityInEsIndexWithId(@Param(value="id") @Nonnull UUID var1, @Param(value="index") @Nonnull String var2);

    @RequestLine(value="GET /v1/search/get/{index}/doc/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchEntityInEsIndexWithIdWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="index") @Nonnull String var2);

    public static class SearchEntitiesWithSpecificFieldAndValueQueryParams
    extends HashMap<String, Object> {
        public SearchEntitiesWithSpecificFieldAndValueQueryParams fieldName(@Nullable String value) {
            this.put("fieldName", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithSpecificFieldAndValueQueryParams fieldValue(@Nullable String value) {
            this.put("fieldValue", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithSpecificFieldAndValueQueryParams index(@Nullable String value) {
            this.put("index", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithSpecificFieldAndValueQueryParams deleted(@Nullable Boolean value) {
            this.put("deleted", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class SearchEntitiesWithSourceUrlQueryParams
    extends HashMap<String, Object> {
        public SearchEntitiesWithSourceUrlQueryParams sourceUrl(@Nullable String value) {
            this.put("sourceUrl", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class SearchEntitiesWithQueryQueryParams
    extends HashMap<String, Object> {
        public SearchEntitiesWithQueryQueryParams q(@Nonnull String value) {
            this.put("q", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams index(@Nullable String value) {
            this.put("index", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams deleted(@Nullable Boolean value) {
            this.put("deleted", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams from(@Nullable Integer value) {
            this.put("from", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams size(@Nullable Integer value) {
            this.put("size", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams searchAfter(@Nullable String value) {
            this.put("search_after", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams sortField(@Nullable String value) {
            this.put("sort_field", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams sortOrder(@Nullable String value) {
            this.put("sort_order", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams trackTotalHits(@Nullable Boolean value) {
            this.put("track_total_hits", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams queryFilter(@Nullable String value) {
            this.put("query_filter", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams postFilter(@Nullable String value) {
            this.put("post_filter", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams fetchSource(@Nullable Boolean value) {
            this.put("fetch_source", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams includeSourceFields(@Nullable List<String> value) {
            this.put("include_source_fields", EncodingUtils.encodeCollection(value, "multi"));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams excludeSourceFields(@Nullable List<String> value) {
            this.put("exclude_source_fields", EncodingUtils.encodeCollection(value, "multi"));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams getHierarchy(@Nullable Boolean value) {
            this.put("getHierarchy", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams explain(@Nullable Boolean value) {
            this.put("explain", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams semanticSearch(@Nullable Boolean value) {
            this.put("semanticSearch", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class SearchEntitiesWithNLQQueryParams
    extends HashMap<String, Object> {
        public SearchEntitiesWithNLQQueryParams q(@Nullable String value) {
            this.put("q", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams index(@Nullable String value) {
            this.put("index", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams deleted(@Nullable Boolean value) {
            this.put("deleted", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams from(@Nullable Integer value) {
            this.put("from", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams size(@Nullable Integer value) {
            this.put("size", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams searchAfter(@Nullable String value) {
            this.put("search_after", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams sortField(@Nullable String value) {
            this.put("sort_field", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams sortOrder(@Nullable String value) {
            this.put("sort_order", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams trackTotalHits(@Nullable Boolean value) {
            this.put("track_total_hits", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams queryFilter(@Nullable String value) {
            this.put("query_filter", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams postFilter(@Nullable String value) {
            this.put("post_filter", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams fetchSource(@Nullable Boolean value) {
            this.put("fetch_source", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams includeSourceFields(@Nullable List<String> value) {
            this.put("include_source_fields", EncodingUtils.encodeCollection(value, "multi"));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams excludeSourceFields(@Nullable List<String> value) {
            this.put("exclude_source_fields", EncodingUtils.encodeCollection(value, "multi"));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams getHierarchy(@Nullable Boolean value) {
            this.put("getHierarchy", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams explain(@Nullable Boolean value) {
            this.put("explain", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ReindexOnlySelectedEntitiesQueryParams
    extends HashMap<String, Object> {
        public ReindexOnlySelectedEntitiesQueryParams recreate(@Nullable Boolean value) {
            this.put("recreate", EncodingUtils.encode(value));
            return this;
        }

        public ReindexOnlySelectedEntitiesQueryParams timeoutMinutes(@Nullable Integer value) {
            this.put("timeoutMinutes", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetEntityTypeCountsQueryParams
    extends HashMap<String, Object> {
        public GetEntityTypeCountsQueryParams q(@Nonnull String value) {
            this.put("q", EncodingUtils.encode(value));
            return this;
        }

        public GetEntityTypeCountsQueryParams index(@Nullable String value) {
            this.put("index", EncodingUtils.encode(value));
            return this;
        }

        public GetEntityTypeCountsQueryParams deleted(@Nullable Boolean value) {
            this.put("deleted", EncodingUtils.encode(value));
            return this;
        }

        public GetEntityTypeCountsQueryParams queryFilter(@Nullable String value) {
            this.put("query_filter", EncodingUtils.encode(value));
            return this;
        }

        public GetEntityTypeCountsQueryParams postFilter(@Nullable String value) {
            this.put("post_filter", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetAggregateFieldsQueryParams
    extends HashMap<String, Object> {
        public GetAggregateFieldsQueryParams index(@Nullable String value) {
            this.put("index", EncodingUtils.encode(value));
            return this;
        }

        public GetAggregateFieldsQueryParams field(@Nullable String value) {
            this.put("field", EncodingUtils.encode(value));
            return this;
        }

        public GetAggregateFieldsQueryParams value(@Nullable String value) {
            this.put("value", EncodingUtils.encode(value));
            return this;
        }

        public GetAggregateFieldsQueryParams sourceFields(@Nullable String value) {
            this.put("sourceFields", EncodingUtils.encode(value));
            return this;
        }

        public GetAggregateFieldsQueryParams q(@Nonnull String value) {
            this.put("q", EncodingUtils.encode(value));
            return this;
        }

        public GetAggregateFieldsQueryParams size(@Nullable Integer value) {
            this.put("size", EncodingUtils.encode(value));
            return this;
        }

        public GetAggregateFieldsQueryParams deleted(@Nullable Boolean value) {
            this.put("deleted", EncodingUtils.encode(value));
            return this;
        }
    }
}

